/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import net.refractions.udig.filter.ComboExpressionViewer;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.MarkEditorPage;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.part.PageBook;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Symbolizer;

public class PointEditorPage
extends StyleEditorPage {
    private static int standardPadding = 2;
    Composite listComposite;
    List representationList;
    Button listAddButton;
    Button listUpButton;
    Button listDownButton;
    Button listRemoveButton;
    Composite graphicComposite;
    ComboExpressionViewer opacityViewer;
    ComboExpressionViewer sizeViewer;
    ComboExpressionViewer rotationViewer;
    ComboExpressionViewer anchorXViewer;
    ComboExpressionViewer anchorYViewer;
    ComboExpressionViewer displacementXViewer;
    ComboExpressionViewer displacementYViewer;
    PageBook graphicBook;
    Composite externalGraphicPage;
    MarkEditorPage markComponent;
    private static FilterFactoryImpl factory;

    @Override
    public void createPageContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createListContent(parent);
        this.createGraphicBook(parent);
        this.createGraphicContent(parent);
    }

    private void applyStyle() {
        FeatureTypeStyle defaultStyle = null;
        for (FeatureTypeStyle typeStyle : this.getStyle().featureTypeStyles()) {
            if (!typeStyle.getName().equals("Default Styler")) continue;
            defaultStyle = typeStyle;
            break;
        }
        if (defaultStyle == null) {
            return;
        }
        Rule rule = (Rule)defaultStyle.rules().get(0);
        PointSymbolizer sym = null;
        for (Symbolizer symbolizer : rule.symbolizers()) {
            if (!(symbolizer instanceof PointSymbolizer)) continue;
            sym = (PointSymbolizer)symbolizer;
            break;
        }
        if (sym == null) {
            SLD.POINT.createDefault();
            rule.symbolizers().add(sym);
        }
        Graphic g = sym.getGraphic();
        g.getOpacity();
        g.getRotation();
        g.getSize();
        g.getAnchorPoint();
        g.getDisplacement();
    }

    private void createListContent(Composite parent) {
        this.listComposite = new Composite(parent, 0);
        this.listComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.listComposite.setLayout((Layout)new GridLayout(2, false));
        this.representationList = new List(this.listComposite, -1);
        this.representationList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.representationList.setItems(this.getGraphicRepresentations());
        this.representationList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PointEditorPage.this.listRemoveButton.setEnabled(true);
                if (PointEditorPage.this.representationList.getSelectionIndex() == 0) {
                    PointEditorPage.this.listUpButton.setEnabled(false);
                } else {
                    PointEditorPage.this.listUpButton.setEnabled(true);
                }
                if (PointEditorPage.this.representationList.getSelectionIndex() == PointEditorPage.this.representationList.getItemCount() - 1) {
                    PointEditorPage.this.listDownButton.setEnabled(false);
                } else {
                    PointEditorPage.this.listDownButton.setEnabled(true);
                }
            }
        });
        Composite buttonComposite = new Composite(this.listComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        buttonComposite.setLayout((Layout)new FormLayout());
        this.listAddButton = new Button(buttonComposite, 8);
        this.listAddButton.setText("Add");
        FormData data = new FormData();
        data.left = new FormAttachment(0, standardPadding);
        data.top = new FormAttachment(0, standardPadding);
        this.listAddButton.setLayoutData((Object)data);
        this.listUpButton = new Button(buttonComposite, 8);
        this.listUpButton.setText("Move Up");
        data = new FormData();
        data.left = new FormAttachment((Control)this.listAddButton, 0, 16384);
        data.top = new FormAttachment((Control)this.listAddButton, standardPadding * 3);
        this.listUpButton.setLayoutData((Object)data);
        this.listUpButton.setEnabled(false);
        this.listDownButton = new Button(buttonComposite, 8);
        this.listDownButton.setText("Move Down");
        data = new FormData();
        data.left = new FormAttachment((Control)this.listAddButton, 0, 16384);
        data.top = new FormAttachment((Control)this.listUpButton, standardPadding);
        this.listDownButton.setLayoutData((Object)data);
        this.listDownButton.setEnabled(false);
        this.listRemoveButton = new Button(buttonComposite, 8);
        this.listRemoveButton.setText("Remove");
        data = new FormData();
        data.top = new FormAttachment((Control)this.listDownButton, standardPadding * 3);
        data.left = new FormAttachment((Control)this.listAddButton, 0, 16384);
        data.bottom = new FormAttachment(100, -1 * standardPadding);
        this.listRemoveButton.setLayoutData((Object)data);
        this.listRemoveButton.setEnabled(false);
    }

    private void createGraphicContent(Composite parent) {
        this.graphicComposite = new Composite(parent, 0);
        this.graphicComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        this.graphicComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(this.graphicComposite, 0);
        label.setText(Messages.StylingConstants_label_opacity);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setToolTipText(Messages.StylingConstants_tooltip_opacity);
        this.opacityViewer = new ComboExpressionViewer(this.graphicComposite, 4);
        this.opacityViewer.setOptions(this.getOpacityList());
        this.opacityViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.opacityViewer.getControl().setToolTipText(Messages.StylingConstants_label_opacity);
        label = new Label(this.graphicComposite, 0);
        label.setText(Messages.StylingConstants_label_size);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setToolTipText(Messages.StylingConstants_tooltip_size);
        this.sizeViewer = new ComboExpressionViewer(this.graphicComposite, 4);
        this.sizeViewer.setOptions(this.getSizeList());
        GridData gd = new GridData(4, 4, true, false);
        GC gc = new GC((Drawable)this.sizeViewer.getControl());
        try {
            Point extent = gc.textExtent("X");
            gd.widthHint = 3 * extent.x;
        }
        finally {
            gc.dispose();
        }
        this.sizeViewer.getControl().setLayoutData((Object)gd);
        this.sizeViewer.getControl().setToolTipText(Messages.StylingConstants_tooltip_size);
        label = new Label(this.graphicComposite, 0);
        label.setText(Messages.StylingConstants_label_rotation);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setToolTipText(Messages.StylingConstants_tooltip_rotation);
        this.rotationViewer = new ComboExpressionViewer(this.graphicComposite, 4);
        this.rotationViewer.setOptions(this.getRotationList());
        this.rotationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.rotationViewer.getControl().setToolTipText(Messages.StylingConstants_tooltip_rotation);
        label = new Label(this.graphicComposite, 0);
        label.setText(Messages.StylingConstants_label_anchor);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setToolTipText(Messages.StylingConstants_tooltip_anchor);
        Composite anchorComposite = new Composite(this.graphicComposite, 0);
        anchorComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        anchorComposite.setLayout((Layout)new FormLayout());
        this.anchorXViewer = new ComboExpressionViewer(anchorComposite, 4);
        this.anchorXViewer.setOptions(this.getAnchorList());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.anchorXViewer.getControl().setLayoutData((Object)data);
        this.anchorXViewer.getControl().setToolTipText(Messages.StylingConstants_tooltip_anchor);
        label = new Label(anchorComposite, 0);
        label.setText("X");
        data = new FormData();
        data.left = new FormAttachment(this.anchorXViewer.getControl(), 4);
        data.bottom = new FormAttachment(this.anchorXViewer.getControl(), 0, 1024);
        label.setLayoutData((Object)data);
        label.setToolTipText(Messages.StylingConstants_tooltip_anchor);
        this.anchorYViewer = new ComboExpressionViewer(anchorComposite, 4);
        this.anchorYViewer.setOptions(this.getAnchorList());
        data = new FormData();
        data.left = new FormAttachment((Control)label, 4);
        data.top = new FormAttachment(this.anchorXViewer.getControl(), 0, 128);
        data.bottom = new FormAttachment(this.anchorXViewer.getControl(), 0, 1024);
        data.right = new FormAttachment(100, 0);
        this.anchorYViewer.getControl().setLayoutData((Object)data);
        this.anchorYViewer.getControl().setToolTipText(Messages.StylingConstants_tooltip_anchor);
        label = new Label(this.graphicComposite, 0);
        label.setText(Messages.StylingConstants_label_displacement);
        label.setLayoutData((Object)new GridData(16384, 4, false, false));
        label.setToolTipText(Messages.StylingConstants_tooltip_displacement);
        Composite displacementComposite = new Composite(this.graphicComposite, 0);
        displacementComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        displacementComposite.setLayout((Layout)new FormLayout());
        this.displacementXViewer = new ComboExpressionViewer(displacementComposite, 4);
        this.displacementXViewer.setOptions(this.getDisplacementList());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.displacementXViewer.getControl().setLayoutData((Object)data);
        this.displacementXViewer.getControl().setToolTipText(Messages.StylingConstants_tooltip_displacement);
        label = new Label(displacementComposite, 0);
        label.setText("X");
        data = new FormData();
        data.left = new FormAttachment(this.displacementXViewer.getControl(), 4, 131072);
        data.bottom = new FormAttachment(this.displacementXViewer.getControl(), 0, 1024);
        label.setLayoutData((Object)data);
        label.setToolTipText(Messages.StylingConstants_tooltip_displacement);
        this.displacementYViewer = new ComboExpressionViewer(displacementComposite, 4);
        this.displacementYViewer.setOptions(this.getDisplacementList());
        data = new FormData();
        data.left = new FormAttachment((Control)label, 4, 131072);
        data.top = new FormAttachment(this.displacementXViewer.getControl(), 0, 128);
        data.bottom = new FormAttachment(this.displacementXViewer.getControl(), 0, 1024);
        data.right = new FormAttachment(100, 0);
        this.displacementYViewer.getControl().setLayoutData((Object)data);
        this.displacementYViewer.getControl().setToolTipText(Messages.StylingConstants_tooltip_displacement);
    }

    private void createGraphicBook(Composite parent) {
        this.graphicBook = new PageBook(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        this.graphicBook.setLayoutData((Object)gd);
        this.markComponent = new MarkEditorPage();
        this.markComponent.createControl((Composite)this.graphicBook);
        this.markComponent.markComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.graphicBook.showPage(this.markComponent.getControl());
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public void gotFocus() {
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void styleChanged(Object source) {
    }

    @Override
    public boolean okToLeave() {
        return true;
    }

    @Override
    public boolean performApply() {
        return true;
    }

    @Override
    public boolean performOk() {
        return true;
    }

    @Override
    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterFactoryImpl getFilterFactory() {
        if (factory == null) {
            FilterFactoryImpl filterFactoryImpl = factory;
            synchronized (filterFactoryImpl) {
                if (factory == null) {
                    factory = new FilterFactoryImpl();
                }
            }
        }
        return factory;
    }

    private String[] getGraphicRepresentations() {
        return new String[]{"External Graphic (PNG)", "External Graphic (BMP)", "Well Known Mark (Star)"};
    }

    private String[] getOpacityList() {
        return new String[]{"Clear", "25%", "50%", "75%", "Opaque"};
    }

    private int[] getSizeList() {
        return new int[]{1, 2, 3, 5, 10, 12, 15, 20};
    }

    private String[] getRotationList() {
        return new String[]{"-150\ufffd", "-135\ufffd", "-120\ufffd", "-90\ufffd", "-60\ufffd", "-45\ufffd", "-30\ufffd", "0\ufffd", "30\ufffd", "45\ufffd", "60\ufffd", "90\ufffd", "120\ufffd", "135\ufffd", "150\ufffd", "180\ufffd"};
    }

    private String[] getAnchorList() {
        return new String[]{"0%", "25%", "50%", "75%", "100%"};
    }

    private int[] getDisplacementList() {
        return new int[]{1, 2, 3, 5, 10, 12, 15, 20};
    }

    private Combo generateFancyCombo(Composite parent, String[] items, int style) {
        return this.generateFancyCombo(parent, items, true, -1, style);
    }

    private Combo generateFancyCombo(Composite parent, String[] items, boolean hasDefault, int selection, int style) {
        final Combo fancyCombo = new Combo(parent, style);
        fancyCombo.setItems(items);
        if (selection >= 0 && selection < items.length) {
            fancyCombo.select(selection);
        }
        if (hasDefault) {
            fancyCombo.add(Messages.PointEditorPage_fancyCombo_default, 0);
            if (selection < 0 || selection >= items.length) {
                fancyCombo.select(0);
            }
        } else if (selection < 0 || selection >= items.length) {
            fancyCombo.add(Messages.PointEditorPage_fancyCombo_unselected, 0);
            fancyCombo.select(0);
            SelectionListener listener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    fancyCombo.remove(0);
                    fancyCombo.removeSelectionListener((SelectionListener)this);
                    SLDPlugin.log("Removing selection listener", null);
                }
            };
            fancyCombo.addSelectionListener(listener);
        }
        return fancyCombo;
    }
}

