/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.lang.reflect.Field;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.style.sld.editor.EditorPageManager;
import net.refractions.udig.style.sld.editor.StyleEditorDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenStyleEditorAction
extends Action
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String ATT_LABEL = "label";
    public static final String ATT_REQUIRES = "requires";
    public static final String STYLE_ID = "net.refractions.udig.style.sld";
    private Layer selectedLayer;
    private Plugin plugin;
    private IWorkbenchWindow workbenchWindow;

    public OpenStyleEditorAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public OpenStyleEditorAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("net.refractions.style.sld.editor");
    }

    public void run(IAction action) {
        if (this.workbenchWindow == null) {
            return;
        }
        Shell shell = this.workbenchWindow.getShell();
        String pageId = "simple";
        try {
            Field idField;
            Class<?> pointClass;
            if (SLD.POINT.supports((ILayer)this.selectedLayer)) {
                pointClass = Class.forName("eu.udig.style.advanced.editorpages.SimplePointEditorPage");
                idField = pointClass.getField("ID");
                Object value = idField.get(null);
                pageId = value.toString();
            } else if (SLD.LINE.supports((ILayer)this.selectedLayer)) {
                pointClass = Class.forName("eu.udig.style.advanced.editorpages.SimpleLineEditorPage");
                idField = pointClass.getField("ID");
                Object value = idField.get(null);
                pageId = value.toString();
            } else if (SLD.POLYGON.supports((ILayer)this.selectedLayer)) {
                pointClass = Class.forName("eu.udig.style.advanced.editorpages.SimplePolygonEditorPage");
                idField = pointClass.getField("ID");
                Object value = idField.get(null);
                pageId = value.toString();
            } else if (this.selectedLayer.getGeoResource().getInfo((IProgressMonitor)new NullProgressMonitor()).getDescription().equals("grassbinaryraster")) {
                pointClass = Class.forName("eu.udig.style.jgrass.colors.JGrassRasterStyleEditorPage");
                idField = pointClass.getField("ID");
                Object value = idField.get(null);
                pageId = value.toString();
            }
        }
        catch (Exception exception) {
            pageId = "simple";
        }
        EditorPageManager manager = EditorPageManager.loadManager(this.plugin, (ILayer)this.selectedLayer);
        StyleEditorDialog dialog = StyleEditorDialog.createDialogOn(shell, pageId, this.selectedLayer, manager);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sselection = (IStructuredSelection)selection;
        if (sselection.getFirstElement() instanceof Layer) {
            this.selectedLayer = (Layer)sselection.getFirstElement();
        }
    }

    public void dispose() {
        this.plugin = null;
        this.workbenchWindow = null;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void init(IViewPart view) {
    }
}

