/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.util.EventObject;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.filter.ExpressionViewer;
import net.refractions.udig.style.sld.IStyleEditorPageContainer;
import net.refractions.udig.style.sld.SLDContentManager;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Stroke;

public class LineEditorPage
extends StyleEditorPage {
    protected StyleBuilder sb = new StyleBuilder();
    private ExpressionViewer size;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            LineEditorPage.this.sync((EventObject)event);
        }
    };
    private ExpressionViewer color;

    @Override
    public void createPageContent(Composite parent) {
        int required = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        parent.setLayout((Layout)new MigLayout("", "[right]" + required + "[left,grow]"));
        Label label = new Label(parent, 16384);
        label.setText("Size");
        this.size = new ExpressionViewer(parent, 2052);
        this.size.setRequired(true);
        this.size.getControl().setLayoutData((Object)"growx, wrap");
        label = new Label(parent, 16384);
        label.setText("Color");
        this.color = new ExpressionViewer(parent, 2052);
        this.color.getControl().setLayoutData((Object)"growx, wrap");
        this.listen(true);
    }

    private void listen(boolean listen) {
        if (listen) {
            this.size.addSelectionChangedListener(this.listener);
            this.color.addSelectionChangedListener(this.listener);
        } else {
            this.size.removeSelectionChangedListener(this.listener);
            this.size.removeSelectionChangedListener(this.listener);
        }
    }

    @Override
    public String getErrorMessage() {
        String message = null;
        if (message != null && this.size.getInput() == Expression.NIL) {
            message = "Size is required";
        }
        return message;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public void gotFocus() {
        this.refresh();
        this.size.getControl().setFocus();
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void styleChanged(Object source) {
        System.out.println(source);
        this.refresh();
    }

    @Override
    public boolean okToLeave() {
        return this.getErrorMessage() == null;
    }

    @Override
    public boolean performApply() {
        return true;
    }

    org.geotools.styling.Stroke toStroke(LineSymbolizer lineSymbolizer) {
        org.geotools.styling.Stroke stroke = SLDs.stroke((LineSymbolizer)lineSymbolizer);
        if (stroke == null) {
            stroke = this.sb.createStroke();
            lineSymbolizer.setStroke((Stroke)stroke);
        }
        return stroke;
    }

    void sync(EventObject event) {
        Object source;
        SLDContentManager content = new SLDContentManager(this.sb, this.getContainer().getStyle());
        LineSymbolizer lineSymbolizer = content.getSymbolizer(LineSymbolizer.class);
        Object object = source = event != null ? event.getSource() : null;
        if (source == null || source == this.size) {
            this.toStroke(lineSymbolizer).setWidth(this.size.getInput());
        }
        if (source == null || source == this.color) {
            this.toStroke(lineSymbolizer).setColor(this.color.getInput());
        }
    }

    @Override
    public boolean performOk() {
        return this.performApply();
    }

    @Override
    public void refresh() {
        IStyleEditorPageContainer container = this.getContainer();
        Style style = container.getStyle();
        LineSymbolizer lineSymbolizer = SLDs.lineSymbolizer((Style)style);
        try {
            this.listen(false);
            if (lineSymbolizer == null) {
                this.size.getControl().setEnabled(false);
                this.size.setInput(Expression.NIL);
                this.color.getControl().setEnabled(false);
                this.color.setInput(Expression.NIL);
                return;
            }
            org.geotools.styling.Stroke stroke = lineSymbolizer.getStroke();
            if (stroke == null) {
                this.size.setInput(Expression.NIL);
                this.color.setInput(Expression.NIL);
            }
            this.size.setInput(stroke.getWidth());
            this.size.getControl().setEnabled(true);
            this.color.setInput(stroke.getColor());
            this.color.getControl().setEnabled(true);
        }
        finally {
            this.listen(true);
        }
    }
}

