/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExportTo
implements IOp {
    public boolean canExport(Object target) {
        return target != null;
    }

    public void exportTo(Object target, File file, IProgressMonitor monitor) throws Exception {
    }

    public String prompt(Object target) {
        return Messages.ExportTo_title;
    }

    public String defaultName(Object target) {
        return Messages.ImportExport_new;
    }

    public String[] getFilterExtentions() {
        ArrayList<String> filters = new ArrayList<String>();
        String[] stringArray = this.getExtentions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extention = stringArray[n2];
            filters.add("*." + extention);
            ++n2;
        }
        return filters.toArray(new String[filters.size()]);
    }

    public String[] getExtentions() {
        return new String[]{"*"};
    }

    public String[] getFilterNames() {
        return new String[]{Messages.ImportExport_all_files};
    }

    public File promptFile(Display display, Object target) {
        String name = this.defaultName(target);
        String prompt = this.prompt(target);
        FileDialog fileDialog = new FileDialog(display.getActiveShell(), 8192);
        fileDialog.setFilterExtensions(this.getFilterExtentions());
        fileDialog.setFilterNames(this.getFilterNames());
        fileDialog.setFileName(String.valueOf(name) + "." + this.getExtentions()[0]);
        fileDialog.setText(prompt);
        String path = fileDialog.open();
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.exists()) {
            boolean replace = MessageDialog.openConfirm((Shell)display.getActiveShell(), (String)prompt, (String)MessageFormat.format(Messages.ExportTo_file_exists, file.getAbsolutePath()));
            if (!replace) {
                return null;
            }
            file.delete();
        }
        return file;
    }

    public void op(Display display, Object target, IProgressMonitor monitor) throws Exception {
        if (!this.canExport(target)) {
            return;
        }
        PromptAndExport prompt = new PromptAndExport(display, target, monitor);
        display.syncExec((Runnable)prompt);
        File file = prompt.getFile();
        this.status(MessageFormat.format(Messages.ExportTo_writing, file));
        this.exportTo(target, file, monitor);
        this.status(MessageFormat.format(Messages.ExportTo_finished, file));
    }

    public void status(final String msg) {
        final IStatusLineManager statusBar = this.getStatusBar();
        Display display = Display.getCurrent();
        if (statusBar == null || display == null) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                statusBar.setMessage(msg);
            }
        });
    }

    private IStatusLineManager getStatusBar() {
        IEditorSite site = this.getEditorSite();
        if (site == null) {
            return null;
        }
        return site.getActionBars().getStatusLineManager();
    }

    private IEditorSite getEditorSite() {
        IWorkbenchWindow window = this.getWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart part = page.getActiveEditor();
        if (part == null) {
            return null;
        }
        return (IEditorSite)part.getSite();
    }

    private IWorkbenchWindow getWindow() {
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench == null) {
            return null;
        }
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null && bench.getWorkbenchWindowCount() > 0) {
            window = bench.getWorkbenchWindows()[0];
        }
        return window;
    }

    public String[] addTo(String[] more, String[] original) {
        int offset = more.length;
        String[] newArray = new String[original.length + offset];
        int i = 0;
        while (i < offset) {
            newArray[i] = more[i];
            ++i;
        }
        i = 0;
        while (i < original.length) {
            newArray[i + offset] = original[i];
            ++i;
        }
        return newArray;
    }

    protected class PromptAndExport
    implements Runnable {
        Display display;
        Object target;
        File file;

        public PromptAndExport(Display display, Object target, IProgressMonitor monitor) {
            this.display = display;
            this.target = target;
        }

        @Override
        public void run() {
            this.file = ExportTo.this.promptFile(this.display, this.target);
        }

        File getFile() {
            return this.file;
        }
    }
}

