/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.ExportTo;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.StyledLayerDescriptor;

public class ExportSLD
extends ExportTo {
    @Override
    public boolean canExport(Object target) {
        return super.canExport(target);
    }

    @Override
    public String defaultName(Object target) {
        StyledLayerDescriptor sld;
        String filename = null;
        if (target instanceof Layer) {
            Layer layer = (Layer)target;
            filename = layer.getName();
        } else if (target instanceof StyledLayerDescriptor && (filename = (sld = (StyledLayerDescriptor)target).getTitle()) == null) {
            filename = sld.getName();
        }
        if (filename == null) {
            filename = Messages.ImportExport_new;
        }
        filename = filename.replace(':', '_');
        return String.valueOf(filename) + " " + Messages.ImportExport_selected;
    }

    @Override
    public String prompt(Object target) {
        return Messages.ExportSLD_export;
    }

    @Override
    public String[] getExtentions() {
        return this.addTo(new String[]{"sld"}, super.getExtentions());
    }

    @Override
    public void exportTo(Object target, File file, IProgressMonitor monitor) throws Exception {
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String xml = "";
        if (!(target instanceof StyledLayerDescriptor)) {
            SLDPlugin.log("StyledLayerDescriptor not found", null);
            throw new IOException("SLD not found");
        }
        StyledLayerDescriptor sld = (StyledLayerDescriptor)target;
        xml = aTransformer.transform((Object)sld);
        FileWriter w = new FileWriter(file);
        w.write(xml);
        w.close();
    }

    @Override
    public String[] getFilterNames() {
        return this.addTo(new String[]{Messages.ImportExportSLD_document}, super.getFilterNames());
    }
}

