/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.style.IStyleConfigurator;
import net.refractions.udig.style.sld.IEditorPage;
import net.refractions.udig.style.sld.IEditorPageContainer;
import net.refractions.udig.style.sld.IStyleEditorPage;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.style.sld.editor.StyleEditorPageAdapter;
import net.refractions.udig.style.sld.editor.internal.IEditorNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.registry.KeywordRegistry;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EditorNode
implements IPluginContribution,
IEditorNode {
    private static final String TAG_KEYWORD_REFERENCE = "keywordReference";
    public static final String ATT_CLASS = "class";
    public static final String ATT_ID = "id";
    public static final String ATT_ICON = "icon";
    public static final String ATT_LABEL = "label";
    public static final String ATT_CATEGORY = "category";
    public static final String ATT_REQUIRES = "requires";
    private Collection<String> keywordReferences;
    private IConfigurationElement configurationElement;
    private ImageDescriptor imageDescriptor;
    private Image image;
    private IEditorPage page;
    private List<EditorNode> subNodes;
    private String classname;
    private String id;
    private String label;
    private Collection<String> keywordLabelCache;

    public EditorNode(String id, IConfigurationElement configurationElement) {
        this(id);
        this.configurationElement = configurationElement;
    }

    public Collection<String> getKeywordReferences() {
        if (this.keywordReferences == null) {
            IConfigurationElement[] references = this.getConfigurationElement().getChildren(TAG_KEYWORD_REFERENCE);
            HashSet<String> list = new HashSet<String>(references.length);
            int i = 0;
            while (i < references.length) {
                IConfigurationElement page = references[i];
                String id = page.getAttribute(ATT_ID);
                if (id != null) {
                    list.add(id);
                }
                ++i;
            }
            this.keywordReferences = !list.isEmpty() ? list : Collections.emptySet();
        }
        return this.keywordReferences;
    }

    public Collection<String> getKeywordLabels() {
        if (this.keywordLabelCache != null) {
            return this.keywordLabelCache;
        }
        Collection<String> refs = this.getKeywordReferences();
        if (refs == Collections.EMPTY_SET) {
            this.keywordLabelCache = Collections.emptySet();
            return this.keywordLabelCache;
        }
        this.keywordLabelCache = new ArrayList<String>(refs.size());
        Iterator<String> referenceIterator = refs.iterator();
        while (referenceIterator.hasNext()) {
            String label = KeywordRegistry.getInstance().getKeywordLabel(referenceIterator.next());
            if (label == null) continue;
            this.keywordLabelCache.add(label);
        }
        return this.keywordLabelCache;
    }

    public void clearKeywords() {
        this.keywordLabelCache = null;
    }

    @Override
    public void disposeResources() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
        this.configurationElement = null;
        this.imageDescriptor = null;
    }

    @Override
    public Image getLabelImage() {
        ImageDescriptor desc;
        if (this.image == null && (desc = this.getImageDescriptor()) != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    @Override
    public String getLabelText() {
        return this.getConfigurationElement().getAttribute(ATT_LABEL);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String imageName = this.getConfigurationElement().getAttribute(ATT_ICON);
        if (imageName != null) {
            String contributingPluginId = this.getConfigurationElement().getNamespaceIdentifier();
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)contributingPluginId, (String)imageName);
        }
        return this.imageDescriptor;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.getConfigurationElement().getNamespaceIdentifier();
    }

    @Override
    public void createPage(Composite parent, IEditorPageContainer container) {
        StyleEditorPage page;
        block6: {
            try {
                Object pageInstance = EditorNode.createExtension(this.getConfigurationElement(), ATT_CLASS);
                if (pageInstance instanceof IStyleConfigurator) {
                    page = new StyleEditorPageAdapter((IStyleConfigurator)pageInstance);
                    break block6;
                }
                if (pageInstance instanceof StyleEditorPage) {
                    page = (StyleEditorPage)pageInstance;
                    break block6;
                }
                return;
            }
            catch (CoreException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        page.setContainer(container);
        page.init(PlatformUI.getWorkbench());
        if (page.getControl() == null) {
            page.createControl(parent);
        }
        if (this.getLabelImage() != null) {
            page.setImageDescriptor(this.getImageDescriptor());
        }
        page.setTitle(this.getLabelText());
        this.setPage(page);
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute(ATT_CATEGORY);
    }

    public String getRequires() {
        String requires = null;
        try {
            requires = this.getConfigurationElement().getAttribute(ATT_REQUIRES);
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
        return requires;
    }

    public EditorNode(String id) {
        Assert.isNotNull((Object)id);
        this.id = id;
    }

    public EditorNode(String id, String label, ImageDescriptor image, String className) {
        this(id);
        this.imageDescriptor = image;
        Assert.isNotNull((Object)label);
        this.label = label;
        this.classname = className;
    }

    public EditorNode(String id, IEditorPage page) {
        this(id);
        Assert.isNotNull((Object)page);
        this.page = page;
    }

    public void add(EditorNode node) {
        if (this.subNodes == null) {
            this.subNodes = new ArrayList<EditorNode>();
        }
        this.subNodes.add(node);
    }

    @Override
    public EditorNode findSubNode(String id) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((id.length() > 0 ? 1 : 0) != 0);
        if (this.subNodes == null) {
            return null;
        }
        int size = this.subNodes.size();
        int i = 0;
        while (i < size) {
            EditorNode node = this.subNodes.get(i);
            if (id.equals(node.getId())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IEditorPage getPage() {
        return this.page;
    }

    public EditorNode[] getSubNodes() {
        if (this.subNodes == null) {
            return new EditorNode[0];
        }
        return this.subNodes.toArray(new EditorNode[this.subNodes.size()]);
    }

    @Override
    public EditorNode remove(String id) {
        EditorNode node = this.findSubNode(id);
        if (node != null) {
            this.remove(node);
        }
        return node;
    }

    public boolean remove(EditorNode node) {
        if (this.subNodes == null) {
            return false;
        }
        return this.subNodes.remove(node);
    }

    public void setPage(IStyleEditorPage newPage) {
        this.page = newPage;
    }

    @Override
    public void add(IEditorNode node) {
        System.out.println("ADD called, but no code here");
    }

    @Override
    public boolean remove(IEditorNode node) {
        return false;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        try {
            if (BundleUtility.isActivated((String)element.getDeclaringExtension().getNamespaceIdentifier())) {
                return element.createExecutableExtension(classAttribute);
            }
            final Object[] ret = new Object[1];
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                }
            });
            if (exc[0] != null) {
                throw exc[0];
            }
            return ret[0];
        }
        catch (CoreException core) {
            throw core;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "net.refractions.udig.style.sld", 4, WorkbenchMessages.WorkbenchPlugin_extension, (Throwable)e));
        }
    }

    public String getClassname() {
        return this.classname;
    }

    public String getLabel() {
        return this.label;
    }
}

