/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.refractions.udig.style.sld.editor.CustomSampleScheme;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;
import org.geotools.brewer.color.PaletteSuitability;
import org.geotools.brewer.color.PaletteType;
import org.geotools.brewer.color.SampleScheme;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CustomPalettesLoader
implements IStartup {
    public static final List<BrewerPalette> PALETTESLIST = new ArrayList<BrewerPalette>();

    public void earlyStartup() {
        if (PALETTESLIST.size() > 0) {
            return;
        }
        URL palettesFolderUrl = Platform.getBundle((String)"net.refractions.udig.style.sld").getResource("palettes");
        String palettesFolderPath = null;
        try {
            File[] palettesList;
            palettesFolderPath = FileLocator.toFileURL((URL)palettesFolderUrl).getPath();
            File palettesFolderFile = new File(palettesFolderPath);
            File[] fileArray = palettesList = palettesFolderFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            int n = palettesList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    this.load(new FileInputStream(file), ColorBrewer.ALL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void load(InputStream stream, PaletteType type) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(stream);
        this.fixToString(document.getElementsByTagName("name").item(0).getFirstChild().toString());
        this.fixToString(document.getElementsByTagName("description").item(0).getFirstChild().toString());
        SampleScheme scheme = new SampleScheme();
        NodeList samples = document.getElementsByTagName("sample");
        int i = 0;
        while (i < samples.getLength()) {
            Node sample = samples.item(i);
            int size = Integer.parseInt(sample.getAttributes().getNamedItem("size").getNodeValue());
            String values = this.fixToString(sample.getFirstChild().toString());
            int[] list = new int[size];
            StringTokenizer tok = new StringTokenizer(values);
            int j = 0;
            while (j < size) {
                list[j] = Integer.parseInt(tok.nextToken(","));
                ++j;
            }
            scheme.setSampleScheme(size, list);
            ++i;
        }
        NodeList palettes = document.getElementsByTagName("palette");
        int i2 = 0;
        while (i2 < palettes.getLength()) {
            BrewerPalette pal = new BrewerPalette();
            PaletteSuitability suitability = new PaletteSuitability();
            NodeList paletteInfo = palettes.item(i2).getChildNodes();
            int j = 0;
            while (j < paletteInfo.getLength()) {
                Node item = paletteInfo.item(j);
                if (item.getNodeName().equals("name")) {
                    pal.setName(this.fixToString(item.getFirstChild().toString()));
                }
                if (item.getNodeName().equals("description")) {
                    pal.setDescription(this.fixToString(item.getFirstChild().toString()));
                }
                if (item.getNodeName().equals("colors")) {
                    StringTokenizer oTok = new StringTokenizer(this.fixToString(item.getFirstChild().toString()));
                    ArrayList<Color> colors = new ArrayList<Color>();
                    while (oTok.hasMoreTokens()) {
                        String entry = oTok.nextToken(":");
                        StringTokenizer iTok = new StringTokenizer(entry);
                        int r = Integer.parseInt(iTok.nextToken(",").trim());
                        int g = Integer.parseInt(iTok.nextToken(",").trim());
                        int b = Integer.parseInt(iTok.nextToken(",").trim());
                        colors.add(new Color(r, g, b));
                    }
                    pal.setColors(colors.toArray(new Color[colors.size()]));
                }
                if (item.getNodeName().equals("suitability")) {
                    NodeList schemeSuitability = item.getChildNodes();
                    int k = 0;
                    while (k < schemeSuitability.getLength()) {
                        Node palScheme = schemeSuitability.item(k);
                        if (palScheme.getNodeName().equals("scheme")) {
                            int paletteSize = Integer.parseInt(palScheme.getAttributes().getNamedItem("size").getNodeValue());
                            String values = this.fixToString(palScheme.getFirstChild().toString());
                            String[] list = new String[6];
                            StringTokenizer tok = new StringTokenizer(values);
                            int m = 0;
                            while (m < 6) {
                                list[m] = tok.nextToken(",");
                                ++m;
                            }
                            suitability.setSuitability(paletteSize, list);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            pal.setType(type);
            if (scheme.getMaxCount() == -1) {
                Color[] colors = pal.getColors();
                int length = colors.length;
                CustomSampleScheme scheme2 = new CustomSampleScheme(length);
                int j2 = 2;
                while (j2 < length) {
                    int[] list = new int[j2];
                    int k = 0;
                    while (k < list.length) {
                        list[k] = k;
                        ++k;
                    }
                    scheme2.setSampleScheme(j2, list);
                    ++j2;
                }
                pal.setColorScheme((SampleScheme)scheme2);
            }
            pal.setPaletteSuitability(suitability);
            PALETTESLIST.add(pal);
            ++i2;
        }
    }

    private String fixToString(String input) {
        if (input.startsWith("[") && input.endsWith("]")) {
            input = input.substring(1, input.length() - 1);
            input = input.replaceAll("#text: ", "");
        }
        return input;
    }
}

