/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.awt.Color;
import net.refractions.udig.style.sld.editor.StyleThemePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.ui.PlatformUI;

public class BorderColorComboListener
implements SelectionListener {
    private StyleThemePage page;

    public BorderColorComboListener(StyleThemePage styleThemePage) {
        this.page = styleThemePage;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Combo combo = (Combo)e.widget;
        if (Outline.values()[combo.getSelectionIndex()] == Outline.CUSTOM) {
            ColorDialog dialog = new ColorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.open();
            combo.setData((Object)dialog.getRGB());
        }
        this.page.generateTheme();
    }

    public static Color getBorder(Combo combo) {
        Outline outline = Outline.values()[combo.getSelectionIndex()];
        switch (outline) {
            case NONE: {
                return null;
            }
            case BLACK: {
                return Color.BLACK;
            }
            case WHITE: {
                return Color.WHITE;
            }
            case CUSTOM: {
                RGB rgb = (RGB)combo.getData();
                if (rgb == null) {
                    return Color.BLACK;
                }
                Color color = new Color(rgb.red, rgb.green, rgb.blue);
                return color;
            }
        }
        throw new IllegalArgumentException("This method needs to be updated since outline has been modified");
    }

    public static enum Outline {
        NONE("None"),
        BLACK("Black"),
        WHITE("White"),
        CUSTOM("Custom");

        public final String label;

        private Outline(String label) {
            this.label = label;
        }

        public static String[] labels() {
            Outline[] values = Outline.values();
            String[] labels = new String[values.length];
            int i = 0;
            while (i < labels.length) {
                labels[i] = values[i].label;
                ++i;
            }
            return labels;
        }
    }
}

