/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.simple.FillViewer;
import net.refractions.udig.style.sld.simple.GraphicViewer;
import net.refractions.udig.style.sld.simple.LabelViewer;
import net.refractions.udig.style.sld.simple.Mode;
import net.refractions.udig.style.sld.simple.ScaleViewer;
import net.refractions.udig.style.sld.simple.StrokeViewer;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.geotools.data.FeatureSource;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.style.LabelPlacement;

public class SimpleStyleConfigurator
extends AbstractSimpleConfigurator {
    private static final String DEFAULT_GEOMETRY = "(default)";
    ComboViewer geometryName;
    Button pointMode;
    Button polyMode;
    Button lineMode;
    StrokeViewer line = new StrokeViewer();
    FillViewer fill = new FillViewer();
    GraphicViewer point = new GraphicViewer();
    LabelViewer label = new LabelViewer();
    ScaleViewer minScale = new ScaleViewer(0);
    ScaleViewer maxScale = new ScaleViewer(1);
    Mode mode;
    SelectionListener synchronize = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            SimpleStyleConfigurator.this.synchronize();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SimpleStyleConfigurator.this.synchronize();
        }
    };
    private Button replace;

    public SimpleStyleConfigurator() {
        this.line.addListener(this.synchronize);
        this.fill.addListener(this.synchronize);
        this.label.addListener(this.synchronize);
        this.point.addListener(this.synchronize);
        this.minScale.addListener(this.synchronize);
        this.maxScale.addListener(this.synchronize);
    }

    @Override
    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(FeatureSource.class);
    }

    public Mode determineMode(SimpleFeatureType schema, boolean askUser) {
        if (schema == null) {
            return Mode.NONE;
        }
        if (SLD.isLine(schema)) {
            return Mode.LINE;
        }
        if (SLD.isPolygon(schema)) {
            return Mode.POLYGON;
        }
        if (SLD.isPoint(schema)) {
            return Mode.POINT;
        }
        if (askUser) {
            if (this.polyMode.getSelection()) {
                return Mode.POLYGON;
            }
            if (this.lineMode.getSelection()) {
                return Mode.LINE;
            }
            if (this.pointMode.getSelection()) {
                return Mode.POINT;
            }
        }
        return Mode.ALL;
    }

    @Override
    protected void refresh() {
        LineSymbolizer sym;
        Style style = this.getStyle();
        List ftsList = style.featureTypeStyles();
        FeatureTypeStyle fts = null;
        if (ftsList.size() > 0) {
            fts = (FeatureTypeStyle)ftsList.get(0);
        }
        SimpleFeatureType schema = this.getLayer().getSchema();
        this.geometryName.setInput((Object)schema);
        String name = DEFAULT_GEOMETRY;
        Stroke stroke = null;
        Fill fill = null;
        Graphic graphic = null;
        TextSymbolizer text = null;
        PointPlacement placement = null;
        List rules = fts.rules();
        if (rules.size() > 1) {
            Rule keepRule = (Rule)rules.get(0);
            rules.clear();
            rules.add(keepRule);
        }
        this.mode = this.determineMode(schema, true);
        if (this.mode == Mode.NONE) {
            this.pointMode.setSelection(false);
            this.polyMode.setSelection(false);
            this.lineMode.setSelection(false);
        } else if (this.mode == Mode.LINE) {
            this.lineMode.setSelection(true);
            sym = SLDs.lineSymbolizer((FeatureTypeStyle)fts);
            stroke = SLDs.stroke((LineSymbolizer)sym);
            placement = SLDs.getPlacement((double)1.0, (double)0.5, (double)0.0);
            name = sym == null ? null : sym.getGeometryPropertyName();
        } else if (this.mode == Mode.POLYGON) {
            this.polyMode.setSelection(true);
            sym = SLDs.polySymbolizer((FeatureTypeStyle)fts);
            stroke = SLDs.stroke((PolygonSymbolizer)sym);
            fill = SLDs.fill((PolygonSymbolizer)sym);
            placement = SLDs.getPlacement((double)0.5, (double)0.5, (double)0.0);
            name = sym == null ? null : sym.getGeometryPropertyName();
        } else if (this.mode == Mode.POINT || this.mode == Mode.ALL) {
            this.pointMode.setSelection(true);
            sym = SLDs.pointSymbolizer((FeatureTypeStyle)fts);
            stroke = SLDs.stroke((PointSymbolizer)sym);
            fill = SLDs.fill((PointSymbolizer)sym);
            graphic = SLDs.graphic((PointSymbolizer)sym);
            placement = SLDs.getPlacement((double)1.0, (double)0.5, (double)0.0);
            name = sym == null ? null : sym.getGeometryPropertyName();
        }
        text = SLDs.textSymbolizer((FeatureTypeStyle)fts);
        if (text != null && placement != null) {
            text.setLabelPlacement((LabelPlacement)placement);
        }
        if (name == null) {
            name = DEFAULT_GEOMETRY;
            this.geometryName.getCombo().setText(name);
        } else {
            this.geometryName.getCombo().setText(name);
        }
        Mode raw = this.determineMode(schema, false);
        this.pointMode.setEnabled(raw == Mode.ALL);
        this.polyMode.setEnabled(raw == Mode.ALL);
        this.lineMode.setEnabled(raw == Mode.ALL);
        double minScaleDen = SLDs.minScale((FeatureTypeStyle)fts);
        double maxScaleDen = SLDs.maxScale((FeatureTypeStyle)fts);
        Color defaultColor = this.getLayer().getDefaultColor();
        this.line.setStroke(stroke, this.mode, defaultColor);
        this.fill.setFill(fill, this.mode, defaultColor);
        this.point.setGraphic(graphic, this.mode, defaultColor);
        this.label.set(schema, text, this.mode);
        this.minScale.setScale(minScaleDen, Math.round(this.getLayer().getMap().getViewportModel().getScaleDenominator()));
        this.maxScale.setScale(maxScaleDen, Math.round(this.getLayer().getMap().getViewportModel().getScaleDenominator()));
    }

    @Override
    public void synchronize() {
        ArrayList<Object> acquire = new ArrayList<Object>();
        TextSymbolizer textSym = this.label.get(this.build);
        SimpleFeatureType schema = this.getLayer().getSchema();
        this.mode = this.determineMode(schema, true);
        String geometryPropertyName = null;
        if (this.geometryName.getCombo().getSelectionIndex() != 0) {
            geometryPropertyName = this.geometryName.getCombo().getText();
        }
        switch (this.mode) {
            case LINE: {
                LineSymbolizer lineSymbolizer = this.build.createLineSymbolizer(this.line.getStroke(this.build));
                acquire.add(lineSymbolizer);
                lineSymbolizer.setGeometryPropertyName(geometryPropertyName);
                if (textSym == null) break;
                acquire.add(textSym);
                break;
            }
            case POLYGON: {
                PolygonSymbolizer polygonSymbolizer = this.build.createPolygonSymbolizer(this.line.getStroke(this.build), this.fill.getFill(this.build));
                polygonSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(polygonSymbolizer);
                if (textSym == null) break;
                acquire.add(textSym);
                break;
            }
            case POINT: {
                PointSymbolizer pointSymbolizer = this.build.createPointSymbolizer(this.point.getGraphic(this.fill.getFill(this.build), this.line.getStroke(this.build), this.build));
                pointSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(pointSymbolizer);
                if (textSym == null) break;
                acquire.add(textSym);
                break;
            }
            case ALL: {
                LineSymbolizer lineSymbolizer = this.build.createLineSymbolizer(this.line.getStroke(this.build));
                acquire.add(lineSymbolizer);
                acquire.add(lineSymbolizer);
                PolygonSymbolizer polygonSymbolizer = this.build.createPolygonSymbolizer(this.line.getStroke(this.build), this.fill.getFill(this.build));
                polygonSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(polygonSymbolizer);
                PointSymbolizer pointSymbolizer = this.build.createPointSymbolizer(this.point.getGraphic(this.fill.getFill(this.build), this.line.getStroke(this.build), this.build));
                pointSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(pointSymbolizer);
                if (textSym == null) break;
                acquire.add(textSym);
            }
        }
        double minScaleDen = this.minScale.getScale();
        double maxScaleDen = this.maxScale.getScale();
        Symbolizer[] array = acquire.toArray(new Symbolizer[acquire.size()]);
        Rule rule = this.build.createRule(array);
        if (this.minScale.isEnabled()) {
            rule.setMinScaleDenominator(minScaleDen);
        }
        if (this.maxScale.isEnabled()) {
            rule.setMaxScaleDenominator(maxScaleDen);
        }
        FeatureTypeStyle featureTypeStyle = this.build.createFeatureTypeStyle("Feature", rule);
        featureTypeStyle.setName("simple");
        featureTypeStyle.setSemanticTypeIdentifiers(new String[]{"generic:geometry", "simple"});
        Style style = (Style)this.getStyleBlackboard().get("net.refractions.udig.style.sld");
        style.setDefault(true);
        if (this.replace.getSelection()) {
            style.featureTypeStyles().clear();
            style.featureTypeStyles().add(featureTypeStyle);
        } else {
            List fts = style.featureTypeStyles();
            boolean match = false;
            int i = fts.size() - 1;
            while (i > -1) {
                if (SLDs.isSemanticTypeMatch((FeatureTypeStyle)((FeatureTypeStyle)fts.get(i)), (String)"simple")) {
                    fts.set(i, featureTypeStyle);
                    match = true;
                    break;
                }
                --i;
            }
            if (match) {
                style.featureTypeStyles().clear();
                style.featureTypeStyles().addAll(fts);
            } else {
                ArrayList<FeatureTypeStyle> fts2 = new ArrayList<FeatureTypeStyle>(fts);
                Collections.copy(fts2, fts);
                fts2.add(featureTypeStyle);
                style.featureTypeStyles().clear();
                style.featureTypeStyles().addAll(fts2);
            }
        }
        this.getStyleBlackboard().put("net.refractions.udig.style.sld", (Object)style);
        ((StyleBlackboard)this.getStyleBlackboard()).setSelected(new String[]{"net.refractions.udig.style.sld"});
    }

    @Override
    public void createControl(Composite parent) {
        this.setLayout(parent);
        ((RowLayout)parent.getLayout()).type = 512;
        ((RowLayout)parent.getLayout()).spacing = 3;
        KeyAdapter adp = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.character == '\r') {
                    SimpleStyleConfigurator.this.makeActionDoStuff();
                }
            }
        };
        Composite part = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_GeometryLabel);
        this.geometryName = new ComboViewer(part);
        this.geometryName.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            FeatureType schema;

            public Object[] getElements(Object inputElement) {
                ArrayList<String> names = new ArrayList<String>();
                names.add(SimpleStyleConfigurator.DEFAULT_GEOMETRY);
                if (this.schema != null) {
                    for (PropertyDescriptor descriptor : this.schema.getDescriptors()) {
                        if (!(descriptor instanceof GeometryDescriptor)) continue;
                        names.add(((GeometryDescriptor)descriptor).getLocalName());
                    }
                }
                return names.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.schema = (FeatureType)newInput;
            }

            public void dispose() {
            }
        });
        this.geometryName.getCombo().setText(DEFAULT_GEOMETRY);
        this.geometryName.getCombo().addSelectionListener(this.synchronize);
        part = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_ModeLabel);
        this.pointMode = new Button(part, 16);
        this.pointMode.setText(Messages.SimpleStyleConfigurator_PointMode);
        this.lineMode = new Button(part, 16);
        this.lineMode.setText(Messages.SimpleStyleConfigurator_LineMode);
        this.polyMode = new Button(part, 16);
        this.polyMode.setText(Messages.SimpleStyleConfigurator_PolygonMode);
        this.line.createControl(parent, (KeyListener)adp);
        this.fill.createControl(parent, (KeyListener)adp);
        this.point.createControl(parent, (KeyListener)adp, this.build);
        this.label.createControl(parent, (KeyListener)adp);
        this.minScale.createControl(parent, (KeyListener)adp);
        this.maxScale.createControl(parent, (KeyListener)adp);
        Composite replaceComp = AbstractSimpleConfigurator.subpart(parent, Messages.SimpleStyleConfigurator_replaceButton);
        this.replace = new Button(replaceComp, 32);
        this.replace.addSelectionListener(this.synchronize);
        this.replace.setSelection(true);
    }
}

