/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld;

import java.awt.Color;
import javax.media.jai.Histogram;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.style.sld.simple.ChannelViewer;
import net.refractions.udig.style.sld.simple.OpacityViewer;
import net.refractions.udig.style.sld.simple.RGBChannelViewer;
import net.refractions.udig.style.sld.simple.ScaleViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.parameter.ParameterValueGroup;

public class SimpleRasterConfigurator
extends AbstractSimpleConfigurator {
    private FilterFactory2 ff = null;
    private StyleFactory sf = null;
    private OpacityViewer opacity = new OpacityViewer();
    ScaleViewer minScale = new ScaleViewer(0);
    ScaleViewer maxScale = new ScaleViewer(1);
    private ChannelViewer redChannel = new ChannelViewer(Messages.SimpleRasterConfigurator_RedChannelLabel, Color.RED, 0);
    private ChannelViewer greenChannel = new ChannelViewer(Messages.SimpleRasterConfigurator_GreenChannelLabel, Color.GREEN, 1);
    private ChannelViewer blueChannel = new ChannelViewer(Messages.SimpleRasterConfigurator_BlueChannelLabel, Color.BLUE, 2);
    private RGBChannelViewer rgbViewer = new RGBChannelViewer(this.redChannel, this.greenChannel, this.blueChannel);
    private final UpdateHistoJob updateJob = new UpdateHistoJob();
    private Composite parent;
    private Label lblWarn;
    SelectionListener synchronize = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            SimpleRasterConfigurator.this.synchronize();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SimpleRasterConfigurator.this.synchronize();
        }
    };

    public SimpleRasterConfigurator() {
        this.opacity.addListener(this.synchronize);
        this.minScale.addListener(this.synchronize);
        this.maxScale.addListener(this.synchronize);
        this.rgbViewer.addListener(this.synchronize);
    }

    @Override
    public boolean canStyle(Layer aLayer) {
        if (aLayer.hasResource(WebMapServer.class)) {
            return true;
        }
        if (aLayer.hasResource(GridCoverage.class)) {
            try {
                GridCoverage gc = (GridCoverage)aLayer.getResource(GridCoverage.class, null);
                return gc.getNumSampleDimensions() >= 3;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return aLayer.hasResource(AbstractGridCoverage2DReader.class);
    }

    @Override
    protected void refresh() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean canStyle = SimpleRasterConfigurator.this.canStyle(SimpleRasterConfigurator.this.getLayer());
                SimpleRasterConfigurator.this.lblWarn.setVisible(!canStyle);
                Control[] controlArray = SimpleRasterConfigurator.this.parent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (!c.equals(SimpleRasterConfigurator.this.lblWarn)) {
                        c.setVisible(canStyle);
                    }
                    ++n2;
                }
                if (!canStyle) {
                    return;
                }
                Style style = SimpleRasterConfigurator.this.getStyle();
                RasterSymbolizer sym = SLD.rasterSymbolizer((Style)style);
                SimpleRasterConfigurator.this.opacity.set(sym);
                Layer l = SimpleRasterConfigurator.this.getLayer();
                GridCoverage gc = null;
                try {
                    gc = (GridCoverage)l.getResource(GridCoverage.class, null);
                    String[] bands = new String[gc.getNumSampleDimensions()];
                    int i = 0;
                    while (i < bands.length) {
                        bands[i] = String.valueOf(i + 1) + Messages.SimpleRasterConfigurator_BandDelimiter + gc.getSampleDimension(i).getDescription().toString();
                        ++i;
                    }
                    SimpleRasterConfigurator.this.rgbViewer.setBands(bands);
                }
                catch (Exception exception) {}
                Rule r = SLD.rules((Style)style)[0];
                double minScaleDen = r.getMinScaleDenominator();
                double maxScaleDen = r.getMaxScaleDenominator();
                SimpleRasterConfigurator.this.minScale.setScale(minScaleDen, Math.round(SimpleRasterConfigurator.this.getLayer().getMap().getViewportModel().getScaleDenominator()));
                SimpleRasterConfigurator.this.maxScale.setScale(maxScaleDen, Math.round(SimpleRasterConfigurator.this.getLayer().getMap().getViewportModel().getScaleDenominator()));
                if (gc == null) {
                    SimpleRasterConfigurator.this.rgbViewer.setEditable(false);
                } else {
                    SimpleRasterConfigurator.this.rgbViewer.setEditable(true);
                    SimpleRasterConfigurator.this.rgbViewer.set(sym);
                    SimpleRasterConfigurator.this.updateHistogram(sym, (GridCoverage2D)gc);
                }
            }
        });
    }

    private void updateHistogram(RasterSymbolizer rs, GridCoverage2D gc) {
        this.updateJob.updateInfo(rs, gc);
        this.updateJob.schedule(500L);
    }

    @Override
    public void createControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        this.lblWarn = new Label(parent, 64);
        this.lblWarn.setText(Messages.SimpleRasterConfigurator_StyleUnavailable);
        this.lblWarn.setVisible(false);
        KeyAdapter adapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.character == '\r') {
                    SimpleRasterConfigurator.this.makeActionDoStuff();
                }
            }
        };
        this.opacity.createControl(parent, (KeyListener)adapter);
        Group g = new Group(parent, 16);
        g.setLayoutData((Object)new GridData(768));
        g.setLayout((Layout)new GridLayout(2, true));
        g.setText(Messages.SimpleRasterConfigurator_ScaleGroup);
        this.minScale.createControl((Composite)g, (KeyListener)adapter);
        this.maxScale.createControl((Composite)g, (KeyListener)adapter);
        Composite c = this.rgbViewer.createControl(parent);
        c.setLayoutData((Object)new GridData(768));
    }

    @Override
    public void synchronize() {
        boolean canStyle = this.canStyle(this.getLayer());
        this.lblWarn.setVisible(!canStyle);
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.equals(this.lblWarn)) {
                c.setVisible(canStyle);
            }
            ++n2;
        }
        Style s = (Style)this.getLayer().getStyleBlackboard().get("net.refractions.udig.style.sld");
        RasterSymbolizer rs = SLD.rasterSymbolizer((Style)s);
        Rule r = SLD.rules((Style)s)[0];
        if (this.minScale.isEnabled()) {
            r.setMinScaleDenominator(this.minScale.getScale());
        }
        if (this.maxScale.isEnabled()) {
            r.setMaxScaleDenominator(this.maxScale.getScale());
        }
        SLD.setRasterOpacity((Style)s, (double)this.opacity.getValue());
        SelectedChannelType red = null;
        SelectedChannelType green = null;
        SelectedChannelType blue = null;
        if (this.rgbViewer.isEnabled()) {
            red = this.setChannel(this.rgbViewer.getRedChannel().getName(), this.rgbViewer.getRedChannel().getGamma());
            green = this.setChannel(this.rgbViewer.getGreenChannel().getName(), this.rgbViewer.getGreenChannel().getGamma());
            blue = this.setChannel(this.rgbViewer.getBlueChannel().getName(), this.rgbViewer.getBlueChannel().getGamma());
        }
        SLD.setChannelSelection((Style)s, (SelectedChannelType[])new SelectedChannelType[]{red, green, blue}, null);
        GridCoverage2D gc = null;
        try {
            gc = (GridCoverage2D)this.getLayer().getResource(GridCoverage.class, null);
            if (gc != null) {
                this.updateHistogram(rs, gc);
            }
        }
        catch (Exception exception) {}
        this.getStyleBlackboard().put("net.refractions.udig.style.sld", (Object)s);
        ((StyleBlackboard)this.getStyleBlackboard()).setSelected(new String[]{"net.refractions.udig.style.sld"});
    }

    private SelectedChannelType setChannel(String name, double gamma) {
        return this.getStyleFactory().createSelectedChannelType(name, this.getStyleFactory().createContrastEnhancement((Expression)this.getFilterFactory().literal(gamma)));
    }

    private StyleFactory getStyleFactory() {
        if (this.sf == null) {
            this.sf = CommonFactoryFinder.getStyleFactory(null);
        }
        return this.sf;
    }

    private FilterFactory2 getFilterFactory() {
        if (this.ff == null) {
            this.ff = CommonFactoryFinder.getFilterFactory2(null);
        }
        return this.ff;
    }

    private class UpdateHistoJob
    extends Job {
        private RasterSymbolizer rs;
        private GridCoverage2D gc;

        public UpdateHistoJob() {
            super("Update Histogram Job");
        }

        public void updateInfo(RasterSymbolizer rs, GridCoverage2D gd) {
            this.gc = gd;
            this.rs = rs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SimpleRasterConfigurator.this.rgbViewer.updateHistograms(null);
                }
            });
            RasterSymbolizerHelper rsp = new RasterSymbolizerHelper(this.gc, null);
            rsp.visit(this.rs);
            GridCoverage2D recoloredGridCoverage = (GridCoverage2D)rsp.getOutput();
            OperationJAI op = new OperationJAI("Histogram");
            ParameterValueGroup params = op.getParameters();
            params.parameter("Source").setValue((Object)recoloredGridCoverage);
            recoloredGridCoverage = (GridCoverage2D)op.doOperation(params, null);
            final Histogram h = (Histogram)recoloredGridCoverage.getProperty("histogram");
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SimpleRasterConfigurator.this.rgbViewer.updateHistograms(h.getBins());
                }
            });
            return Status.OK_STATUS;
        }
    }
}

