/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld;

import java.awt.Color;
import java.util.List;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.ui.graphics.SLDs;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.util.Utilities;
import org.opengis.style.StyleFactory;

public class SLDContentManager {
    private Style style;
    private FeatureTypeStyle featureTypeStyle;
    private Rule rule;
    private Symbolizer symbolizer;
    private StyleBuilder styleBuilder;

    public SLDContentManager() {
        this(new StyleBuilder());
    }

    public SLDContentManager(StyleBuilder styleBuilder) {
        this.init(styleBuilder, styleBuilder.createStyle());
    }

    public SLDContentManager(StyleBuilder styleBuilder, Style style) {
        this.init(styleBuilder, style);
    }

    public void init(Style style) {
        this.init(new StyleBuilder(), style);
    }

    public void init(StyleBuilder styleBuilder, Style style) {
        if (styleBuilder == null) {
            throw new NullPointerException("StyleBuilder required");
        }
        this.styleBuilder = styleBuilder;
        if (style == null) {
            throw new NullPointerException("Style required");
        }
        this.style = style;
        this.featureTypeStyle = null;
        this.rule = null;
        this.symbolizer = null;
    }

    public Style getStyle() {
        return this.style;
    }

    public StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public StyleFactory getStyleFactory() {
        if (this.styleBuilder.getStyleFactory() instanceof StyleFactory) {
            return this.styleBuilder.getStyleFactory();
        }
        return CommonFactoryFinder.getStyleFactory(null);
    }

    public FeatureTypeStyle getDefaultFeatureTypeStyle() {
        List featureTypeStyles = this.style.featureTypeStyles();
        if (featureTypeStyles == null || featureTypeStyles.isEmpty()) {
            return this.createFeatureTypeStyle("default");
        }
        return (FeatureTypeStyle)featureTypeStyles.get(0);
    }

    public FeatureTypeStyle getFeatureTypeStyle(String name) {
        List featureTypeStyles = this.style.featureTypeStyles();
        if (featureTypeStyles == null) {
            return null;
        }
        for (FeatureTypeStyle check : featureTypeStyles) {
            if (!Utilities.equals((Object)check.getName(), (Object)name)) continue;
            return check;
        }
        return null;
    }

    public FeatureTypeStyle featureTypeStyle(String name) {
        FeatureTypeStyle featureTypeStyle = this.getFeatureTypeStyle(name);
        if (featureTypeStyle != null) {
            return featureTypeStyle;
        }
        return this.createFeatureTypeStyle(name);
    }

    public Rule getDefaultRule() {
        FeatureTypeStyle ftStyle = this.getDefaultFeatureTypeStyle();
        if (ftStyle.rules() == null || ftStyle.rules().isEmpty()) {
            Rule rule = this.createRule(ftStyle);
            return rule;
        }
        return (Rule)ftStyle.rules().get(0);
    }

    public FeatureTypeStyle createFeatureTypeStyle(String name) {
        FeatureTypeStyle ftStyle = this.styleBuilder.createFeatureTypeStyle(name, new Rule[0]);
        this.style.addFeatureTypeStyle(ftStyle);
        return ftStyle;
    }

    public Rule createRule() {
        return this.styleBuilder.createRule(new Symbolizer[0]);
    }

    public Rule createRule(FeatureTypeStyle ftStyle) {
        Rule rule = this.createRule();
        ftStyle.addRule(rule);
        return rule;
    }

    public <T> T getSymbolizer(Rule rule, Class<T> theClass) {
        Symbolizer[] symbolizers = rule.getSymbolizers();
        if (symbolizers == null || theClass == null) {
            return null;
        }
        int i = 0;
        while (i < symbolizers.length) {
            if (symbolizers[i] != null && theClass.isAssignableFrom(symbolizers[i].getClass())) {
                return theClass.cast(symbolizers[i]);
            }
            ++i;
        }
        return null;
    }

    public <T extends Symbolizer> T getSymbolizer(Class<T> theClass) {
        return (T)((Symbolizer)this.getSymbolizer(this.getDefaultRule(), theClass));
    }

    public void addSymbolizer(Symbolizer symbolizer) {
        this.addSymbolizer(this.getDefaultRule(), symbolizer);
    }

    public void addSymbolizer(Rule rule, Symbolizer symbolizer) {
        Symbolizer[] syms = rule.getSymbolizers();
        if (syms == null) {
            syms = new Symbolizer[]{symbolizer};
        } else {
            Symbolizer[] newSyms = new Symbolizer[syms.length + 1];
            System.arraycopy(syms, 0, newSyms, 0, syms.length);
            newSyms[syms.length] = symbolizer;
            syms = newSyms;
        }
        rule.setSymbolizers(syms);
    }

    public void addSymbolizer(Class<Symbolizer> theClass) {
        this.addSymbolizer(SLD.createDefault(theClass));
    }

    public void removeSymbolizer(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return;
        }
        Symbolizer[] symbolizers = this.getDefaultRule().getSymbolizers();
        int i = 0;
        while (i < symbolizers.length) {
            if (symbolizers[i].equals(symbolizer)) break;
            ++i;
        }
        if (i < symbolizers.length) {
            Symbolizer[] newSymbolizers = new Symbolizer[symbolizers.length - 1];
            System.arraycopy(symbolizers, 0, newSymbolizers, 0, i);
            System.arraycopy(symbolizers, i + 1, newSymbolizers, i, symbolizers.length - (i + 1));
            this.getDefaultRule().setSymbolizers(newSymbolizers);
        }
    }

    public void removeSymbolizer(Class<Symbolizer> theClass) {
        if (theClass == null) {
            return;
        }
        Symbolizer[] symbolizers = this.getDefaultRule().getSymbolizers();
        int i = 0;
        while (i < symbolizers.length) {
            if (theClass.isAssignableFrom(symbolizers[i].getClass())) break;
            ++i;
        }
        if (i < symbolizers.length) {
            Symbolizer[] newSymbolizers = new Symbolizer[symbolizers.length - 1];
            System.arraycopy(symbolizers, 0, newSymbolizers, 0, i);
            System.arraycopy(symbolizers, i + 1, newSymbolizers, i, symbolizers.length - (i + 1));
            this.getDefaultRule().setSymbolizers(newSymbolizers);
        }
    }

    public Color color(LineSymbolizer line) {
        return SLDs.color((LineSymbolizer)line);
    }

    public double width(LineSymbolizer line) {
        return SLDs.lineWidth((LineSymbolizer)line);
    }

    public double opacity(LineSymbolizer line) {
        return SLDs.lineOpacity((LineSymbolizer)line);
    }
}

