/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.transform.TransformerException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.StyleContent;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.style.sld.SLDContentManager;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public final class SLDContent
extends StyleContent {
    public static final String ID = "net.refractions.udig.style.sld";
    private static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private static StyleBuilder styleBuilder = new StyleBuilder(styleFactory);
    private static Random random = new Random();

    public SLDContent() {
        super(ID);
    }

    public Class<?> getStyleClass() {
        return Style.class;
    }

    public void save(IMemento memento, Object value) {
        Style style = (Style)value;
        SLDTransformer sldWriter = new SLDTransformer();
        String out = "";
        try {
            out = sldWriter.transform((Object)style);
        }
        catch (TransformerException e) {
            SLDPlugin.log("SLDTransformer failed", e);
            e.printStackTrace();
        }
        catch (Exception e) {
            SLDPlugin.log("SLDTransformer failed", e);
        }
        memento.putTextData(out);
        memento.putString("type", "SLDStyle");
        memento.putString("version", "1.0");
    }

    public Object load(IMemento momento) {
        if (momento.getTextData() == null) {
            return null;
        }
        StringReader reader = new StringReader(momento.getTextData());
        SLDParser sldParser = new SLDParser(SLDContent.getStyleFactory(), (Reader)reader);
        Style[] parsed = sldParser.readXML();
        if (parsed != null && parsed.length > 0) {
            return parsed[0];
        }
        return null;
    }

    public Object load(URL url, IProgressMonitor m) throws IOException {
        return SLDContent.parse(url);
    }

    public static void apply(ILayer layer, Style style, IProgressMonitor m) throws IOException {
        IGeoResource resource;
        SimpleFeatureSource featureSource;
        if (layer == null) {
            return;
        }
        if (style == null) {
            return;
        }
        if (layer.hasResource(FeatureSource.class) && (featureSource = (SimpleFeatureSource)(resource = layer.findGeoResource(FeatureSource.class)).resolve(SimpleFeatureSource.class, m)) != null) {
            List fstyles;
            SimpleFeatureType type = (SimpleFeatureType)featureSource.getSchema();
            FeatureTypeStyle fstyle = SLDs.featureTypeStyle((Style)style, (SimpleFeatureType)type);
            if (fstyle == null && (fstyles = style.featureTypeStyles()) != null && !fstyles.isEmpty()) {
                fstyle = (FeatureTypeStyle)fstyles.get(0);
            }
            if (fstyle != null) {
                fstyle.setName(type.getName().getLocalPart());
                StyleBlackboard styleBlackboard = (StyleBlackboard)layer.getStyleBlackboard();
                styleBlackboard.put(ID, (Object)style);
                styleBlackboard.setSelected(new String[]{ID});
            }
        }
    }

    public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor m) throws IOException {
        Style style;
        if (resource.canResolve(Style.class) && (style = (Style)resource.resolve(Style.class, null)) != null) {
            DuplicatingStyleVisitor v = new DuplicatingStyleVisitor();
            style.accept((StyleVisitor)v);
            return v.getCopy();
        }
        if (resource.canResolve(FeatureSource.class)) {
            SimpleFeatureSource featureSource = null;
            try {
                featureSource = (SimpleFeatureSource)resource.resolve(SimpleFeatureSource.class, m);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            Style style2 = this.createDefaultFeatureStyle(resource, colour, (FeatureSource<SimpleFeatureType, SimpleFeature>)featureSource);
            if (style2 != null) {
                return style2;
            }
        }
        if (resource.canResolve(GridCoverage.class)) {
            return this.createDefaultGridCoverageStyle(resource, colour);
        }
        return null;
    }

    private Style createDefaultGridCoverageStyle(IGeoResource resource, Color colour) {
        RasterSymbolizer rasterSymbolizer = styleFactory.createRasterSymbolizer();
        Style style = styleBuilder.createStyle();
        SLDContentManager sldContentManager = new SLDContentManager(styleBuilder, style);
        sldContentManager.addSymbolizer((Symbolizer)rasterSymbolizer);
        style.setName("simpleStyle");
        return style;
    }

    private Style createDefaultFeatureStyle(IGeoResource resource, Color colour, FeatureSource<SimpleFeatureType, SimpleFeature> featureSource) throws IOException {
        if (featureSource == null) {
            return null;
        }
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        GeometryDescriptor geom = schema.getGeometryDescriptor();
        if (geom == null) {
            return null;
        }
        Style style = styleBuilder.createStyle();
        SLDContentManager sldContentManager = new SLDContentManager(styleBuilder, style);
        if (SLD.isLine(geom)) {
            sldContentManager.addSymbolizer((Symbolizer)SLDContent.createLineSymbolizer(colour));
        } else if (SLD.isPoint(geom)) {
            sldContentManager.addSymbolizer((Symbolizer)SLDContent.createPointSymbolizer(colour));
        } else if (SLD.isPolygon(geom)) {
            PolygonSymbolizer symbol = SLDContent.createPolygonSymbolizer(colour);
            sldContentManager.addSymbolizer((Symbolizer)symbol);
        } else {
            try {
                this.createGeometrySLD(colour, schema.getGeometryDescriptor().getName().getLocalPart(), sldContentManager);
            }
            catch (Exception e) {
                SLDPlugin.log("Failed to create geometry SLD", e);
                sldContentManager.addSymbolizer((Symbolizer)styleBuilder.createLineSymbolizer());
            }
        }
        FeatureTypeStyle fts = sldContentManager.getDefaultFeatureTypeStyle();
        fts.setFeatureTypeName("Feature");
        fts.setName("simple");
        fts.setSemanticTypeIdentifiers(new String[]{"generic:geometry", "simple"});
        return style;
    }

    private void createGeometrySLD(Color colour, String geomXPath, SLDContentManager sldContentManager) throws IllegalFilterException {
        Rule rule = sldContentManager.getDefaultRule();
        PropertyIsEqualTo filter = this.createGeometryFunctionFilter(geomXPath, Point.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.symbolizers().add(SLDContent.createPointSymbolizer(colour));
        sldContentManager.getDefaultFeatureTypeStyle().rules().add(rule);
        rule = sldContentManager.createRule();
        filter = this.createGeometryFunctionFilter(geomXPath, MultiPoint.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.symbolizers().add(SLDContent.createPointSymbolizer(colour));
        sldContentManager.getDefaultFeatureTypeStyle().rules().add(rule);
        rule = sldContentManager.createRule();
        filter = this.createGeometryFunctionFilter(geomXPath, LineString.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.symbolizers().add(SLDContent.createLineSymbolizer(colour));
        sldContentManager.getDefaultFeatureTypeStyle().rules().add(rule);
        rule = sldContentManager.createRule();
        filter = this.createGeometryFunctionFilter(geomXPath, LinearRing.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.symbolizers().add(SLDContent.createLineSymbolizer(colour));
        sldContentManager.getDefaultFeatureTypeStyle().rules().add(rule);
        rule = sldContentManager.createRule();
        filter = this.createGeometryFunctionFilter(geomXPath, MultiLineString.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.symbolizers().add(SLDContent.createLineSymbolizer(colour));
        sldContentManager.getDefaultFeatureTypeStyle().rules().add(rule);
        rule = sldContentManager.createRule();
        filter = this.createGeometryFunctionFilter(geomXPath, Polygon.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.symbolizers().add(SLDContent.createPolygonSymbolizer(colour));
        sldContentManager.getDefaultFeatureTypeStyle().rules().add(rule);
        rule = sldContentManager.createRule();
        filter = this.createGeometryFunctionFilter(geomXPath, MultiPolygon.class.getSimpleName());
        rule.setFilter((Filter)filter);
        rule.symbolizers().add(SLDContent.createPolygonSymbolizer(colour));
        sldContentManager.getDefaultFeatureTypeStyle().rules().add(rule);
    }

    private PropertyIsEqualTo createGeometryFunctionFilter(String geomXPath, Object geometryClassSimpleName) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        ArrayList<PropertyName> params = new ArrayList<PropertyName>();
        params.add(factory.property(geomXPath));
        geomTypeExpr.setParameters(params);
        return factory.equals((Expression)geomTypeExpr, (Expression)factory.literal(geometryClassSimpleName));
    }

    public static Style parse(URL url) throws IOException {
        return SLDs.parseStyle((URL)url);
    }

    public static StyledLayerDescriptor createDefaultStyledLayerDescriptor() {
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        return sld;
    }

    public static StyledLayerDescriptor createDefaultStyledLayerDescriptor(Style style) {
        StyledLayerDescriptor sld = SLDContent.createDefaultStyledLayerDescriptor();
        UserLayer layer = styleFactory.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[1]);
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        return sld;
    }

    public static Style createDefaultStyle() {
        Style style = styleBuilder.createStyle();
        SLDContentManager sldContentManager = new SLDContentManager(styleBuilder, style);
        sldContentManager.addSymbolizer((Symbolizer)SLDContent.createLineSymbolizer(SLDContent.createRandomColor()));
        sldContentManager.addSymbolizer((Symbolizer)SLDContent.createPolygonSymbolizer(SLDContent.createRandomColor()));
        sldContentManager.addSymbolizer((Symbolizer)SLDContent.createTextSymbolizer());
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        fts.setName("simple");
        fts.setSemanticTypeIdentifiers(new String[]{"generic:geometry", "simple"});
        return style;
    }

    public static StyleFactory getStyleFactory() {
        return styleFactory;
    }

    public static StyleBuilder getStyleBuilder() {
        return styleBuilder;
    }

    protected static PointSymbolizer createPointSymbolizer(Color colour) {
        PointSymbolizer symb = styleBuilder.createPointSymbolizer();
        Fill fill = styleBuilder.createFill(colour, 1.0);
        Stroke outline = styleBuilder.createStroke(Color.BLACK, 1.0, 1.0);
        if (symb.getGraphic().graphicalSymbols() != null && symb.getGraphic().graphicalSymbols().size() == 1) {
            symb.getGraphic().graphicalSymbols().clear();
        }
        symb.getGraphic().graphicalSymbols().add(styleBuilder.createMark("square", fill, outline));
        symb.getGraphic().setSize(styleBuilder.literalExpression(6.0));
        return symb;
    }

    protected static LineSymbolizer createLineSymbolizer(Color colour) {
        if (colour == null) {
            colour = SLDContent.createRandomColor();
        }
        Stroke stroke = styleBuilder.createStroke();
        stroke.setColor(styleBuilder.colorExpression(colour));
        stroke.setWidth(styleBuilder.literalExpression(1));
        LineSymbolizer symbolizer = styleBuilder.createLineSymbolizer(stroke);
        return symbolizer;
    }

    protected static PolygonSymbolizer createPolygonSymbolizer(Color colour) {
        if (colour == null) {
            colour = SLDContent.createRandomColor();
        }
        Stroke stroke = styleBuilder.createStroke();
        stroke.setColor(styleBuilder.colorExpression(colour));
        stroke.setWidth(styleBuilder.literalExpression(1));
        Fill fill = styleBuilder.createFill();
        fill.setColor(styleBuilder.colorExpression(colour));
        fill.setOpacity(styleBuilder.literalExpression(0.5));
        PolygonSymbolizer symbolizer = styleBuilder.createPolygonSymbolizer(stroke, fill);
        return symbolizer;
    }

    protected static TextSymbolizer createTextSymbolizer() {
        TextSymbolizer symbolizer = styleBuilder.createTextSymbolizer();
        return symbolizer;
    }

    protected static RasterSymbolizer createRasterSymbolizer() {
        RasterSymbolizer symbolizer = styleBuilder.createRasterSymbolizer();
        return symbolizer;
    }

    protected static Color createRandomColor() {
        return new Color(random.nextInt(200), random.nextInt(200), random.nextInt(200));
    }
}

