/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.style.sld.SLDContent;
import net.refractions.udig.style.sld.StyleGlyph;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.data.ows.Layer;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public enum SLD {
    POINT(PointSymbolizer.class){

        @Override
        public ImageDescriptor createImageDescriptor() {
            return StyleGlyph.point(5, 7);
        }

        @Override
        public ImageDescriptor createDisabledImageDescriptor() {
            return StyleGlyph.point(15, 7);
        }

        public PointSymbolizer createDefault() {
            return SLDContent.createPointSymbolizer(null);
        }

        @Override
        public boolean supports(ILayer layer) {
            SimpleFeatureType featureType = layer.getSchema();
            if (featureType == null) {
                return false;
            }
            return 1.isPoint(featureType.getGeometryDescriptor());
        }
    }
    ,
    LINE(LineSymbolizer.class){

        @Override
        public ImageDescriptor createImageDescriptor() {
            return StyleGlyph.line(2, 2);
        }

        @Override
        public ImageDescriptor createDisabledImageDescriptor() {
            return StyleGlyph.line(15, 2);
        }

        public LineSymbolizer createDefault() {
            return SLDContent.createLineSymbolizer(null);
        }

        @Override
        public boolean supports(ILayer layer) {
            return 2.isLine(layer.getSchema());
        }
    }
    ,
    POLYGON(PolygonSymbolizer.class){

        @Override
        public ImageDescriptor createImageDescriptor() {
            return StyleGlyph.polygon(2, 3, 1);
        }

        @Override
        public ImageDescriptor createDisabledImageDescriptor() {
            return StyleGlyph.polygon(2, 15, 1);
        }

        public PolygonSymbolizer createDefault() {
            return SLDContent.createPolygonSymbolizer(null);
        }

        @Override
        public boolean supports(ILayer layer) {
            return 3.isPolygon(layer.getSchema());
        }
    }
    ,
    TEXT(TextSymbolizer.class){

        @Override
        public ImageDescriptor createImageDescriptor() {
            return StyleGlyph.text(2, 2);
        }

        @Override
        public ImageDescriptor createDisabledImageDescriptor() {
            return StyleGlyph.text(15, 2);
        }

        public TextSymbolizer createDefault() {
            return SLDContent.createTextSymbolizer();
        }

        @Override
        public boolean supports(ILayer layer) {
            SimpleFeatureType featureType = layer.getSchema();
            return featureType != null;
        }
    }
    ,
    RASTER(RasterSymbolizer.class){

        @Override
        public ImageDescriptor createImageDescriptor() {
            return StyleGlyph.raster(2, 3, 1);
        }

        @Override
        public ImageDescriptor createDisabledImageDescriptor() {
            return StyleGlyph.raster(2, 15, 1);
        }

        @Override
        public Object createDefault() {
            return SLDContent.createRasterSymbolizer();
        }

        @Override
        public boolean supports(ILayer layer) {
            return layer.hasResource(Layer.class);
        }
    };

    Class type;

    private SLD(Class object) {
        this.type = object;
    }

    public ImageDescriptor createImageDescriptor() {
        return null;
    }

    public ImageDescriptor createDisabledImageDescriptor() {
        return null;
    }

    public Object createDefault() {
        return null;
    }

    public boolean supports(ILayer layer) {
        return false;
    }

    public static <T> T createDefault(Class<T> theClass) {
        SLD sld = SLD.get(theClass);
        if (sld != null) {
            return theClass.cast(sld.createDefault());
        }
        return null;
    }

    public static ImageDescriptor createImageDescriptor(Class theClass) {
        SLD symbolizer = SLD.get(theClass);
        if (symbolizer != null) {
            return symbolizer.createImageDescriptor();
        }
        return null;
    }

    public static ImageDescriptor createDisabledImageDescriptor(Class theClass) {
        SLD object = SLD.get(theClass);
        if (object != null) {
            return object.createDisabledImageDescriptor();
        }
        return null;
    }

    public static List<Class> getSupportedTypes(ILayer layer) {
        ArrayList<Class> l = new ArrayList<Class>();
        SLD[] sLDArray = SLD.values();
        int n = sLDArray.length;
        int n2 = 0;
        while (n2 < n) {
            SLD sld = sLDArray[n2];
            if (sld.supports(layer)) {
                l.add(sld.type);
            }
            ++n2;
        }
        return l;
    }

    private static SLD get(Class symbolizer) {
        SLD[] sLDArray = SLD.values();
        int n = sLDArray.length;
        int n2 = 0;
        while (n2 < n) {
            SLD sld = sLDArray[n2];
            if (symbolizer.isAssignableFrom(sld.type)) {
                return sld;
            }
            ++n2;
        }
        return null;
    }

    public static final boolean isPolygon(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SLD.isPolygon(featureType.getGeometryDescriptor());
    }

    public static final boolean isPolygon(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
    }

    public static final boolean isLine(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SLD.isLine(featureType.getGeometryDescriptor());
    }

    public static final boolean isLine(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return LineString.class.isAssignableFrom(type) || MultiLineString.class.isAssignableFrom(type);
    }

    public static final boolean isPoint(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SLD.isPoint(featureType.getGeometryDescriptor());
    }

    public static final boolean isPoint(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return Point.class.isAssignableFrom(type) || MultiPoint.class.isAssignableFrom(type);
    }

    /* synthetic */ SLD(String string, int n, Class clazz, SLD sLD) {
        this(clazz);
    }
}

