/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.filter;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.StyleContent;
import net.refractions.udig.style.filter.FilterStyle;
import net.refractions.udig.style.sld.SLDPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.geotools.data.Query;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.opengis.filter.Filter;

public final class FilterContent
extends StyleContent {
    public static String STYLE_ID = "net.refractions.udig.style.filter";

    public FilterContent() {
        super(STYLE_ID);
    }

    public Class<?> getStyleClass() {
        return Boolean.class;
    }

    public void save(IMemento memento, Object value) {
        Filter filter = null;
        Boolean aoiFilter = null;
        if (value instanceof Filter) {
            filter = (Filter)value;
        } else if (value instanceof Query) {
            Query query = (Query)value;
            filter = query.getFilter();
        } else if (value instanceof FilterStyle) {
            filter = ((FilterStyle)value).getFilter();
            aoiFilter = ((FilterStyle)value).isAoiFilter();
        }
        if (filter != null && filter != Filter.INCLUDE) {
            String cql = CQL.toCQL((Filter)filter);
            memento.putString("cql", cql);
        }
        if (aoiFilter != null && aoiFilter.booleanValue()) {
            memento.putString("aoi", "true");
        }
        memento.putString("type", "FilterContent");
        memento.putString("version", "1.0");
    }

    public Object load(IMemento memento) {
        String type = memento.getString("type");
        String version = memento.getString("version");
        if ("FilterContent".equals(type) && "1.0".equals(version)) {
            String aoi;
            boolean isAOI;
            String cql = memento.getString("cql");
            Filter filter = null;
            if (cql != null && cql.length() != 0) {
                try {
                    filter = CQL.toFilter((String)cql);
                }
                catch (CQLException eek) {
                    SLDPlugin.log("Could not restore filter:" + (Object)((Object)eek), eek);
                }
            }
            if (isAOI = "true".equalsIgnoreCase(aoi = memento.getString("aoiFilter"))) {
                FilterStyle styleFilter = new FilterStyle();
                styleFilter.setAoiFilter(true);
                if (filter != null) {
                    styleFilter.setFilter(filter);
                }
                return styleFilter;
            }
            if (filter == null) {
                return null;
            }
            return new FilterStyle(filter);
        }
        return null;
    }

    public Object load(URL url, IProgressMonitor m) throws IOException {
        return null;
    }

    public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor m) throws IOException {
        return new FilterStyle();
    }
}

