/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.filter;

import net.miginfocom.swt.MigLayout;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.IStyleConfigurator;
import net.refractions.udig.style.filter.FilterStyle;
import net.refractions.udig.ui.filter.FilterInput;
import net.refractions.udig.ui.filter.FilterViewer;
import net.refractions.udig.ui.filter.IFilterViewer;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.data.FeatureSource;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;

public class FilterConfigurator
extends IStyleConfigurator {
    protected IFilterViewer filterViewer;
    public static String STYLE_ID = "net.refractions.udig.style.filter";
    protected Button aoiButton;
    private SelectionListener aoiListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (FilterConfigurator.this.aoiButton == null || FilterConfigurator.this.aoiButton.isDisposed()) {
                return;
            }
            FilterConfigurator.this.valueChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (FilterConfigurator.this.filterViewer == null || FilterConfigurator.this.filterViewer.getControl() == null || FilterConfigurator.this.filterViewer.getControl().isDisposed()) {
                return;
            }
            Filter oldValue = FilterConfigurator.this.getFilterStyle().getFilter();
            Filter filter = FilterConfigurator.this.filterViewer.getFilter();
            if (filter == null) {
                return;
            }
            if (!IFilterViewer.same((Filter)oldValue, (Filter)filter)) {
                FilterConfigurator.this.valueChanged();
            }
        }
    };

    public void valueChanged() {
        if (this.aoiButton == null || this.aoiButton.isDisposed()) {
            return;
        }
        this.getApplyAction().setEnabled(true);
        FilterStyle style = this.getFilterStyle();
        Filter filter = style.getFilter();
        boolean isAoiFilter = style.isAoiFilter();
        if (this.filterViewer.getFilter() == null || !this.filterViewer.getFilter().equals(filter) || this.aoiButton.getSelection() != isAoiFilter) {
            FilterStyle newFilterStyle = new FilterStyle(style);
            newFilterStyle.setFilter(this.filterViewer.getFilter());
            newFilterStyle.setAoiFilter(this.aoiButton.getSelection());
            this.getStyleBlackboard().put(STYLE_ID, (Object)newFilterStyle);
        }
    }

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(FeatureSource.class);
    }

    protected FilterStyle getFilterStyle() {
        Layer layer = this.getLayer();
        if (!this.canStyle(layer)) {
            throw new IllegalStateException("Layer " + layer.getName() + " cannot be filtered");
        }
        FilterStyle current = (FilterStyle)this.getStyleBlackboard().get(STYLE_ID);
        if (current == null) {
            return new FilterStyle();
        }
        return current;
    }

    public void createControl(Composite parent) {
        MigLayout layout = new MigLayout("insets panel", "[][fill]", "[fill][]");
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 4);
        label.setText("Automatic Filter");
        label.setLayoutData((Object)"cell 0 0,aligny top, gapx 0 unrelated");
        this.aoiButton = new Button(parent, 32);
        this.aoiButton.setText("Area of Interest");
        this.aoiButton.setLayoutData((Object)"cell 1 0 2 1, left, grow x");
        label = new Label(parent, 4);
        label.setText("Manual Filter");
        label.setLayoutData((Object)"cell 0 1,aligny top, gapx 0 unrelated");
        ControlDecoration decoration = new ControlDecoration((Control)label, 131200);
        this.filterViewer = new FilterViewer(parent, 2);
        this.filterViewer.getControl().setLayoutData((Object)"cell 1 1,grow,width 200:100%:100%,height 60:100%:100%");
        FilterInput input = new FilterInput();
        input.setFeedback(decoration);
        this.filterViewer.setInput((Object)input);
        this.filterViewer.refresh();
        this.listen(true);
    }

    public void listen(boolean listen) {
        if (listen) {
            this.filterViewer.addSelectionChangedListener(this.listener);
            this.aoiButton.addSelectionListener(this.aoiListener);
        } else {
            this.filterViewer.removeSelectionChangedListener(this.listener);
            this.aoiButton.removeSelectionListener(this.aoiListener);
        }
    }

    protected void refresh() {
        if (this.filterViewer == null || this.filterViewer.getControl() == null || this.filterViewer.getControl().isDisposed()) {
            return;
        }
        this.getApplyAction().setEnabled(false);
        if (this.aoiButton == null || this.aoiButton.isDisposed()) {
            return;
        }
        SimpleFeatureType type = this.getLayer().getSchema();
        FilterInput filterInput = this.filterViewer.getInput();
        filterInput.setSchema(type);
        final FilterStyle style = this.getFilterStyle();
        this.filterViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (FilterConfigurator.this.filterViewer == null || FilterConfigurator.this.filterViewer.getControl() == null || FilterConfigurator.this.filterViewer.getControl().isDisposed()) {
                    return;
                }
                try {
                    FilterConfigurator.this.listen(false);
                    IncludeFilter filter = style != null ? style.getFilter() : Filter.INCLUDE;
                    FilterConfigurator.this.filterViewer.setFilter((Filter)filter);
                    FilterConfigurator.this.filterViewer.refresh();
                    FilterConfigurator.this.aoiButton.setSelection(style.isAoiFilter());
                }
                finally {
                    FilterConfigurator.this.listen(true);
                }
            }
        });
    }

    public void dispose() {
        if (this.filterViewer != null) {
            this.listen(false);
            this.filterViewer = null;
            this.aoiButton = null;
        }
        super.dispose();
    }
}

