/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.cache;

import net.miginfocom.swt.MigLayout;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.opengis.coverage.grid.GridCoverage;

public class CacheConfigurator
extends IStyleConfigurator {
    protected Button cacheCheckbox;
    protected boolean wasSelected;
    private SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean isSelected = CacheConfigurator.this.cacheCheckbox.getSelection();
            CacheConfigurator.this.valueChanged(CacheConfigurator.this.wasSelected, isSelected);
        }
    };

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(GridCoverage.class) || aLayer.hasResource(FeatureSource.class) || aLayer.hasResource(AbstractGridCoverage2DReader.class);
    }

    protected boolean getStyle() {
        Layer layer = this.getLayer();
        assert (this.canStyle(layer));
        Boolean isCached = (Boolean)this.getStyleBlackboard().get("net.refractions.udig.style.cache");
        if (isCached == null) {
            isCached = false;
            this.getStyleBlackboard().put("net.refractions.udig.style.cache", (Object)isCached);
        }
        return isCached;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new MigLayout("", "[right]rel[left, grow]", "30"));
        Label label = new Label(parent, 0);
        label.setText("Cache");
        this.cacheCheckbox = new Button(parent, 32);
        this.cacheCheckbox.setLayoutData((Object)"span,wrap");
        this.cacheCheckbox.addSelectionListener(this.listener);
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.getStyleBlackboard().put("net.refractions.udig.style.cache", (Object)newValue);
        }
    }

    protected void refresh() {
        if (this.cacheCheckbox == null || this.cacheCheckbox.isDisposed()) {
            return;
        }
        final boolean style = this.getStyle();
        this.cacheCheckbox.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CacheConfigurator.this.cacheCheckbox == null || CacheConfigurator.this.cacheCheckbox.isDisposed()) {
                    return;
                }
                if (style != CacheConfigurator.this.cacheCheckbox.getSelection()) {
                    CacheConfigurator.this.cacheCheckbox.removeSelectionListener(CacheConfigurator.this.listener);
                    CacheConfigurator.this.cacheCheckbox.setSelection(style);
                    CacheConfigurator.this.wasSelected = style;
                    CacheConfigurator.this.cacheCheckbox.addSelectionListener(CacheConfigurator.this.listener);
                }
            }
        });
    }

    public void dispose() {
        if (this.cacheCheckbox != null) {
            this.cacheCheckbox.removeSelectionListener(this.listener);
            this.cacheCheckbox.dispose();
            this.cacheCheckbox = null;
        }
        super.dispose();
    }
}

