/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.filter;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.geotools.filter.FunctionFinder;
import org.opengis.filter.capability.FunctionName;

class FunctionContentProposalProvider
implements IContentProposalProvider {
    public static Set<String> proposals = new TreeSet<String>();
    private IContentProposal[] contentProposals;
    private boolean filterProposals = false;
    private Set<String> extras;

    static {
        FunctionFinder functionFinder = new FunctionFinder(null);
        for (FunctionName function : functionFinder.getAllFunctionDescriptions()) {
            proposals.add(function.getName().toLowerCase());
        }
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String word = contents.substring(0, position);
        int start = contents.lastIndexOf(" ", position);
        if (start != -1) {
            word = contents.substring(start, position);
        }
        if ((word = word.trim()).length() == 0) {
            return new IContentProposal[0];
        }
        if (this.filterProposals) {
            ArrayList<IContentProposal> list = new ArrayList<IContentProposal>();
            if (this.extras != null) {
                for (String extra : this.extras) {
                    if (extra.length() < word.length() || !extra.substring(0, word.length()).equalsIgnoreCase(word)) continue;
                    list.add(this.makeContentProposal(extra));
                }
            }
            for (String proposal : proposals) {
                if (proposal.length() < word.length() || !proposal.substring(0, word.length()).equalsIgnoreCase(word)) continue;
                list.add(this.makeContentProposal(proposal));
            }
            return list.toArray(new IContentProposal[list.size()]);
        }
        if (this.contentProposals == null) {
            int LENGTH = proposals.size() + (this.extras == null ? 0 : this.extras.size());
            this.contentProposals = new IContentProposal[LENGTH];
            int i = 0;
            if (this.extras != null && !this.extras.isEmpty()) {
                for (String extra : this.extras) {
                    this.contentProposals[i] = this.makeContentProposal(extra);
                    ++i;
                }
            }
            for (String proposal : proposals) {
                this.contentProposals[i] = this.makeContentProposal(proposal);
                ++i;
            }
        }
        return this.contentProposals;
    }

    public void setFiltering(boolean filterProposals) {
        this.filterProposals = filterProposals;
        this.contentProposals = null;
    }

    private IContentProposal makeContentProposal(final String proposal) {
        return new IContentProposal(){

            public String getContent() {
                return proposal;
            }

            public String getDescription() {
                return null;
            }

            public String getLabel() {
                return null;
            }

            public int getCursorPosition() {
                return proposal.length();
            }
        };
    }

    public void setExtra(Set<String> names) {
        this.extras = names;
        this.contentProposals = null;
    }
}

