/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.filter;

import java.util.HashSet;
import net.refractions.udig.filter.FunctionContentProposalProvider;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

public class FilterViewer
extends Viewer {
    protected Filter filter = Filter.EXCLUDE;
    private Text text;
    private boolean isRequired;
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            String after;
            String before = FilterViewer.this.filter != null ? CQL.toCQL((Filter)FilterViewer.this.filter) : "(empty)";
            FilterViewer.this.validate();
            String string = after = FilterViewer.this.filter != null ? CQL.toCQL((Filter)FilterViewer.this.filter) : "(empty)";
            if (FilterViewer.this.filter != null && !Utilities.equals((Object)before, (Object)after)) {
                FilterViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)FilterViewer.this, FilterViewer.this.getSelection()));
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private ControlDecoration feedback;
    private FunctionContentProposalProvider proposalProvider;

    public FilterViewer(Composite parent) {
        this(parent, 4);
    }

    public FilterViewer(Composite parent, int style) {
        this.text = new Text(parent, style);
        this.feedback = new ControlDecoration((Control)this.text, 16512);
        this.proposalProvider = new FunctionContentProposalProvider();
        this.proposalProvider.setFiltering(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.proposalProvider, null, null);
        adapter.setProposalAcceptanceStyle(2);
        this.text.addKeyListener(this.keyListener);
    }

    public Text getControl() {
        return this.text;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean validate() {
        FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
        try {
            this.filter = ECQL.toFilter((String)this.text.getText());
        }
        catch (CQLException e) {
            this.filter = null;
            this.feedback.setDescriptionText(e.getSyntaxError());
            this.feedback.setImage(decorations.getFieldDecoration("DEC_ERROR").getImage());
            this.feedback.show();
            return false;
        }
        if (this.filter == null) {
            this.feedback.setDescriptionText("(empty)");
            this.feedback.setImage(decorations.getFieldDecoration("DEC_ERROR").getImage());
            this.feedback.show();
            return false;
        }
        if (this.isRequired && this.filter == Expression.NIL) {
            this.feedback.setDescriptionText("Required");
            this.feedback.setImage(decorations.getFieldDecoration("DEC_REQUIRED").getImage());
            this.feedback.show();
            return false;
        }
        this.feedback.setDescriptionText(null);
        this.feedback.setImage(null);
        this.feedback.hide();
        return true;
    }

    public String getValidationMessage() {
        FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
        if (this.feedback.getImage() == decorations.getFieldDecoration("DEC_ERROR").getImage()) {
            String errorMessage = this.feedback.getDescriptionText();
            if (errorMessage == null) {
                errorMessage = "invalid";
            }
            return errorMessage;
        }
        if (this.feedback.getImage() == decorations.getFieldDecoration("DEC_REQUIRED").getImage()) {
            String requiredMessage = this.feedback.getDescriptionText();
            if (requiredMessage == null) {
                requiredMessage = "invalid";
            }
            return requiredMessage;
        }
        return null;
    }

    public Filter getInput() {
        return this.filter;
    }

    public ISelection getSelection() {
        if (this.filter == null) {
            return null;
        }
        StructuredSelection selection = new StructuredSelection((Object)this.filter);
        return selection;
    }

    public void refresh() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (FilterViewer.this.text == null || FilterViewer.this.text.isDisposed()) {
                        return;
                    }
                    String cql = CQL.toCQL((Filter)FilterViewer.this.filter);
                    FilterViewer.this.text.setText(cql);
                }
            });
        }
    }

    public void setInput(Object input) {
        if (input instanceof Filter) {
            this.filter = (Filter)input;
            this.refresh();
        } else if (input instanceof String) {
            final String txt = (String)input;
            try {
                this.filter = ECQL.toFilter((String)txt);
            }
            catch (CQLException cQLException) {}
            this.text.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FilterViewer.this.text.setText(txt);
                }
            });
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void feedback() {
        this.feedback.hide();
    }

    public void feedback(String warning) {
        Text control;
        if (this.feedback != null) {
            this.feedback.setDescriptionText(warning);
            this.feedback.show();
        }
        if ((control = this.getControl()) != null && !control.isDisposed()) {
            control.setToolTipText(warning);
        }
    }

    public void feedback(String error, Exception eek) {
        Text control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setToolTipText(String.valueOf(error) + ":" + eek);
        }
    }

    public void setSchema(SimpleFeatureType type) {
        if (type == null) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (AttributeDescriptor attribute : type.getAttributeDescriptors()) {
            names.add(attribute.getLocalName());
        }
        this.proposalProvider.setExtra(names);
    }
}

