/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class ComboExpressionViewer
extends Viewer {
    protected Expression expr = Expression.NIL;
    protected ComboViewer viewer;
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ComboExpressionViewer.this.changed(event);
        }
    };
    private ControlDecoration feedback;

    public ComboExpressionViewer(Composite parent) {
        this(parent, 4);
    }

    public ComboExpressionViewer(Composite parent, int style) {
        this.viewer = new ComboViewer(parent, style);
        this.viewer.addPostSelectionChangedListener(this.listener);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Expression) {
                    Expression expression = (Expression)element;
                    return CQL.toCQL((Expression)expression);
                }
                return super.getText(element);
            }
        });
    }

    public void changed(SelectionChangedEvent event) {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            this.expr = Expression.NIL;
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection selection2 = (IStructuredSelection)selection;
            Object obj = selection2.getFirstElement();
            if (obj instanceof Expression) {
                this.expr = (Expression)obj;
                this.feedback();
                return;
            }
            if (obj instanceof String) {
                String cql = (String)obj;
                try {
                    this.expr = CQL.toExpression((String)cql);
                    this.feedback();
                    return;
                }
                catch (CQLException e1) {
                    this.expr = Expression.NIL;
                    this.feedback("Could not understand expression", (Exception)((Object)e1));
                }
            }
        }
    }

    public void setOptions(String[] array) {
        ArrayList<Literal> options = new ArrayList<Literal>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            options.add(ff.literal((Object)str));
            ++n2;
        }
        this.viewer.setInput(options);
    }

    public void setOptions(int[] array) {
        ArrayList<Literal> options = new ArrayList<Literal>();
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int number = nArray[n2];
            options.add(ff.literal(number));
            ++n2;
        }
        this.viewer.setInput(options);
    }

    public void setOptions(double[] array) {
        ArrayList<Literal> options = new ArrayList<Literal>();
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double number = dArray[n2];
            options.add(ff.literal(number));
            ++n2;
        }
        this.viewer.setInput(options);
    }

    public void setOptions(SimpleFeatureType featureType) {
        ArrayList<PropertyName> options = new ArrayList<PropertyName>();
        for (AttributeDescriptor attributeDescriptor : featureType.getAttributeDescriptors()) {
            options.add(ff.property(attributeDescriptor.getName().getLocalPart()));
        }
        this.viewer.setInput(options);
    }

    public void setOptions(List<Expression> list) {
        ArrayList<Expression> options = new ArrayList<Expression>(list);
        this.viewer.setInput(options);
    }

    public void feedback() {
        if (this.feedback != null) {
            this.feedback.hide();
            return;
        }
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setToolTipText("");
        }
    }

    public void feedback(String warning) {
        Control control;
        if (this.feedback != null) {
            this.feedback.setDescriptionText(warning);
            this.feedback.show();
        }
        if ((control = this.getControl()) != null && !control.isDisposed()) {
            control.setToolTipText(warning);
        }
    }

    public void feedback(String error, Exception eek) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setToolTipText(String.valueOf(error) + ":" + eek);
        }
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public Expression getInput() {
        return this.expr;
    }

    public ISelection getSelection() {
        StructuredSelection selection = new StructuredSelection((Object)this.expr);
        return selection;
    }

    public void refresh() {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.expr));
    }

    public void setInput(Object input) {
        if (input instanceof Expression) {
            this.expr = (Expression)input;
        } else if (input instanceof String) {
            String txt = (String)input;
            try {
                this.expr = ECQL.toExpression((String)txt);
            }
            catch (CQLException cQLException) {}
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }
}

