/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.property.PropertyAttributeReader;
import org.geotools.data.property.PropertyAttributeWriter;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PropertyFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    PropertyDataStore store;
    File read;
    PropertyAttributeReader reader;
    File write;
    PropertyAttributeWriter writer;
    SimpleFeature origional = null;
    SimpleFeature live = null;
    long nextFid = System.currentTimeMillis();

    public PropertyFeatureWriter(PropertyDataStore dataStore, String typeName) throws IOException {
        this.store = dataStore;
        File dir = this.store.directory;
        this.read = new File(dir, typeName + ".properties");
        this.write = File.createTempFile(typeName + System.currentTimeMillis(), null, dir);
        this.reader = new PropertyAttributeReader(this.read);
        this.writer = new PropertyAttributeWriter(this.write, this.reader.type);
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.reader.type;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        if (this.live != null && this.origional != null) {
            this.writeImplementation(this.origional);
            this.origional = null;
            this.live = null;
        }
        return this.reader.hasNext();
    }

    private void writeImplementation(SimpleFeature f) throws IOException {
        this.writer.next();
        String fid = f.getID();
        if (Boolean.TRUE.equals(f.getUserData().get(Hints.USE_PROVIDED_FID)) && f.getUserData().containsKey(Hints.PROVIDED_FID)) {
            fid = (String)f.getUserData().get(Hints.PROVIDED_FID);
        }
        this.writer.writeFeatureID(fid);
        for (int i = 0; i < f.getAttributeCount(); ++i) {
            Object value = f.getAttribute(i);
            this.writer.write(i, value);
        }
    }

    @Override
    public SimpleFeature next() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        String fid = null;
        SimpleFeatureType type = this.reader.type;
        try {
            if (this.hasNext()) {
                this.reader.next();
                fid = this.reader.getFeatureID();
                Object[] values = new Object[this.reader.getAttributeCount()];
                for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                    values[i] = this.reader.read(i);
                }
                this.origional = SimpleFeatureBuilder.build(type, values, fid);
                this.live = SimpleFeatureBuilder.copy(this.origional);
                return this.live;
            }
            fid = type.getTypeName() + "." + this.nextFid++;
            Object[] values = DataUtilities.defaultValues(type);
            this.origional = null;
            this.live = SimpleFeatureBuilder.build(type, values, fid);
            return this.live;
        }
        catch (IllegalAttributeException e) {
            String message = "Problem creating feature " + (fid != null ? fid : "");
            throw new DataSourceException(message, e);
        }
    }

    @Override
    public void write() throws IOException {
        if (this.live == null) {
            throw new IOException("No current feature to write");
        }
        if (this.live.equals(this.origional)) {
            this.writeImplementation(this.origional);
        } else {
            this.writeImplementation(this.live);
            String typeName = this.live.getFeatureType().getTypeName();
            Transaction autoCommit = Transaction.AUTO_COMMIT;
            if (this.origional != null) {
                ReferencedEnvelope bounds = new ReferencedEnvelope();
                bounds.include(this.live.getBounds());
                bounds.include(this.origional.getBounds());
                this.store.listenerManager.fireFeaturesChanged(typeName, autoCommit, bounds, false);
            } else {
                this.store.listenerManager.fireFeaturesAdded(typeName, autoCommit, ReferencedEnvelope.reference(this.live.getBounds()), false);
            }
        }
        this.origional = null;
        this.live = null;
    }

    @Override
    public void remove() throws IOException {
        if (this.live == null) {
            throw new IOException("No current feature to remove");
        }
        if (this.origional != null) {
            String typeName = this.live.getFeatureType().getTypeName();
            Transaction autoCommit = Transaction.AUTO_COMMIT;
            this.store.listenerManager.fireFeaturesRemoved(typeName, autoCommit, ReferencedEnvelope.reference(this.origional.getBounds()), false);
        }
        this.origional = null;
        this.live = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.writer == null) {
            throw new IOException("writer already closed");
        }
        while (this.reader.hasNext()) {
            this.reader.next();
            this.writer.next();
            this.writer.echoLine(this.reader.line);
        }
        this.writer.close();
        this.reader.close();
        this.writer = null;
        this.reader = null;
        this.read.delete();
        if (this.write.exists() && !this.write.renameTo(this.read)) {
            FileChannel out = new FileOutputStream(this.read).getChannel();
            FileChannel in = new FileInputStream(this.write).getChannel();
            try {
                long len = in.size();
                long copied = out.transferFrom(in, 0L, in.size());
                if (len != copied) {
                    throw new IOException("unable to complete write");
                }
            }
            finally {
                in.close();
                out.close();
            }
        }
        this.read = null;
        this.write = null;
        this.store = null;
    }
}

