/*
 * Decompiled with CFR 0.152.
 */
package org.omscentral.modules.analysis.esp;

import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.omscentral.modules.analysis.esp.Format;
import org.omscentral.modules.analysis.esp.SetModelDateTimeException;

public class ModelDateTime
extends GregorianCalendar {
    private static final long serialVersionUID = 1L;
    private double juldate = -1.0;
    private String[] month_names = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public ModelDateTime() {
    }

    public ModelDateTime(TimeZone zone) {
        super(zone);
    }

    public ModelDateTime(Locale aLocale) {
        super(aLocale);
    }

    public ModelDateTime(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
    }

    public ModelDateTime(int y, int m, int d) {
        this.set(y, m, d, 0, 0, 0, 0);
    }

    public ModelDateTime(int y, int m, int d, int h, int mi) {
        this.set(y, m, d, h, mi, 0, 0);
    }

    public ModelDateTime(int y, int m, int d, int h, int mi, int s) {
        this.set(y, m, d, h, mi, s, 0);
    }

    public ModelDateTime(int y, int m, int d, int h, int mi, double s) {
        this.set(y, m, d, h, mi, (int)s, (int)((s - (double)((int)s)) * 1000.0));
    }

    public ModelDateTime(double jd) {
        this.juldate = jd;
        this.setJul2Greg(jd);
    }

    public ModelDateTime(double jd, TimeZone zone) {
        this.juldate = jd;
        this.setTimeZone(zone);
        this.setJul2Greg(jd);
    }

    public ModelDateTime(String date_time) throws SetModelDateTimeException {
        this.set(date_time);
    }

    public ModelDateTime(String date_time, TimeZone zone) throws SetModelDateTimeException {
        this.setTimeZone(zone);
        this.set(date_time);
    }

    public void set(int y, int m, int d, int h, int mi, int s, int ms) {
        this.set(1, y);
        this.set(2, m - 1);
        this.set(5, d);
        this.set(11, h);
        this.set(12, mi);
        this.set(13, s);
        this.set(14, ms);
        this.juldate = -1.0;
        this.getJulian();
    }

    public void set(String date_time) throws SetModelDateTimeException {
        try {
            int year = Integer.valueOf(date_time.substring(0, 4));
            int month = date_time.charAt(5) == ' ' ? Integer.valueOf(date_time.substring(6, 7)).intValue() : Integer.valueOf(date_time.substring(5, 7)).intValue();
            int day = date_time.charAt(8) == ' ' ? Integer.valueOf(date_time.substring(9, 10)).intValue() : Integer.valueOf(date_time.substring(8, 10)).intValue();
            int hour = 0;
            int minute = 0;
            int second = 0;
            if (date_time.length() > 15) {
                hour = date_time.charAt(11) == ' ' ? Integer.valueOf(date_time.substring(12, 13)).intValue() : Integer.valueOf(date_time.substring(11, 13)).intValue();
                minute = date_time.charAt(14) == ' ' ? Integer.valueOf(date_time.substring(15, 16)).intValue() : Integer.valueOf(date_time.substring(14, 16)).intValue();
            }
            if (date_time.length() == 19) {
                second = date_time.charAt(17) == ' ' ? Integer.valueOf(date_time.substring(18, 19)).intValue() : Integer.valueOf(date_time.substring(17, 19)).intValue();
            }
            this.set(year, month, day, hour, minute, second, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMmsDateTime() {
        Format f = new Format("%02d");
        float sec = (float)this.get(13) + (float)((double)this.get(14) * 0.001);
        return this.get(1) + " " + f.form(this.get(2) + 1) + " " + f.form(this.get(5)) + " " + f.form(this.get(11)) + " " + f.form(this.get(12)) + " " + f.form((int)sec);
    }

    public String getGISDateTime() {
        Format f = new Format("%02d");
        float sec = (float)this.get(13) + (float)((double)this.get(14) * 0.001);
        return this.get(1) + "-" + f.form(this.get(2) + 1) + "-" + f.form(this.get(5)) + ":" + f.form(this.get(11)) + ":" + f.form(this.get(12)) + ":" + f.form((int)sec);
    }

    public String getRuntimeGraphDateTime() {
        Format f = new Format("%02d");
        float sec = (float)this.get(13) + (float)((double)this.get(14) * 0.001);
        return this.get(1) + "," + f.form(this.get(2) + 1) + "," + f.form(this.get(5)) + "," + f.form(this.get(11)) + "," + f.form(this.get(12)) + "," + f.form((int)sec) + ",0";
    }

    public String getMmsEspInitDate() {
        Format f = new Format("%02d");
        return this.get(1) + f.form(this.get(2) + 1) + f.form(this.get(5));
    }

    public String getTabDateTime() {
        Format f = new Format("%02d");
        return this.get(1) + "\t" + f.form(this.get(2) + 1) + "\t" + f.form(this.get(5)) + "\t" + f.form(this.get(11)) + "\t" + f.form(this.get(12)) + "\t" + f.form(this.get(13));
    }

    public String getControlFileDateTime() {
        Format f = new Format("%02d");
        float sec = (float)this.get(13) + (float)((double)this.get(14) * 0.001);
        return this.get(1) + "," + f.form(this.get(2) + 1) + "," + f.form(this.get(5)) + "," + f.form(this.get(11)) + "," + f.form(this.get(12)) + "," + f.form(this.get(13));
    }

    public String getSQLDate() {
        Format f = new Format("%02d");
        return this.get(1) + "-" + f.form(this.get(2) + 1) + "-" + f.form(this.get(5));
    }

    @Override
    public String toString() {
        return this.getSQLDate();
    }

    public String getMonthDay() {
        Format f = new Format("%02d");
        return this.month_names[this.get(2)] + "-" + f.form(this.get(5));
    }

    public int getYear() {
        return this.get(1);
    }

    public int getMonth() {
        return this.get(2) + 1;
    }

    public int getDay() {
        return this.get(5);
    }

    public String getRiverWareDateTime() {
        Format f = new Format("%02d");
        return this.get(1) + "-" + f.form(this.get(2) + 1) + "-" + f.form(this.get(5)) + " " + f.form(this.get(11)) + ":" + f.form(this.get(12));
    }

    public Date getJDBCDate() {
        return new Date(this.getTimeInMillis());
    }

    public long getMillis() {
        return this.getTimeInMillis();
    }

    public void setJul2Greg(double julian_day) {
        long j = (long)julian_day;
        double frac = julian_day - (double)j;
        if (frac >= 0.5) {
            frac -= 0.5;
            ++j;
        } else {
            frac += 0.5;
        }
        int year = (int)((4L * (j -= 1721119L) - 1L) / 146097L);
        j = 4L * j - 1L - 146097L * (long)year;
        int day = (int)(j / 4L);
        j = (4L * (long)day + 3L) / 1461L;
        day = (int)(4L * (long)day + 3L - 1461L * j);
        day = (int)(((long)day + 4L) / 4L);
        int month = (int)((5L * (long)day - 3L) / 153L);
        day = (int)(5L * (long)day - 3L - 153L * (long)month);
        day = (int)(((long)day + 5L) / 5L);
        year = (int)(100L * (long)year + j);
        if (month < 10) {
            month += 3;
        } else {
            month -= 9;
            ++year;
        }
        double tmp = 3600.0 * (frac * 24.0);
        int hour = (int)(tmp / 3600.0);
        int minute = (int)((tmp -= (double)hour * 3600.0) / 60.0);
        double second = tmp - (double)minute * 60.0;
        this.juldate = julian_day;
        this.set(year, month, day, hour, minute, (int)second, (int)((second - (double)((int)second)) * 1000.0));
    }

    public double getJulian() {
        long m = this.get(2) + 1;
        long d = this.get(5);
        long y = this.get(1);
        double seconds = (double)this.get(11) * 3600.0 + (double)(this.get(12) * 60) + (double)this.get(13) + (double)this.get(14) * 0.001;
        if (m > 2L) {
            m -= 3L;
        } else {
            m += 9L;
            --y;
        }
        long c = y / 100L;
        long ya = y - 100L * c;
        long j = 146097L * c / 4L + 1461L * ya / 4L + (153L * m + 2L) / 5L + d + 1721119L;
        if (seconds < 43200.0) {
            --j;
            seconds += 43200.0;
        } else {
            seconds -= 43200.0;
        }
        this.juldate = (double)j + seconds / 3600.0 / 24.0;
        return this.juldate;
    }

    public static void main(String[] arg) {
        ModelDateTime mdt = new ModelDateTime();
        System.out.println("\ncurrent time");
        System.out.println("   julian = " + mdt.getJulian());
        System.out.println("   mms datetime = " + mdt.getMmsDateTime());
        System.out.println("   sql date = " + mdt.getSQLDate());
        System.out.println("   riverware datetime = " + mdt.getRiverWareDateTime());
        System.out.println("   Current TZ = " + mdt.getTimeZone().getID());
        mdt = new ModelDateTime(2440000.0);
        System.out.println("\nset JD = 2440000.0");
        System.out.println("   julian = " + mdt.getJulian());
        System.out.println("   mms datetime = " + mdt.getMmsDateTime());
        System.out.println("   sql date = " + mdt.getSQLDate());
        System.out.println("   riverware datetime = " + mdt.getRiverWareDateTime());
        mdt = new ModelDateTime(1968, 5, 23, 12, 0, 0);
        System.out.println("\nset to 1968, 5, 23, 12, 0, 0");
        System.out.println("   julian = " + mdt.getJulian());
        System.out.println("   mms datetime = " + mdt.getMmsDateTime());
        System.out.println("   sql date = " + mdt.getSQLDate());
        System.out.println("   riverware datetime = " + mdt.getRiverWareDateTime());
        try {
            mdt = new ModelDateTime("1968-05-23");
            System.out.println("\nset RiverWare date 1968-05-23");
            System.out.println("   julian = " + mdt.getJulian());
            System.out.println("   mms datetime = " + mdt.getMmsDateTime());
            System.out.println("   sql date = " + mdt.getSQLDate());
            System.out.println("   riverware datetime = " + mdt.getRiverWareDateTime());
        }
        catch (SetModelDateTimeException e) {
            e.printStackTrace();
        }
        try {
            mdt = new ModelDateTime("1968-05-23 12:01");
            System.out.println("\nset RiverWare datetime 1968-05-23 12:01");
            System.out.println("   julian = " + mdt.getJulian());
            System.out.println("   mms datetime = " + mdt.getMmsDateTime());
            System.out.println("   sql date = " + mdt.getSQLDate());
            System.out.println("   riverware datetime = " + mdt.getRiverWareDateTime());
        }
        catch (SetModelDateTimeException e) {
            e.printStackTrace();
        }
        try {
            mdt = new ModelDateTime("1968-05-23 12:01:05");
            System.out.println("\nset RiverWare datetime 1968-05-23 12:01:05");
            System.out.println("   julian = " + mdt.getJulian());
            System.out.println("   mms datetime = " + mdt.getMmsDateTime());
            System.out.println("   sql date = " + mdt.getSQLDate());
            System.out.println("   riverware datetime = " + mdt.getRiverWareDateTime());
        }
        catch (SetModelDateTimeException e) {
            e.printStackTrace();
        }
        mdt = new ModelDateTime(1968, 5, 23, 12, 0, 0);
        ModelDateTime mdt1 = new ModelDateTime(1968, 5, 24, 12, 0, 0);
        System.out.println();
        if (mdt.before(mdt1)) {
            System.out.println(mdt.getRiverWareDateTime() + " is before " + mdt1.getRiverWareDateTime());
        }
        if (mdt.after(mdt1)) {
            System.out.println(mdt.getRiverWareDateTime() + " is after " + mdt1.getRiverWareDateTime());
        }
        if (mdt.equals(mdt1)) {
            System.out.println(mdt.getRiverWareDateTime() + " is after " + mdt1.getRiverWareDateTime());
        }
        System.out.println("\ncomputeTime = " + mdt.getJDBCDate().toString());
    }
}

