/*
 * Decompiled with CFR 0.152.
 */
package org.omscentral.modules.analysis.esp;

import java.util.ArrayList;
import org.omscentral.modules.analysis.esp.ESPTimeSeries;
import org.omscentral.modules.analysis.esp.EnsembleListLabel;
import org.omscentral.modules.analysis.esp.ModelDateTime;
import org.omscentral.modules.analysis.esp.TimeSeriesCookie;

public class EnsembleData {
    public static int VOLUME = 1;
    public static int PEAK = 2;
    public static int YEAR = 3;
    private TimeSeriesCookie initialization;
    private ArrayList<ESPTimeSeries> forecasts;
    private ArrayList<ESPTimeSeries> historic;
    private ArrayList<ESPTimeSeries> input;
    private ArrayList<ESPTimeSeries> output;
    private ArrayList<EnsembleListLabel> stats;
    private ArrayList<EnsembleListLabel> statsInVolumeOrder;
    private ArrayList<EnsembleListLabel> statsInPeakOrder;
    private String name;
    private int sortOrder = VOLUME;

    public EnsembleData(String name, ESPTimeSeries initialization, ArrayList<ESPTimeSeries> forecasts, ArrayList<ESPTimeSeries> output, ArrayList<ESPTimeSeries> historic) {
        this.name = name;
        this.initialization = initialization;
        this.historic = historic;
        this.output = output;
        this.setForecasts(forecasts);
    }

    public EnsembleData(String name, ESPTimeSeries init, ArrayList<ESPTimeSeries> forecasts, ArrayList<ESPTimeSeries> historic) {
        this.name = name;
        this.initialization = init;
        this.historic = historic;
        this.setForecasts(forecasts);
    }

    private void PROCESS_trace(ModelDateTime analysisStart, ModelDateTime analysisEnd) {
        for (int j = 0; j < this.forecasts.size(); ++j) {
            EnsembleListLabel ts = this.stats.get(j);
            ESPTimeSeries trace = this.output.get(j);
            double[] trace_data = trace.getVals();
            double[] trace_dates = trace.getDates();
            ts.setTraceVolume(0.0);
            ts.setTracePeak(0.0);
            int offset = (int)analysisStart.getJulian() - (int)trace.getStart().getJulian() - 1;
            int length = (int)analysisEnd.getJulian() - (int)analysisStart.getJulian();
            for (int k = 0; k < length; ++k) {
                double tmp = trace_data[k + offset];
                ts.setTraceVolume(tmp + ts.getTraceVolume());
                if (!(ts.getTracePeak() < tmp)) continue;
                ts.setTracePeak(tmp);
                ts.setTimeToPeak(trace_dates[k + offset]);
            }
        }
        this.statsInVolumeOrder = new ArrayList(this.stats.size());
        this.statsInPeakOrder = new ArrayList(this.stats.size());
        for (int i = 0; i < this.stats.size(); ++i) {
            this.statsInVolumeOrder.add(i, this.stats.get(i));
            this.statsInPeakOrder.add(i, this.stats.get(i));
        }
        EnsembleData.sort(this.statsInVolumeOrder, this.statsInPeakOrder);
    }

    public static void sort(ArrayList<EnsembleListLabel> statsInVolumeOrder, ArrayList<EnsembleListLabel> statsInPeakOrder) {
        double prob;
        EnsembleListLabel tsi;
        int i;
        for (int i2 = 0; i2 < statsInVolumeOrder.size() - 1; ++i2) {
            EnsembleListLabel tsi2 = statsInVolumeOrder.get(i2);
            for (int j = i2 + 1; j < statsInVolumeOrder.size(); ++j) {
                EnsembleListLabel tsj = statsInVolumeOrder.get(j);
                if (!(tsj.getTraceVolume() > tsi2.getTraceVolume())) continue;
                statsInVolumeOrder.set(j, tsi2);
                statsInVolumeOrder.set(i2, tsj);
                tsi2 = tsj;
            }
        }
        double n = statsInVolumeOrder.size() + 1;
        for (i = 0; i < statsInVolumeOrder.size(); ++i) {
            double m = i + 1;
            tsi = statsInVolumeOrder.get(i);
            prob = 100.0 * m / n;
            tsi.setVolumeRank(i + 1);
            tsi.setActVolumeProb(prob);
            tsi.setRoundVolumeProb(EnsembleData.fivePercentRound(prob));
        }
        for (i = 0; i < statsInPeakOrder.size() - 1; ++i) {
            EnsembleListLabel tsi3 = statsInPeakOrder.get(i);
            for (int j = i + 1; j < statsInPeakOrder.size(); ++j) {
                EnsembleListLabel tsj = statsInPeakOrder.get(j);
                if (!(tsj.getTracePeak() > tsi3.getTracePeak())) continue;
                statsInPeakOrder.set(j, tsi3);
                statsInPeakOrder.set(i, tsj);
                tsi3 = tsj;
            }
        }
        n = statsInPeakOrder.size() + 1;
        for (i = 0; i < statsInPeakOrder.size(); ++i) {
            double m = i + 1;
            tsi = statsInPeakOrder.get(i);
            prob = 100.0 * m / n;
            tsi.setPeakRank(i + 1);
            tsi.setActPeakProb(prob);
            tsi.setRoundPeakProb(EnsembleData.fivePercentRound(prob));
        }
    }

    public static double fivePercentRound(double p) {
        if (p > 92.5) {
            return 95.0;
        }
        if (p > 87.5) {
            return 90.0;
        }
        if (p > 82.5) {
            return 85.0;
        }
        if (p > 77.5) {
            return 80.0;
        }
        if (p > 72.5) {
            return 75.0;
        }
        if (p > 67.5) {
            return 70.0;
        }
        if (p > 62.5) {
            return 65.0;
        }
        if (p > 57.5) {
            return 60.0;
        }
        if (p > 52.5) {
            return 55.0;
        }
        if (p > 47.5) {
            return 50.0;
        }
        if (p > 42.5) {
            return 45.0;
        }
        if (p > 37.5) {
            return 40.0;
        }
        if (p > 32.5) {
            return 35.0;
        }
        if (p > 27.5) {
            return 30.0;
        }
        if (p > 22.5) {
            return 25.0;
        }
        if (p > 17.5) {
            return 20.0;
        }
        if (p > 12.5) {
            return 15.0;
        }
        if (p > 7.5) {
            return 10.0;
        }
        return 5.0;
    }

    public ModelDateTime getInitializationStart() {
        return this.initialization.getStart();
    }

    public ModelDateTime getInitializationEnd() {
        return this.initialization.getEnd();
    }

    public ModelDateTime getForecastStart() {
        ESPTimeSeries forecast = this.forecasts.get(0);
        return forecast.getStart();
    }

    public ModelDateTime getForecastEnd() {
        ESPTimeSeries forecast = this.forecasts.get(0);
        return forecast.getEnd();
    }

    public TimeSeriesCookie getInitialization() {
        return this.initialization;
    }

    public void setInitialization(TimeSeriesCookie initialization) {
        this.initialization = initialization;
    }

    public ArrayList<ESPTimeSeries> getHistoric() {
        return this.historic;
    }

    public void setHistoric(ArrayList<ESPTimeSeries> historic) {
        this.historic = historic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<ESPTimeSeries> getForecasts() {
        return this.forecasts;
    }

    public void setForecasts(ArrayList<ESPTimeSeries> forecasts) {
        this.forecasts = forecasts;
        if (forecasts != null) {
            int size = forecasts.size();
            this.stats = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                ESPTimeSeries ts = forecasts.get(i);
                this.stats.add(new EnsembleListLabel(ts, this));
            }
        }
    }

    public ArrayList<ESPTimeSeries> getInput() {
        return this.input;
    }

    public void setInput(ArrayList<ESPTimeSeries> input) {
        this.input = input;
    }

    public ArrayList<ESPTimeSeries> getOutput() {
        return this.output;
    }

    public void setOutput(ArrayList<ESPTimeSeries> output) {
        this.output = output;
    }

    public void setAnalysisPeriod(ModelDateTime start_date, ModelDateTime end_date) {
        this.PROCESS_trace(start_date, end_date);
    }

    public ArrayList<EnsembleListLabel> getStats() {
        return this.stats;
    }

    public ArrayList<EnsembleListLabel> getStatsInVolumeOrder() {
        return this.statsInVolumeOrder;
    }

    public ArrayList<EnsembleListLabel> getStatsInPeakOrder() {
        return this.statsInPeakOrder;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

