/*
 * Decompiled with CFR 0.152.
 */
package org.omscentral.modules.analysis.esp;

import org.omscentral.modules.analysis.esp.EnsembleListLabel;

public class ElNino {
    public static int UNKNOWN = 0;
    public static int LA_NINA = 1;
    public static int NEUTRAL = 2;
    public static int EL_NINO = 3;
    public static int NEG_PDO = 4;
    public static int POS_PDO = 5;
    public static int NEU_PDO = 6;
    private static int[] enso_year_codes = new int[]{LA_NINA, LA_NINA, LA_NINA, LA_NINA, LA_NINA, EL_NINO, EL_NINO, NEUTRAL, LA_NINA, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, EL_NINO, NEUTRAL, LA_NINA, EL_NINO, EL_NINO, LA_NINA, NEUTRAL, NEUTRAL, LA_NINA, LA_NINA, NEUTRAL, NEUTRAL, EL_NINO, NEUTRAL, NEUTRAL, EL_NINO, NEUTRAL, NEUTRAL, EL_NINO, NEUTRAL, EL_NINO, NEUTRAL, NEUTRAL, NEUTRAL, LA_NINA, LA_NINA, LA_NINA, EL_NINO, NEUTRAL, EL_NINO, EL_NINO, LA_NINA, LA_NINA, NEUTRAL, EL_NINO, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, LA_NINA, EL_NINO, NEUTRAL, NEUTRAL, NEUTRAL, EL_NINO, EL_NINO, NEUTRAL, LA_NINA, LA_NINA, NEUTRAL, NEUTRAL, NEUTRAL, LA_NINA, NEUTRAL, EL_NINO, EL_NINO, NEUTRAL, LA_NINA, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, LA_NINA, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, LA_NINA, NEUTRAL, EL_NINO, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, EL_NINO, NEUTRAL, NEUTRAL, EL_NINO, NEUTRAL, LA_NINA, NEUTRAL, NEUTRAL, LA_NINA, LA_NINA, LA_NINA, EL_NINO, NEUTRAL, NEUTRAL, NEUTRAL, NEUTRAL, EL_NINO, EL_NINO, NEUTRAL, LA_NINA, NEUTRAL, EL_NINO, NEUTRAL, LA_NINA, NEUTRAL, EL_NINO, EL_NINO, EL_NINO, EL_NINO, EL_NINO, NEUTRAL, EL_NINO, EL_NINO};
    private static int[] pdo_year_codes = new int[]{NEU_PDO, POS_PDO, NEU_PDO, NEU_PDO, POS_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEU_PDO, POS_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEG_PDO, NEU_PDO, NEG_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEU_PDO, POS_PDO, POS_PDO, NEU_PDO, NEU_PDO, NEU_PDO, POS_PDO, NEU_PDO, NEG_PDO, POS_PDO, POS_PDO, POS_PDO, POS_PDO, NEU_PDO, NEU_PDO, POS_PDO, POS_PDO, POS_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEG_PDO, NEU_PDO, NEU_PDO, NEG_PDO, NEG_PDO, NEG_PDO, NEG_PDO, NEU_PDO, NEU_PDO, NEG_PDO, NEG_PDO, NEU_PDO, POS_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEG_PDO, NEG_PDO, NEG_PDO, NEU_PDO, NEU_PDO, NEG_PDO, NEU_PDO, NEU_PDO, NEU_PDO, NEG_PDO, NEG_PDO, NEU_PDO, NEG_PDO, NEG_PDO, NEG_PDO, POS_PDO, NEU_PDO, NEU_PDO, POS_PDO, POS_PDO, NEU_PDO, POS_PDO, POS_PDO, POS_PDO, POS_PDO, POS_PDO, POS_PDO, NEU_PDO, NEU_PDO, NEG_PDO, POS_PDO, POS_PDO, POS_PDO, NEU_PDO, POS_PDO, POS_PDO, POS_PDO, NEG_PDO};

    public static boolean lookUp(int cat, EnsembleListLabel ell) {
        return ElNino.lookUp(cat, ell.getTraceYear());
    }

    public static boolean lookUp(int cat, int year) {
        if (cat == LA_NINA || cat == NEUTRAL || cat == EL_NINO) {
            if (year < 1872 || year > 1998) {
                return false;
            }
            if (enso_year_codes[year - 1872] == cat) {
                return true;
            }
        } else if (cat == NEG_PDO || cat == POS_PDO || cat == NEU_PDO) {
            if (year < 1901 || year > 1999) {
                return false;
            }
            if (pdo_year_codes[year - 1901] == cat) {
                return true;
            }
        }
        return false;
    }
}

