/*
 * Decompiled with CFR 0.152.
 */
package oms3.io;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DatedData {
    public static final int Daily = 0;
    public static final int MeanMonthly = 1;
    public static final int MonthlyMean = 2;
    public static final int AnnualMean = 3;
    public static final int PeriodMedian = 4;
    public static final int PeriodStandardDeviation = 5;
    public static final int PeriodMininum = 6;
    public static final int PeriodMaximum = 7;
    private List<Date> dates = new ArrayList<Date>();
    private List<Double> datas = new ArrayList<Double>();

    public DatedData() {
    }

    public DatedData(Date date, Double data) {
        this.dates.add(date);
        this.datas.add(data);
    }

    public void add(Date date, Double data) {
        this.dates.add(date);
        this.datas.add(data);
    }

    public void addDate(Date date) {
        this.dates.add(date);
    }

    public void addData(Double data) {
        this.datas.add(data);
    }

    public Date getDate(int i) {
        return this.dates.get(i);
    }

    public Double getData(int i) {
        return this.datas.get(i);
    }

    public int getNumDates() {
        return this.dates.size();
    }

    public int getNumData() {
        return this.datas.size();
    }

    public void writeDate(int i, Date date) {
        this.dates.set(i, date);
    }

    public void writeData(int i, Double data) {
        this.datas.set(i, data);
    }

    public double[] getMeanMonthly() {
        int i;
        int[] monthlyCount = new int[12];
        double[] monthlySum = new double[12];
        double[] meanMonthly = new double[12];
        for (int i2 = 0; i2 < 12; ++i2) {
            monthlyCount[i2] = 0;
            monthlySum[i2] = 0.0;
            meanMonthly[i2] = 0.0;
        }
        int totalCount = 0;
        for (i = 0; i < this.getNumData(); ++i) {
            Date date = this.getDate(i);
            double data = this.getData(i);
            int month = -1;
            if (i > this.getNumDates()) {
                throw new IllegalArgumentException("No date for data #" + i);
            }
            month = date.getMonth();
            if (month > 11) {
                throw new IllegalArgumentException("Month number data out of range: " + month);
            }
            int n = month;
            monthlyCount[n] = monthlyCount[n] + 1;
            int n2 = month;
            monthlySum[n2] = monthlySum[n2] + data;
            ++totalCount;
        }
        if (totalCount == 0) {
            throw new IllegalArgumentException("No data used in Mean Montly calculation.");
        }
        for (i = 0; i < 12; ++i) {
            meanMonthly[i] = monthlySum[i] / (double)monthlyCount[i];
        }
        return meanMonthly;
    }

    public double[] getMonthlyMean() {
        ArrayList<Double> monthlyMean = new ArrayList<Double>();
        int totalCount = 0;
        int previousYear = -1;
        int previousMonth = -1;
        boolean currentValid = false;
        for (int i = 0; i < this.getNumData(); ++i) {
            boolean isLastData;
            boolean sameMonthYear;
            int month = -1;
            int year = -1;
            double currentSum = 0.0;
            double currentCount = 0.0;
            Date date = this.getDate(i);
            double data = this.getData(i);
            if (i > this.getNumDates()) {
                throw new IllegalArgumentException("No matching date info for data #" + i);
            }
            month = date.getMonth();
            year = date.getYear();
            if (month > 11) {
                throw new IllegalArgumentException("Month number data out of range: " + month);
            }
            boolean bl = sameMonthYear = month == previousMonth && year == previousYear;
            if (sameMonthYear) {
                currentSum += data;
                currentCount += 1.0;
                currentValid = true;
            }
            boolean bl2 = isLastData = i == this.getNumData() - 1;
            if (currentValid && (!sameMonthYear || isLastData)) {
                if (currentValid) {
                    double currentMean = currentSum / currentCount;
                    monthlyMean.add(currentMean);
                }
                currentCount = 1.0;
                currentSum = data;
            }
            previousMonth = month;
            previousYear = year;
            ++totalCount;
        }
        if (totalCount == 0) {
            throw new IllegalArgumentException("No data used in Mean Monthly calculation.");
        }
        double[] arr = new double[monthlyMean.size()];
        for (int i = 0; i < monthlyMean.size(); ++i) {
            arr[i] = (Double)monthlyMean.get(i);
        }
        return arr;
    }

    public double[] getOriginalData() {
        double[] originalData = new double[this.datas.size()];
        return originalData;
    }

    public double[] getDailyData() {
        double[] originalData = new double[this.datas.size()];
        return originalData;
    }

    public double[] computeData(int TimeStep) {
        switch (TimeStep) {
            case 0: {
                return this.getDailyData();
            }
            case 1: {
                return this.getMeanMonthly();
            }
            case 2: {
                return this.getMonthlyMean();
            }
        }
        return this.getOriginalData();
    }
}

