/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.cosu;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ngmf.util.OutputStragegy;
import ngmf.util.cosu.luca.ExecutionHandle;
import ngmf.util.cosu.luca.ParameterData;
import ngmf.util.cosu.luca.SCE;
import oms3.ComponentAccess;
import oms3.ComponentException;
import oms3.Compound;
import oms3.Conversions;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.Initialize;
import oms3.dsl.AbstractSimulation;
import oms3.dsl.Buildable;
import oms3.dsl.Output;
import oms3.dsl.cosu.Step;
import oms3.io.DataIO;

public class Luca
extends AbstractSimulation {
    List<Step> steps = new ArrayList<Step>();
    Date calib_start;
    int rounds = 1;

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("step")) {
            Step step = new Step(this.steps.size() + 1);
            this.steps.add(step);
            return step;
        }
        if (name.equals("rounds")) {
            this.rounds = (Integer)value;
            if (this.rounds < 1) {
                throw new ComponentException("Illegal 'rounds': " + this.rounds);
            }
        } else if (name.equals("calibration_start")) {
            this.calib_start = Conversions.convert(value, Date.class);
        } else {
            return super.create(name, value);
        }
        return LEAF;
    }

    @Override
    public Object run() throws Exception {
        if (this.getModel() == null) {
            throw new ComponentException("missing 'model'.");
        }
        if (this.calib_start == null) {
            throw new ComponentException("missing 'calibration_start'");
        }
        if (this.steps.isEmpty()) {
            throw new ComponentException("missing 'step' definition(s)");
        }
        ModelExecution exec = new ModelExecution();
        Object end = exec.getParameter().get("endTime");
        Date endTime = Conversions.convert(end, Date.class);
        if (this.calib_start.after(endTime)) {
            throw new ComponentException("illegal calibration_start: " + this.calib_start);
        }
        for (Step step : this.steps) {
            step.init(exec, this.calib_start, endTime, this.rounds);
        }
        for (int r = 0; r < this.rounds; ++r) {
            for (int s = 0; s < this.steps.size(); ++s) {
                Step step = this.steps.get(s);
                Step.Data stepData = step.round()[r];
                System.out.println("\n\n>>>>>>>>>>>>>>  Round [" + (r + 1) + "]  Step [" + step.getName() + "] <<<<<<<<<<<<<<");
                SCE sce = new SCE(exec, step, stepData);
                sce.run();
                exec.writeParameterCopy(step, r);
                step.post(r, stepData);
                Runtime.getRuntime().gc();
            }
        }
        Compound.shutdown();
        return null;
    }

    class ModelExecution
    implements ExecutionHandle {
        File lastFolder;
        Map<String, Object> parameter;

        public ModelExecution() throws IOException {
            OutputStragegy st = Luca.this.getOutput().getOutputStrategy(Luca.this.getName());
            this.lastFolder = st.nextOutputFolder();
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Simulation output folder: " + this.lastFolder);
            }
            this.lastFolder.mkdirs();
            this.parameter = Luca.this.getModel().getParameter();
            Logger.getLogger("oms3.model").setLevel(Level.WARNING);
        }

        Map<String, Object> getParameter() {
            return this.parameter;
        }

        @Override
        public void execute(Step.Data step) throws Exception {
            String libPath = Luca.this.getModel().getLibpath();
            if (libPath != null) {
                System.setProperty("jna.library.path", libPath);
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Setting jna.library.path to " + libPath);
                }
            }
            Object comp = Luca.this.getModel().getComponent();
            this.writeParameterFile(step);
            log.config("Init ...");
            ComponentAccess.callAnnotated(comp, Initialize.class, true);
            boolean success = ComponentAccess.setInputData(this.parameter, comp, log);
            if (!success) {
                throw new RuntimeException("There are Parameter problems. Simulation exits.");
            }
            boolean adjusted = ComponentAccess.adjustOutputPath(this.lastFolder, comp, log);
            for (Output e : Luca.this.getOut()) {
                e.setup(comp, this.lastFolder, Luca.this.getName());
            }
            log.config("Exec ...");
            ComponentAccess.callAnnotated(comp, Execute.class, false);
            log.config("Finalize ...");
            ComponentAccess.callAnnotated(comp, Finalize.class, true);
            for (Output e : Luca.this.getOut()) {
                e.done();
            }
        }

        @Override
        public void writeParameterFile(Step.Data step) {
            ParameterData[] paramData = step.paramData;
            for (int i = 0; i < paramData.length; ++i) {
                String name = paramData[i].getName();
                int calibType = paramData[i].getCalibrationType();
                double[] val = paramData[i].getDataValue();
                if (calibType == 3) {
                    int[] ival = new int[val.length];
                    for (int j = 0; j < val.length; ++j) {
                        ival[j] = (int)val[j];
                    }
                    this.parameter.put(name, this.toValueI(name, ival));
                    continue;
                }
                this.parameter.put(name, this.toValue(name, val));
            }
        }

        public void writeParameterCopy(Step step, int round) throws FileNotFoundException {
            File params = new File(this.lastFolder, "round-" + (round + 1) + "_step-" + step.getName() + ".csv");
            System.out.println(" Final parameter file: '" + params + "'");
            PrintWriter pw = new PrintWriter(params);
            DataIO.print(this.parameter, "Parameter", pw);
            pw.close();
        }

        private Object toValue(String name, double[] vals) {
            Object orig = this.parameter.get(name);
            if (orig.toString().indexOf(123) > -1) {
                return Conversions.convert(vals, String.class);
            }
            return Double.toString(vals[0]);
        }

        private Object toValueI(String name, int[] vals) {
            Object orig = this.parameter.get(name);
            if (orig.toString().indexOf(123) > -1) {
                return Conversions.convert(vals, String.class);
            }
            return Integer.toString(vals[0]);
        }
    }
}

