/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.cosu;

import java.io.File;
import java.util.EventObject;
import java.util.logging.Logger;
import ngmf.util.OutputStragegy;
import ngmf.util.SimpleDirectoryOutput;
import ngmf.util.cosu.GLUE;
import oms3.ComponentAccess;
import oms3.Compound;
import oms3.Notification;
import oms3.dsl.Buildable;
import oms3.dsl.Model;
import oms3.dsl.OutputDescriptor;
import oms3.io.CSProperties;

public class Glue
implements Buildable,
Runnable {
    private static final Logger log = Logger.getLogger("oms3.sim");
    Model model;
    String name;
    OutputDescriptor output;
    int count;

    public void setCount(int count) {
        this.count = count;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("model")) {
            if (this.model != null) {
                throw new IllegalArgumentException("Only one 'model' allowed.");
            }
            this.model = new Model();
            return this.model;
        }
        if (name.equals("output")) {
            this.output = new OutputDescriptor();
            return this.output;
        }
        throw new IllegalArgumentException(name.toString());
    }

    @Override
    public void run() {
        System.out.println("Execute");
        try {
            OutputStragegy st = this.output == null ? new SimpleDirectoryOutput(new File(System.getProperty("user.dir")), this.getName()) : this.output.getOutputStrategy(this.getName());
            File outFolder = st.nextOutputFolder();
            Compound comp = (Compound)this.model.getComponent();
            comp.addListener(new Notification.Listener(){

                @Override
                public void notice(Notification.Type T, EventObject E) {
                    if (T == Notification.Type.OUT) {
                        Notification.DataflowEvent e = (Notification.DataflowEvent)E;
                        System.out.println(e.getAccess().getField().getName() + " in " + e.getAccess().getComponent());
                    }
                }
            });
            GLUE glue = new GLUE(this.model.getParameter());
            for (int i = 0; i < this.count; ++i) {
                System.out.println("Glue run #" + i);
                glue.newParamSet();
                CSProperties p = this.model.getParameter();
                ComponentAccess.setInputData(p, comp, log);
                comp.execute();
            }
            comp.finalizeComponents();
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }
}

