/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ngmf.ui.graph.PlotView;
import ngmf.ui.graph.ValueSet;
import ngmf.util.OutputStragegy;
import oms3.dsl.Buildable;
import oms3.dsl.analysis.EspTrace;
import oms3.dsl.analysis.FlowDur;
import oms3.dsl.analysis.Plot;
import oms3.dsl.analysis.Scatter;
import org.omscentral.modules.analysis.esp.ESPToolPanel;

public class Chart
implements Buildable {
    String title = "Chart";
    List<Buildable> plots = new ArrayList<Buildable>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("timeseries")) {
            Plot p = new Plot();
            this.plots.add(p);
            return p;
        }
        if (name.equals("flowduration")) {
            FlowDur f = new FlowDur();
            this.plots.add(f);
            return f;
        }
        if (name.equals("scatter")) {
            Scatter f = new Scatter();
            this.plots.add(f);
            return f;
        }
        if (name.equals("esptraces")) {
            EspTrace f = new EspTrace();
            this.plots.add(f);
            return f;
        }
        throw new IllegalArgumentException(name.toString());
    }

    public void run(OutputStragegy st, String name) {
        try {
            JPanel panel = new JPanel(new BorderLayout());
            JTabbedPane tabs = new JTabbedPane();
            panel.add((Component)tabs, "Center");
            for (Buildable b : this.plots) {
                ArrayList<Double[]> vals;
                ArrayList<String> names;
                Buildable p;
                if (b instanceof Plot) {
                    p = (Plot)b;
                    names = new ArrayList<String>();
                    for (ValueSet axis : ((Plot)p).getY()) {
                        names.add(axis.getName());
                    }
                    vals = new ArrayList<Double[]>();
                    for (ValueSet axis : ((Plot)p).getY()) {
                        vals.add(axis.getDoubles(st.baseFolder(), name));
                    }
                    String view = ((Plot)p).getView();
                    int type = 1;
                    if (view.equals("stacked")) {
                        type = 0;
                    } else if (view.equals("multi")) {
                        type = 1;
                    } else if (view.equals("combined")) {
                        type = 2;
                    }
                    tabs.addTab(((Plot)p).getTitle(), PlotView.createTSChart(((Plot)p).getTitle(), ((Plot)p).getX().getDates(st.baseFolder(), name), names, vals, type, ((Plot)p).getY()));
                    continue;
                }
                if (b instanceof FlowDur) {
                    p = (FlowDur)b;
                    names = new ArrayList();
                    for (ValueSet axis : ((FlowDur)p).getY()) {
                        names.add(axis.getName());
                    }
                    vals = new ArrayList();
                    for (ValueSet axis : ((FlowDur)p).getY()) {
                        vals.add(axis.getDoubles(st.baseFolder(), name));
                    }
                    Integer[] i = new Integer[100];
                    for (int j = 0; j < i.length; ++j) {
                        i[j] = j;
                    }
                    tabs.addTab(((FlowDur)p).getTitle(), PlotView.createLineChart(((FlowDur)p).getTitle(), i, names, vals));
                    continue;
                }
                if (b instanceof Scatter) {
                    p = (Scatter)b;
                    tabs.addTab(((Scatter)p).getTitle(), PlotView.createScatterChart(((Scatter)p).getTitle(), ((Scatter)p).getX().getName(), ((Scatter)p).getY().getName(), ((Scatter)p).getX().getDoubles(st.baseFolder(), name), ((Scatter)p).getY().getDoubles(st.baseFolder(), name)));
                    continue;
                }
                if (!(b instanceof EspTrace)) continue;
                p = (EspTrace)b;
                ESPToolPanel pa = PlotView.createESPTraces(((EspTrace)p).getTitle(), ((EspTrace)p).getDir(st), ((EspTrace)p).getVar());
                String report = ((EspTrace)p).getReport(st);
                if (report != null) {
                    pa.writeReport(report);
                }
                tabs.addTab(((EspTrace)p).getTitle(), pa);
            }
            if (tabs.getTabCount() == 0) {
                return;
            }
            JFrame f = new JFrame(this.getTitle() + "  [" + st.lastOutputFolder() + "]");
            f.setDefaultCloseOperation(3);
            f.getContentPane().add(panel);
            f.setIconImage(new ImageIcon(PlotView.class.getResource("/ngmf/ui/graph/bar-chart-16x16.png")).getImage());
            f.setSize(800, 600);
            f.setLocation(500, 300);
            f.setVisible(true);
            f.toFront();
        }
        catch (Exception E) {
            E.printStackTrace(System.out);
        }
    }
}

