/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.analysis;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ngmf.ui.calc.Mathx;
import ngmf.ui.graph.ValueSet;
import oms3.dsl.Buildable;
import oms3.dsl.analysis.Axis;
import oms3.util.Stats;

public class Calc
implements Buildable,
ValueSet {
    Map<String, Double[]> m = new HashMap<String, Double[]>();
    Map<String, Axis> ma = new HashMap<String, Axis>();
    Resolver symtab = new Resolver();
    Object[] context = new Object[]{this.symtab};
    Library lib = new Library(new Class[]{Math.class, Mathx.class, Stats.class}, new Class[]{Resolver.class}, null, this.symtab, null);
    static final String DOUBLE = "D";
    String eq;
    boolean acc = false;
    String title;
    boolean shape = false;
    boolean line = true;

    Calc() {
        try {
            this.lib.markStateDependent("random", null);
            this.lib.markStateDependent("random", new Class[]{Double.TYPE, Double.TYPE});
            this.lib.markStateDependent("ramp", new Class[]{Double.TYPE, Double.TYPE});
            this.lib.markStateDependent("reset_ramp", null);
        }
        catch (CompilationException ex) {
            ex.printStackTrace();
        }
    }

    public void setLine(boolean line) {
        this.line = line;
    }

    public void setShape(boolean shape) {
        this.shape = shape;
    }

    @Override
    public boolean isLine() {
        return this.line;
    }

    @Override
    public boolean isShape() {
        return this.shape;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEq(String eq) {
        this.eq = eq;
    }

    public void setAcc(boolean acc) {
        this.acc = acc;
    }

    @Override
    public Buildable create(Object name, Object value) {
        Axis a = new Axis();
        this.ma.put(name.toString(), a);
        return a;
    }

    @Override
    public Double[] getDoubles(File st, String simName) throws IOException {
        if (this.eq == null) {
            throw new IllegalArgumentException("missing equation in 'eq'");
        }
        int len = -1;
        for (String key : this.ma.keySet()) {
            Axis a = this.ma.get(key);
            Double[] v = a.getDoubles(st, simName);
            if (len == -1) {
                len = v.length;
            } else if (len != v.length) {
                throw new IllegalArgumentException("array length problem: " + key);
            }
            this.m.put(key, v);
        }
        Double[] result = new Double[len];
        try {
            CompiledExpression expr_c = Evaluator.compile(this.eq.trim(), this.lib);
            try {
                double sum = 0.0;
                for (int row = 0; row < len; ++row) {
                    this.symtab.setRow(row);
                    Object r = expr_c.evaluate(this.context);
                    if (r == null) continue;
                    result[row] = this.acc ? (sum += ((Double)r).doubleValue()) : (Double)r;
                }
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
            }
        }
        catch (CompilationException ce) {
            StringBuffer b = new StringBuffer();
            b.append("  ERROR: ");
            b.append(ce.getMessage() + "\n");
            b.append("                       ");
            b.append(this.eq + "\n");
            int column = ce.getColumn();
            for (int i = 0; i < column + 23 - 1; ++i) {
                b.append(' ');
            }
            b.append("^\n");
            System.out.println(b.toString());
        }
        return result;
    }

    @Override
    public String getName() {
        return this.title == null ? "Equation '" + this.eq + "' " + (this.acc ? "(accumulated)" : "") : this.title;
    }

    public class Resolver
    extends DVMap {
        int row;

        void setRow(int row) {
            this.row = row;
        }

        @Override
        public String getTypeName(String name) {
            if (Calc.this.m.get(name) != null) {
                return Calc.DOUBLE;
            }
            return null;
        }

        public double getDProperty(String name) {
            return Calc.this.m.get(name)[this.row];
        }
    }
}

