/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import ngmf.util.OutputStragegy;
import ngmf.util.Validation;
import oms3.ComponentAccess;
import oms3.ComponentException;
import oms3.Compound;
import oms3.Notification;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.Initialize;
import oms3.annotations.SourceInfo;
import oms3.annotations.VersionInfo;
import oms3.doc.Documents;
import oms3.dsl.AbstractSimulation;
import oms3.dsl.Buildable;
import oms3.dsl.Efficiency;
import oms3.dsl.GenericBuilderSupport;
import oms3.dsl.Logging;
import oms3.dsl.Ontology;
import oms3.dsl.Output;
import oms3.dsl.Resource;
import oms3.dsl.Summary;
import oms3.io.CSProperties;
import oms3.util.Components;

public class Sim
extends AbstractSimulation {
    String alg = System.getProperty("oms3.digest.algorithm", "SHA-256");
    Ontology ontology;
    List<Efficiency> eff = new ArrayList<Efficiency>();
    List<Summary> sum = new ArrayList<Summary>();
    File lastFolder;
    boolean digest = false;
    boolean sanitychecks = true;
    Closure pre;
    Closure post;

    public void setSanitychecks(boolean sanitychecks) {
        this.sanitychecks = sanitychecks;
    }

    public void setDigest(boolean digest) {
        this.digest = digest;
    }

    public void setPre(Closure pre) {
        this.pre = pre;
    }

    public void setPost(Closure post) {
        this.post = post;
    }

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("ontology")) {
            this.ontology = new Ontology();
            return this.ontology;
        }
        if (name.equals("efficiency")) {
            Efficiency e = new Efficiency();
            this.eff.add(e);
            return e;
        }
        if (name.equals("summary")) {
            Summary e = new Summary();
            this.sum.add(e);
            return e;
        }
        return super.create(name, value);
    }

    @Override
    public Object run() throws Exception {
        Compound c;
        boolean adjusted;
        String libPath;
        if (this.getModel() == null) {
            throw new ComponentException("missing 'model' element.");
        }
        Compound.reload();
        if (!this.sanitychecks) {
            System.setProperty("oms.skipCheck", "true");
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Run configuration ...");
        }
        if (this.digest) {
            String d = this.digest(this.res);
            System.setProperty("oms3.digest", d);
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Setting system property 'oms3.digest' to " + d);
            }
        }
        if ((libPath = this.model.getLibpath()) != null) {
            System.setProperty("jna.library.path", libPath);
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Setting jna.library.path to " + libPath);
            }
        }
        Object comp = this.model.getComponent();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("TL component " + comp);
        }
        Logger.getLogger("oms3.model").setLevel(Level.OFF);
        Logging l = this.model.getComponentLogging();
        Map<String, String> cl = l.getCompLevels();
        for (String compname : cl.keySet()) {
            String cll = cl.get(compname);
            Level level = Level.parse(cll);
            Logger logger = Logger.getLogger("oms3.model." + compname);
            logger.setUseParentHandlers(false);
            logger.setLevel(level);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(level);
            consoleHandler.setFormatter(new GenericBuilderSupport.CompLR());
            logger.addHandler(consoleHandler);
        }
        if (this.pre != null) {
            this.pre.call(comp);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Init ...");
        }
        ComponentAccess.callAnnotated(comp, Initialize.class, true);
        CSProperties parameter = this.model.getParameter();
        boolean success = ComponentAccess.setInputData(parameter, comp, log);
        if (!success) {
            throw new ComponentException("There are Parameter problems. Simulation exits.");
        }
        OutputStragegy st = this.output.getOutputStrategy(this.getName());
        this.lastFolder = st.nextOutputFolder();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Simulation output folder: " + this.lastFolder);
        }
        if (adjusted = ComponentAccess.adjustOutputPath(this.lastFolder, comp, log)) {
            this.lastFolder.mkdirs();
        }
        if (comp instanceof Compound && log.isLoggable(Level.FINEST)) {
            c = (Compound)comp;
            c.addListener(new Notification.Listener(){

                @Override
                public void notice(Notification.Type arg0, EventObject arg1) {
                    AbstractSimulation.log.finest((Object)((Object)arg0) + " -> " + arg1);
                }
            });
        }
        if (this.sanitychecks && comp instanceof Compound) {
            c = (Compound)comp;
            c.addListener(new Notification.Listener(){

                @Override
                public void notice(Notification.Type arg0, EventObject arg1) {
                    Notification.ExceptionEvent ee;
                    if (arg0 == Notification.Type.EXCEPTION && (ee = (Notification.ExceptionEvent)arg1).getException() != null) {
                        AbstractSimulation.log.severe((Object)((Object)arg0) + " -> " + ee);
                    }
                }
            });
            if (log.isLoggable(Level.FINE)) {
                c.addListener(new Notification.Listener(){

                    @Override
                    public void notice(Notification.Type arg0, EventObject arg1) {
                        Notification.DataflowEvent e;
                        Object v;
                        if (arg0 == Notification.Type.OUT && (v = (e = (Notification.DataflowEvent)arg1).getValue()) == null) {
                            AbstractSimulation.log.fine("'null' output from " + e.getAccess().toString());
                        }
                    }
                });
            }
        }
        for (Efficiency efficiency : this.eff) {
            efficiency.setup(comp);
        }
        for (Summary summary : this.sum) {
            summary.setup(comp);
        }
        for (Output output : this.out) {
            output.setup(comp, this.lastFolder, this.getName());
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Exec ...");
        }
        long t2 = System.currentTimeMillis();
        ComponentAccess.callAnnotated(comp, Execute.class, false);
        long t3 = System.currentTimeMillis();
        if (log.isLoggable(Level.INFO)) {
            log.info("Finalize ...");
        }
        ComponentAccess.callAnnotated(comp, Finalize.class, true);
        if (comp instanceof Compound) {
            Compound c2 = (Compound)comp;
            c2.shutdown();
        }
        for (Efficiency efficiency : this.eff) {
            efficiency.printEff(this.lastFolder);
        }
        for (Summary summary : this.sum) {
            summary.printSum(this.lastFolder);
        }
        for (Output output : this.out) {
            output.done();
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Finished [" + (t3 - t2) + " ms]");
        }
        if (this.post != null) {
            this.post.call(comp);
        }
        return comp;
    }

    @Override
    public void doc() throws Exception {
        OutputStragegy st = this.output.getOutputStrategy(this.getName());
        st.lastOutputFolder().mkdirs();
        this.document(new File(st.lastOutputFolder(), this.getName() + ".xml"));
    }

    void document(File file) throws Exception {
        Locale locale = Locale.getDefault();
        if (System.getProperty("oms3.locale.lang") != null) {
            locale = new Locale(System.getProperty("oms3.locale.lang"));
        }
        Documents.db5Sim(file, this.model.getComponent().getClass(), this.model.getParameter(), this.getName(), locale);
        System.out.println(" Generated: " + file);
    }

    @Override
    public void dig() throws Exception {
        System.out.println("Digest [" + this.alg + "]:");
        System.out.println(this.digest());
    }

    public String digest() throws Exception {
        StringBuffer b = new StringBuffer();
        b.append(this.digest(this.res) + '\n');
        Collection<Class<?>> c = Components.internalComponents(this.model.getComponent().getClass());
        for (Class<?> cl : c) {
            b.append("    " + cl.getName() + " & ");
            SourceInfo si = cl.getAnnotation(SourceInfo.class);
            if (si != null) {
                b.append(si.value());
            }
            b.append(" ; ");
            VersionInfo vi = cl.getAnnotation(VersionInfo.class);
            if (vi != null) {
                b.append(vi.value());
            }
            b.append('\n');
        }
        for (File f : this.res.filterFiles("csv")) {
            b.append("    " + f.getName() + " & ");
            b.append('\n');
        }
        return b.toString();
    }

    private String digest(Resource r) {
        if (r.getRecources().isEmpty()) {
            return null;
        }
        ArrayList<File> f = new ArrayList<File>();
        for (String s : r.getRecources()) {
            f.add(new File(s));
        }
        return Validation.hexDigest(this.alg, f.toArray(new File[0]));
    }
}

