/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ngmf.util.WildcardFileFilter;
import oms3.ComponentException;

public class Resource {
    List<String> l = new ArrayList<String>();

    public void addResource(Object arg) {
        if (arg == null) {
            throw new ComponentException("No resource string  provided.");
        }
        if (arg.getClass() == String.class) {
            this.l.add((String)arg);
        } else if (arg instanceof Collection) {
            this.l.addAll((Collection)arg);
        } else {
            this.l.add(arg.toString());
        }
    }

    public List<String> getRecources() {
        ArrayList<String> f = new ArrayList<String>();
        for (String s : this.l) {
            File[] fi;
            File sf = new File(s);
            File parent = sf.getParentFile();
            if (!parent.exists()) {
                throw new IllegalArgumentException("Not found: " + parent);
            }
            for (File file : fi = parent.listFiles(new WildcardFileFilter(sf.getName()))) {
                f.add(file.toString());
            }
        }
        return f;
    }

    public List<File> filterFiles(String ext) {
        ArrayList<File> f = new ArrayList<File>();
        for (String s : this.l) {
            File sf = new File(s);
            File parent = sf.getParentFile();
            if (!parent.exists()) {
                throw new IllegalArgumentException("Not found: " + parent);
            }
            for (File file : parent.listFiles(new WildcardFileFilter(sf.getName()))) {
                if (!file.getName().endsWith(ext)) continue;
                f.add(file);
            }
        }
        return f;
    }

    public List<File> filterDirectories() {
        ArrayList<File> f = new ArrayList<File>();
        for (String s : this.l) {
            File sf = new File(s);
            if (!sf.isDirectory() || !sf.exists()) continue;
            f.add(sf);
        }
        return f;
    }
}

