/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.CLI;
import oms3.ComponentException;
import oms3.dsl.Buildable;
import oms3.util.Processes1;

public class Exec
implements Buildable {
    protected static final Logger log = Logger.getLogger("oms3.sim");
    String file;
    Type type;
    String targets = "";

    public Exec(Type type) {
        this.type = type;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public void setTarget(String targets) {
        this.targets = targets;
    }

    public String getTargets() {
        return this.targets;
    }

    public void run() throws Exception {
        File runFile = new File(this.file);
        if (!runFile.exists()) {
            throw new ComponentException("Not found : " + this.file);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Executing: " + this.file);
        }
        switch (this.type) {
            case GROOVY: {
                CLI.evaluateGroovyScript(runFile.getAbsolutePath());
                break;
            }
            case ANT: {
                Object p;
                String q = File.pathSeparatorChar == ';' ? "\"" : "";
                String version = System.getProperty("oms.version");
                String oms3Home = System.getProperty("oms.home");
                String[] antoptions = new String[]{};
                File conf = new File(System.getProperty("oms.prj") + File.separatorChar + ".oms", "project.properties");
                if (conf.exists()) {
                    p = new Properties();
                    FileReader fr = new FileReader(conf);
                    ((Properties)p).load(fr);
                    fr.close();
                    String opt = ((Properties)p).getProperty("ant.options");
                    if (log.isLoggable(Level.INFO)) {
                        log.info("ant.options: " + opt);
                    }
                    if (opt != null) {
                        antoptions = opt.trim().split("\\s+");
                    }
                }
                p = new Processes1(new File(File.pathSeparatorChar == ';' ? "ant.bat" : "ant"));
                ((Processes1)p).setLog(log);
                ((Processes1)p).setArguments(antoptions, "-Doms.version=" + version, "-lib", q + oms3Home + q, "-f", q + runFile.toString() + q, this.targets.trim().split("\\s+"));
                ((Processes1)p).redirectOutput(new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        System.out.println(new String(cbuf, off, len));
                    }

                    @Override
                    public void flush() throws IOException {
                        System.out.flush();
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
                ((Processes1)p).redirectError(new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        System.err.println(new String(cbuf, off, len));
                    }

                    @Override
                    public void flush() throws IOException {
                        System.err.flush();
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
                try {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Starting ...");
                    }
                    int exitValue = ((Processes1)p).exec();
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Finished with exit code " + exitValue);
                    }
                    if (exitValue != 0) {
                        throw new ComponentException("ant failed, simulation stopped.");
                    }
                    break;
                }
                catch (IOException E) {
                    throw new ComponentException("Check your 'PATH', " + E.getMessage());
                }
            }
            default: {
                throw new ComponentException("Unknown Execution type. " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public Buildable create(Object name, Object value) {
        return LEAF;
    }

    public static enum Type {
        GROOVY,
        ANT,
        EXE,
        JAVA;

    }
}

