/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import ngmf.util.cosu.Efficiencies;
import oms3.ComponentException;
import oms3.Compound;
import oms3.Conversions;
import oms3.Notification;
import oms3.dsl.Buildable;
import oms3.dsl.Util;

public class Efficiency
implements Buildable {
    String methods = "ns1 ";
    String obs;
    int[] obs_idx;
    String sim;
    String precip;
    List<Number> obs_l = new ArrayList<Number>();
    List<Number> sim_l = new ArrayList<Number>();
    List<Number> precip_l = new ArrayList<Number>();
    String file;

    public void setFile(String file) {
        this.file = file;
    }

    public void setMethods(String methods) {
        this.methods = methods;
    }

    public void setPrecip(String precip) {
        this.precip = precip;
    }

    public void setObs(String obs) {
        String[] l = Conversions.parseArrayElement(obs);
        this.obs = l[0];
        this.obs_idx = Util.arraysDims(l);
    }

    public void setSim(String sim) {
        this.sim = sim;
    }

    @Override
    public Buildable create(Object name, Object value) {
        return LEAF;
    }

    public void setup(Object comp) {
        if (this.obs == null || this.sim == null) {
            throw new ComponentException("obs/sim variable not set.");
        }
        if (comp instanceof Compound) {
            Compound c = (Compound)comp;
            c.addListener(new Notification.Listener(){

                @Override
                public void notice(Notification.Type T, EventObject E) {
                    if (T == Notification.Type.OUT) {
                        Notification.DataflowEvent e = (Notification.DataflowEvent)E;
                        if (e.getAccess().getField().getName().equals(Efficiency.this.obs)) {
                            if (Efficiency.this.obs_idx == null) {
                                Efficiency.this.obs_l.add((Number)e.getValue());
                            } else {
                                Efficiency.this.obs_l.add((Number)Util.accessArray(Efficiency.this.obs, e.getValue(), Efficiency.this.obs_idx));
                            }
                        } else if (e.getAccess().getField().getName().equals(Efficiency.this.sim)) {
                            Efficiency.this.sim_l.add((Number)e.getValue());
                        }
                        if (e.getAccess().getField().getName().equals(Efficiency.this.precip)) {
                            Efficiency.this.precip_l.add((Number)e.getValue());
                        }
                    }
                }
            });
        }
    }

    String result() {
        if (this.sim_l.size() != this.obs_l.size()) {
            throw new ComponentException("obs/sim mismatch: " + this.obs_l.size() + "/" + this.sim_l.size());
        }
        if (this.methods.isEmpty()) {
            return "No efficiency specified.";
        }
        StringBuffer b = new StringBuffer(String.format(Locale.US, "%-15s ", "Efficiencies"));
        for (String m : this.methods.split(" ")) {
            b.append(String.format(Locale.US, "%10s ", m));
        }
        b.append('\n');
        b.append(String.format(Locale.US, "%15s ", this.obs + "/" + this.sim));
        double[] obsarr = Util.convertNumber(this.obs_l);
        double[] simarr = Util.convertNumber(this.sim_l);
        double eff = 0.0;
        for (String m : this.methods.split(" ")) {
            double[] rc;
            if ("ns1 ".startsWith(m)) {
                eff = Efficiencies.nashSutcliffe(obsarr, simarr, 2.0);
            } else if ("logns1 ".startsWith(m)) {
                eff = Efficiencies.nashSutcliffeLog(obsarr, simarr, 1.0);
            } else if ("logns2 ".startsWith(m)) {
                eff = Efficiencies.nashSutcliffeLog(obsarr, simarr, 2.0);
            } else if ("ioa1 ".startsWith(m)) {
                eff = Efficiencies.ioa(obsarr, simarr, 1.0);
            } else if ("ioa2 ".startsWith(m)) {
                eff = Efficiencies.ioa(obsarr, simarr, 2.0);
            } else if ("r2 ".startsWith(m)) {
                rc = Efficiencies.linearReg(obsarr, simarr);
                eff = rc[2];
            } else if ("grad ".startsWith(m)) {
                rc = Efficiencies.linearReg(obsarr, simarr);
                eff = rc[1];
            } else if ("wr2 ".startsWith(m)) {
                rc = Efficiencies.linearReg(obsarr, simarr);
                eff = rc[1] <= 1.0 ? Math.abs(rc[1]) * rc[2] : Math.pow(Math.abs(rc[1]), -1.0) * rc[2];
            } else if ("dsgrad ".startsWith(m)) {
                eff = Efficiencies.dsGrad(obsarr, simarr);
            } else if ("ave ".startsWith(m)) {
                eff = Efficiencies.absVolumeError(obsarr, simarr);
            } else if ("rmse ".startsWith(m)) {
                eff = Efficiencies.rmse(obsarr, simarr);
            } else if ("pbias ".startsWith(m)) {
                eff = Efficiencies.pbias(obsarr, simarr);
            } else if ("pmcc ".startsWith(m)) {
                eff = Efficiencies.pearsonsCorrelatrion(obsarr, simarr);
            } else if ("absdif ".startsWith(m)) {
                eff = Efficiencies.absDiff(obsarr, simarr);
            } else if ("logabsdif ".startsWith(m)) {
                eff = Efficiencies.absDiffLog(obsarr, simarr);
            } else if ("trmse ".startsWith(m)) {
                eff = Efficiencies.transformedRmse(obsarr, simarr);
            } else if ("roce ".startsWith(m)) {
                if (this.precip_l.size() == 0) {
                    throw new ComponentException("missing precip for computing ROCE");
                }
                double[] precarr = Util.convertNumber(this.precip_l);
                eff = Efficiencies.runoffCoefficientError(obsarr, simarr, precarr);
            } else {
                throw new ComponentException("Unknown Efficiency'" + m + '\"');
            }
            b.append(String.format(Locale.US, "%10.5f ", eff));
        }
        return b.toString();
    }

    void printEff(File dir) throws IOException {
        PrintWriter w = this.file != null ? new PrintWriter(new FileWriter(new File(dir, this.file), true)) : new PrintWriter(new OutputStreamWriter(System.out));
        w.println(this.result());
        w.flush();
        if (this.file != null) {
            w.close();
        }
    }
}

