/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class BeanBuilder {
    HashMap<String, PropertyDescriptor> propertyMap;
    Class beanClass;

    BeanBuilder(Class beanClass) throws IntrospectionException {
        this.beanClass = beanClass;
        this.loadBean();
    }

    protected void loadBean() throws IntrospectionException {
        this.propertyMap = new HashMap();
        BeanInfo info = Introspector.getBeanInfo(this.beanClass);
        PropertyDescriptor[] properties = info.getPropertyDescriptors();
        for (int i = 0; i < properties.length; ++i) {
            this.propertyMap.put(properties[i].getName(), properties[i]);
        }
    }

    public boolean isIndexedProperty(String property) {
        return this.propertyMap.get(property) instanceof IndexedPropertyDescriptor;
    }

    public boolean hasProperty(String property) {
        return this.propertyMap.containsKey(property);
    }

    public void setProperties(Object instance, Map map) throws IllegalAccessException, InvocationTargetException {
        if (map == null) {
            return;
        }
        for (Object object : map.keySet()) {
            String property = (String)object;
            Object v = map.get(property);
            if (this.isIndexedProperty(property)) {
                Map m = (Map)v;
                for (Object object1 : m.keySet()) {
                    Number n = (Number)object1;
                    Object propVal = m.get(n);
                    this.setProperty(instance, property, n, propVal);
                }
                continue;
            }
            this.setProperty(instance, property, v);
        }
    }

    public void setProperty(Object instance, String property, Number index, Object value) throws IllegalAccessException, InvocationTargetException {
        this.setProperty(instance, property, index.intValue(), value);
    }

    public void setProperty(Object instance, String property, int index, Object value) throws IllegalAccessException, InvocationTargetException {
        IndexedPropertyDescriptor desc = (IndexedPropertyDescriptor)this.propertyMap.get(property);
        if (desc == null) {
            throw new IllegalArgumentException("Invalid property '" + property + "'");
        }
        Method meth = desc.getIndexedWriteMethod();
        Class<?> propertyType = desc.getIndexedPropertyType();
        Object arg = this.getPropertyTypeValue(propertyType, value);
        meth.invoke(instance, new Integer(index), arg);
    }

    public void setProperty(Object instance, String property, Object value) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor desc = this.propertyMap.get(property);
        if (desc == null) {
            throw new IllegalArgumentException("Invalid property '" + property + "'");
        }
        Method meth = desc.getWriteMethod();
        Class<?> propertyType = desc.getPropertyType();
        if (propertyType == null) {
            meth.invoke(instance, value);
            return;
        }
        Object arg = this.getPropertyTypeValue(propertyType, value);
        meth.invoke(instance, arg);
    }

    private Object getPropertyTypeValue(Class propertyType, Object value) {
        if (propertyType.equals(String.class)) {
            return value.toString();
        }
        if (propertyType.equals(Boolean.class) || propertyType.equals(Boolean.TYPE)) {
            Boolean arg = null;
            arg = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
            return arg;
        }
        if (propertyType.equals(Short.class) || propertyType.equals(Short.TYPE)) {
            Short arg = null;
            arg = value instanceof Short ? (Short)value : Short.valueOf(Short.parseShort(value.toString()));
            return arg;
        }
        if (propertyType.equals(Integer.class) || propertyType.equals(Integer.TYPE)) {
            Integer arg = null;
            arg = value instanceof Integer ? (Integer)value : Integer.valueOf(Integer.parseInt(value.toString()));
            return arg;
        }
        if (propertyType.equals(Long.class) || propertyType.equals(Long.TYPE)) {
            Long arg = null;
            arg = value instanceof Long ? (Long)value : Long.valueOf(Long.parseLong(value.toString()));
            return arg;
        }
        if (propertyType.equals(Float.class) || propertyType.equals(Float.TYPE)) {
            Float arg = null;
            arg = value instanceof Float ? (Float)value : Float.valueOf(Float.parseFloat(value.toString()));
            return arg;
        }
        if (propertyType.equals(Double.class) || propertyType.equals(Double.TYPE)) {
            Double arg = null;
            arg = value instanceof Double ? (Double)value : Double.valueOf(Double.parseDouble(value.toString()));
            return arg;
        }
        return value;
    }
}

