/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.UIManager;
import ngmf.ui.PEditor;
import ngmf.util.OutputStragegy;
import oms3.ComponentAccess;
import oms3.ComponentException;
import oms3.dsl.Buildable;
import oms3.dsl.Exec;
import oms3.dsl.Model;
import oms3.dsl.Output;
import oms3.dsl.OutputDescriptor;
import oms3.dsl.Params;
import oms3.dsl.Resource;
import oms3.dsl.analysis.Chart;
import oms3.io.CSProperties;
import oms3.io.DataIO;

public abstract class AbstractSimulation
implements Buildable {
    protected static final Logger log = Logger.getLogger("oms3.sim");
    Model model;
    String name;
    Resource res = new Resource();
    OutputDescriptor output = new OutputDescriptor();
    List<Output> out = new ArrayList<Output>();
    Chart analysis;
    Exec build;

    public void setName(String name) {
        this.name = name;
    }

    protected String getName() {
        return this.name == null ? this.getClass().getSimpleName() : this.name;
    }

    public Model getModel() {
        return this.model;
    }

    protected OutputDescriptor getOutput() {
        return this.output;
    }

    protected List<Output> getOut() {
        return this.out;
    }

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("model")) {
            if (this.model != null) {
                throw new ComponentException("Only one 'model' element allowed.");
            }
            this.model = new Model();
            this.model.setRes(this.res);
            return this.model;
        }
        if (name.equals("resource")) {
            this.res.addResource(value);
            return LEAF;
        }
        if (name.equals("output")) {
            Output e = new Output();
            this.out.add(e);
            return e;
        }
        if (name.equals("analysis")) {
            this.analysis = new Chart();
            return this.analysis;
        }
        if (name.equals("outputstrategy")) {
            return this.output;
        }
        if (name.equals("build")) {
            File buildFile = new File(System.getProperty("oms.prj") + File.separatorChar + "build.xml");
            if (!buildFile.exists()) {
                throw new ComponentException("No build file found: " + buildFile);
            }
            this.build = new Exec(Exec.Type.ANT);
            this.build.setFile(buildFile.getAbsolutePath());
            return this.build;
        }
        throw new ComponentException("Unknown element '" + name.toString() + "'");
    }

    static void nativeLF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            String osName = System.getProperty("os.name");
            if (osName != null && osName.toLowerCase().startsWith("lin")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
        }
        catch (Exception E) {
            log.warning("Cannot set native L&F.");
        }
    }

    public Object run() throws Exception {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void graph() throws Exception {
        if (this.analysis == null) {
            throw new ComponentException("No analysis element defined.");
        }
        OutputStragegy st = this.getOutput().getOutputStrategy(this.getName());
        AbstractSimulation.nativeLF();
        this.analysis.run(st, this.getName());
    }

    public void doc() throws Exception {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void dig() throws Exception {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void edit() throws Exception {
        File f;
        ArrayList<File> l = new ArrayList<File>();
        for (Params params : this.model.getParams()) {
            if (params.getFile() == null) continue;
            l.add(new File(params.getFile()));
        }
        if (l.isEmpty()) {
            throw new ComponentException("No parameter files to edit.");
        }
        if (l.size() == 1 && !(f = (File)l.get(0)).exists()) {
            CSProperties cSProperties = DataIO.properties(ComponentAccess.createDefault(this.model.getComponent()));
            DataIO.save(cSProperties, f, "Parameter");
        }
        AbstractSimulation.nativeLF();
        PEditor p = new PEditor(l);
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/ngmf/ui/table.png"));
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        f2.getContentPane().add(p);
        f2.setIconImage(image);
        f2.setTitle("Parameter " + this.getName());
        f2.setSize(800, 600);
        f2.setLocation(500, 200);
        f2.setVisible(true);
        f2.toFront();
        System.out.flush();
    }

    public void build() throws Exception {
        if (this.build != null) {
            this.build.run();
        } else {
            System.err.println("  No build file to run.");
        }
    }

    public void output() throws Exception {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
            OutputStragegy st = this.output.getOutputStrategy(this.getName());
            File lastFolder = st.lastOutputFolder();
            if (lastFolder.exists()) {
                desktop.open(lastFolder);
            } else {
                log.warning("Folder does not exist (yet): " + lastFolder);
            }
        }
    }
}

