/*
 * Decompiled with CFR 0.152.
 */
package oms3.compiler;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemorySourceJavaFileObject
extends SimpleJavaFileObject {
    String code;

    public MemorySourceJavaFileObject(String name, String code) {
        super(MemorySourceJavaFileObject.createUriFromName(name), JavaFileObject.Kind.SOURCE);
        if (code == null) {
            throw new NullPointerException("code");
        }
        this.code = code;
    }

    private static URI createUriFromName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid name: " + name, e);
        }
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncErrors) throws IOException {
        return this.code;
    }
}

