/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ngmf.ui.Convert;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Description;

public class SimUtils {
    private static Map<Class, String> types = new HashMap<Class, String>(){
        {
            this.put(Calendar.class, "JAMSCalendar");
            this.put(Double.TYPE, "JAMSDouble");
            this.put(Integer.TYPE, "JAMSInteger");
            this.put(Boolean.TYPE, "JAMSBoolean");
            this.put(Float.TYPE, "JAMSFloat");
            this.put(Long.TYPE, "JAMSLong");
            this.put(String.class, "JAMSString");
            this.put(double[].class, "JAMSDoubleArray");
            this.put(int[].class, "JAMSIntegerArray");
            this.put(boolean[].class, "JAMSBooleanArray");
            this.put(float[].class, "JAMSFloatArray");
            this.put(long[].class, "JAMSLongArray");
            this.put(String[].class, "JAMSStringArray");
        }
    };

    private SimUtils() {
    }

    public static void jams_wrap(List<String> jars, String srcPath, List<String> className) throws Exception {
        if (jars == null || jars.size() == 0) {
            throw new RuntimeException("No jar files!");
        }
        if (srcPath == null) {
            throw new RuntimeException("No src path!");
        }
        if (className == null || className.size() == 0) {
            throw new RuntimeException("No components to convert!");
        }
        URL[] u = new URL[jars.size()];
        for (int i = 0; i < jars.size(); ++i) {
            if (!new File(jars.get(i)).exists()) {
                throw new RuntimeException("Not found:" + jars.get(i));
            }
            u[i] = new File(jars.get(i)).toURI().toURL();
        }
        URLClassLoader cl = new URLClassLoader(u, Thread.currentThread().getContextClassLoader());
        for (String cn : className) {
            Class<?> c = Class.forName(cn, true, cl);
            Object o = c.newInstance();
            String jamsClass = SimUtils.doit(o);
            String name = "JAMS" + c.getSimpleName();
            String pack = c.getPackage().getName().replace('.', '/');
            String file = srcPath + File.separator + pack + File.separator + name + ".java";
            File f = new File(file);
            f.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(f);
            pw.println(jamsClass);
            pw.close();
            System.out.println("  Created '" + f + "' for " + c.getName());
        }
    }

    private static String doit(Object oms3) {
        StringBuffer b = new StringBuffer();
        Class<?> cl = oms3.getClass();
        ComponentAccess a = new ComponentAccess(oms3);
        b.append("package " + cl.getPackage().getName() + ";\n");
        b.append("\n");
        b.append("import jams.data.*;\n");
        b.append("import jams.model.*;\n");
        b.append("\n");
        b.append("@JAMSComponentDescription(title = \"" + cl.getName() + "\", \n");
        b.append("                    description = \"\",\n");
        b.append("                    author = \"\")\n");
        b.append("public class JAMS" + cl.getSimpleName() + " extends JAMSComponent {\n");
        b.append("\n");
        b.append("    private " + cl.getName() + " oms3 = new " + cl.getName() + "();\n");
        b.append("\n");
        b.append("//Read access variables\n");
        for (Access acc : a.inputs()) {
            b.append("    @JAMSVarDescription(access = JAMSVarDescription.AccessType.READ,\n");
            b.append("       update = JAMSVarDescription.UpdateType.RUN,\n");
            b.append("       description = \"" + acc.getField().getAnnotation(Description.class).value() + "\")\n");
            b.append("    public " + types.get(acc.getField().getType()) + " " + acc.getField().getName() + ";\n");
            b.append("\n");
        }
        b.append("\n");
        b.append("//Write Access variables\n");
        for (Access acc : a.outputs()) {
            b.append("    @JAMSVarDescription(access = JAMSVarDescription.AccessType.WRITE,\n");
            b.append("       update = JAMSVarDescription.UpdateType.RUN,\n");
            b.append("       description = \"" + acc.getField().getAnnotation(Description.class).value() + "\")\n");
            b.append("    public " + types.get(acc.getField().getType()) + " " + acc.getField().getName() + ";\n");
            b.append("\n");
        }
        b.append("\n");
        b.append("    public void run() throws JAMSEntity.NoSuchAttributeException {\n");
        b.append("        // passing reads into in's\n");
        for (Access acc : a.inputs()) {
            b.append("        oms3." + acc.getField().getName() + " = " + acc.getField().getName() + ".getValue();\n");
        }
        b.append("\n");
        b.append("        // calling the oms3 execute\n");
        b.append("        oms3.execute();\n");
        b.append("\n");
        b.append("        // reading the outs\n");
        for (Access acc : a.outputs()) {
            b.append("        " + acc.getField().getName() + ".setValue(oms3." + acc.getField().getName() + ");\n");
        }
        b.append("    }\n");
        b.append("}\n");
        return b.toString();
    }

    public static void mms_convert(List<String> files) {
        for (String s : files) {
            String res = s.endsWith("statvar") ? Convert.statvar(s) : (s.endsWith("params") ? Convert.param(s) : (s.endsWith("data") ? Convert.data(s) : "Error: Cannot handle " + s + "\n"));
            System.out.print(res);
        }
    }
}

