/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.Access;
import oms3.AsyncFieldAccess;
import oms3.ComponentAccess;
import oms3.ComponentException;
import oms3.Conversions;
import oms3.FieldAccess;
import oms3.FieldContent;
import oms3.FieldObjectAccess;
import oms3.FieldValueAccess;
import oms3.Notification;
import oms3.util.Threads;

class Controller {
    static boolean checkCircular = Boolean.getBoolean("oms.check.circular");
    private static final Logger log = Logger.getLogger("oms3.sim");
    Notification ens = new Notification(this);
    Set<FieldContent> dataSet = new LinkedHashSet<FieldContent>();
    Map<Object, ComponentAccess> oMap = new LinkedHashMap<Object, ComponentAccess>(32);
    ComponentAccess ca;
    Validator validator;
    ComponentException E;
    static ExecutorService executor = Executors.newCachedThreadPool();
    Latch latch = new Latch();
    Runnable[] rc;
    final Object l = new Object();

    Controller(Object compound) {
        if (checkCircular) {
            this.validator = new Validator();
        }
        this.ca = new ComponentAccess(compound, this.ens);
    }

    ComponentAccess lookup(Object cmd) {
        if (cmd == null) {
            throw new ComponentException("null component.");
        }
        if (cmd == this.ca.getComponent()) {
            throw new ComponentException("Cannot add the compound to itself " + cmd.toString());
        }
        ComponentAccess w = this.oMap.get(cmd);
        if (w == null) {
            w = new ComponentAccess(cmd, this.ens);
            this.oMap.put(cmd, w);
        }
        return w;
    }

    Notification getNotification() {
        return this.ens;
    }

    void mapOut(String out, Object comp, String comp_out) {
        if (comp == this.ca.getComponent()) {
            throw new ComponentException("cannot connect 'Out' with itself for " + out);
        }
        ComponentAccess ac_dest = this.lookup(comp);
        FieldAccess destAccess = (FieldAccess)ac_dest.output(comp_out);
        FieldAccess srcAccess = (FieldAccess)this.ca.output(out);
        Controller.checkFA(destAccess, comp, comp_out);
        Controller.checkFA(srcAccess, this.ca.getComponent(), out);
        FieldContent data = srcAccess.getData();
        data.tagLeaf();
        data.tagOut();
        destAccess.setData(data);
        this.dataSet.add(data);
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, String.format("@Out(%s) -> @Out(%s)", srcAccess, destAccess));
        }
    }

    void mapIn(String in, Object comp, String comp_in) {
        if (comp == this.ca.getComponent()) {
            throw new ComponentException("cannot connect 'In' with itself for " + in);
        }
        ComponentAccess ac_dest = this.lookup(comp);
        FieldAccess destAccess = (FieldAccess)ac_dest.input(comp_in);
        Controller.checkFA(destAccess, comp, comp_in);
        FieldAccess srcAccess = (FieldAccess)this.ca.input(in);
        Controller.checkFA(srcAccess, this.ca.getComponent(), in);
        FieldContent data = srcAccess.getData();
        data.tagLeaf();
        data.tagIn();
        destAccess.setData(data);
        this.dataSet.add(data);
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("@In(%s) -> @In(%s)", srcAccess, destAccess));
        }
    }

    void mapInVal(Object val, Object to, String to_in) {
        if (val == null) {
            throw new ComponentException("Null value for " + Controller.name(to, to_in));
        }
        if (to == this.ca.getComponent()) {
            throw new ComponentException("field and component ar ethe same for mapping :" + to_in);
        }
        ComponentAccess ca_to = this.lookup(to);
        Access to_access = ca_to.input(to_in);
        Controller.checkFA(to_access, to, to_in);
        ca_to.setInput(to_in, new FieldValueAccess(to_access, val));
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("Value(%s) -> @In(%s)", val.toString(), to_access.toString()));
        }
    }

    void mapInField(Object from, String from_field, Object to, String to_in) {
        if (to == this.ca.getComponent()) {
            throw new ComponentException("wrong connect:" + from_field);
        }
        ComponentAccess ca_to = this.lookup(to);
        Access to_access = ca_to.input(to_in);
        Controller.checkFA(to_access, to, to_in);
        try {
            FieldContent.FA f = new FieldContent.FA(from, from_field);
            ca_to.setInput(to_in, new FieldObjectAccess(to_access, f, this.ens));
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.format("Field(%s) -> @In(%s)", f.toString(), to_access.toString()));
            }
        }
        catch (Exception E) {
            throw new ComponentException("No such field '" + from.getClass().getCanonicalName() + "." + from_field + "'");
        }
    }

    void mapOutField(Object from, String from_out, Object to, String to_field) {
        if (from == this.ca.getComponent()) {
            throw new ComponentException("wrong connect:" + to_field);
        }
        ComponentAccess ca_from = this.lookup(from);
        Access from_access = ca_from.output(from_out);
        Controller.checkFA(from_access, from, from_out);
        try {
            FieldContent.FA f = new FieldContent.FA(to, to_field);
            ca_from.setOutput(from_out, new FieldObjectAccess(from_access, f, this.ens));
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.format("@Out(%s) -> field(%s)", from_access, f.toString()));
            }
        }
        catch (Exception E) {
            throw new ComponentException("No such field '" + to.getClass().getCanonicalName() + "." + to_field + "'");
        }
    }

    void connect(Object from, String from_out, Object to, String to_in) {
        if (from == to) {
            throw new ComponentException("src == dest.");
        }
        if (to_in == null || from_out == null) {
            throw new ComponentException("Some field arguments are null");
        }
        ComponentAccess ca_from = this.lookup(from);
        ComponentAccess ca_to = this.lookup(to);
        Access from_access = ca_from.output(from_out);
        Controller.checkFA(from_access, from, from_out);
        Access to_access = ca_to.input(to_in);
        Controller.checkFA(to_access, to, to_in);
        if (!Controller.canConnect(from_access, to_access)) {
            throw new ComponentException("Type/Access mismatch, Cannot connect: " + from + '.' + to_in + " -> " + to + '.' + from_out);
        }
        FieldContent data = from_access.getData();
        data.tagIn();
        data.tagOut();
        this.dataSet.add(data);
        to_access.setData(data);
        if (checkCircular) {
            this.validator.addConnection(from, to);
            this.validator.checkCircular();
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("@Out(%s) -> @In(%s)", from_access.toString(), to_access.toString()));
        }
    }

    void feedback(Object from, String from_out, Object to, String to_in) {
        if (from == to) {
            throw new ComponentException("src == dest.");
        }
        if (to_in == null || from_out == null) {
            throw new ComponentException("Some field arguments are null");
        }
        ComponentAccess ca_from = this.lookup(from);
        ComponentAccess ca_to = this.lookup(to);
        Access from_access = ca_from.output(from_out);
        Controller.checkFA(from_access, from, from_out);
        Access to_access = ca_to.input(to_in);
        Controller.checkFA(to_access, to, to_in);
        if (!Controller.canConnect(from_access, to_access)) {
            throw new ComponentException("Type/Access mismatch, Cannot connect: " + from + '.' + to_in + " -> " + to + '.' + from_out);
        }
        FieldContent data = from_access.getData();
        data.tagIn();
        data.tagOut();
        to_access.setData(data);
        ca_from.setOutput(from_out, new AsyncFieldAccess(from_access));
        ca_to.setInput(to_in, new AsyncFieldAccess(to_access));
        if (checkCircular) {
            // empty if block
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.format("feedback @Out(%s) -> @In(%s)", from_access.toString(), to_access.toString()));
        }
    }

    private static String name(Object o, String field) {
        return o.toString() + "@" + field;
    }

    private static boolean canConnect(Access me, Access other) {
        if (other.getField().getType().isAssignableFrom(me.getField().getType())) {
            return true;
        }
        return Conversions.canConvert(me.getField().getType(), other.getField().getType());
    }

    private static void checkFA(Object fa, Object o, String field) {
        if (fa == null) {
            throw new ComponentException("No such field '" + o.getClass().getCanonicalName() + "." + field + "'");
        }
    }

    void sanityCheck() {
        if (checkCircular) {
            this.validator.checkOutFieldAccess();
        }
    }

    static void reload() {
        executor = Executors.newCachedThreadPool();
        Threads.e = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
    }

    public static void shutdown() {
        executor.shutdown();
        Threads.e.shutdown();
    }

    protected void internalExec() throws ComponentException {
        Collection<ComponentAccess> comps = this.oMap.values();
        if (comps.isEmpty()) {
            return;
        }
        try {
            for (Access a : this.ca.inputs()) {
                a.out();
            }
        }
        catch (Exception Ex) {
            throw new ComponentException(Ex, this.ca.getComponent());
        }
        for (FieldContent dataRef : this.dataSet) {
            dataRef.invalidate();
        }
        this.latch.reload(comps.size());
        this.ens.fireStart(this.ca);
        if (this.rc == null) {
            this.rc = new Runnable[comps.size()];
            int i = 0;
            for (final ComponentAccess co : comps) {
                this.rc[i++] = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            co.exec();
                            Controller.this.latch.countDown();
                        }
                        catch (ComponentException ce) {
                            Object object = Controller.this.l;
                            synchronized (object) {
                                if (Controller.this.E == null) {
                                    Controller.this.E = ce;
                                }
                            }
                            Controller.this.latch.open();
                            executor.shutdownNow();
                        }
                    }
                };
            }
        }
        for (Runnable r : this.rc) {
            if (this.E != null) break;
            executor.execute(r);
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException IE) {
            // empty catch block
        }
        if (this.E != null) {
            this.ens.fireException(this.E);
            throw this.E;
        }
        try {
            this.ens.fireFinnish(this.ca);
            for (Access a : this.ca.outputs()) {
                a.in();
            }
        }
        catch (Exception Ex) {
            throw new ComponentException(Ex, this.ca.getComponent());
        }
    }

    void callAnnotated(Class<? extends Annotation> ann, boolean lazy) {
        for (ComponentAccess p : this.oMap.values()) {
            p.callAnnotatedMethod(ann, lazy);
        }
    }

    private class Validator {
        Map<Object, List<Object>> graph = new HashMap<Object, List<Object>>();

        private Validator() {
        }

        void addConnection(Object from, Object to) {
            List<Object> tos = this.graph.get(from);
            if (tos == null) {
                tos = new ArrayList<Object>();
                this.graph.put(from, tos);
            }
            tos.add(to);
        }

        private void check(Object probe, Object current) {
            List<Object> nl = this.graph.get(current);
            if (nl == null) {
                return;
            }
            for (Object o : nl) {
                if (o == probe) {
                    throw new ComponentException("Circular reference to: " + probe);
                }
                this.check(probe, o);
            }
        }

        void checkCircular() {
            if (this.graph.isEmpty()) {
                return;
            }
            for (Object probe : this.graph.keySet()) {
                this.check(probe, probe);
            }
        }

        void checkInFieldAccess() {
            for (Access in : Controller.this.ca.inputs()) {
                if (in.getData().isValid()) continue;
                throw new ComponentException("Invalid Access " + in + " -> " + in.getData().access());
            }
            for (ComponentAccess w : Controller.this.oMap.values()) {
                for (Access in : w.inputs()) {
                    if (!in.isValid()) {
                        throw new ComponentException("Missing Connect for: " + in);
                    }
                    if (in.getData().isValid()) continue;
                    throw new ComponentException("Invalid Access " + in + " -> " + in.getData().access());
                }
            }
        }

        void checkOutFieldAccess() {
            if (log.isLoggable(Level.WARNING)) {
                for (ComponentAccess w : Controller.this.oMap.values()) {
                    for (Access out : w.outputs()) {
                        if (out.isValid()) continue;
                        log.warning("Empty @Out connect for: " + out);
                    }
                }
            }
        }
    }

    private static class Latch {
        private int count;
        final Object lock = new Object();

        private Latch() {
        }

        void reload(int count) {
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open() {
            Object object = this.lock;
            synchronized (object) {
                this.count = 0;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void countDown() {
            Object object = this.lock;
            synchronized (object) {
                if (--this.count <= 0) {
                    this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void await() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (this.count > 0) {
                    this.lock.wait();
                }
            }
        }
    }
}

