/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu.luca;

public class ParameterData {
    public static final int MEAN = 1;
    public static final int INDIVIDUAL = 2;
    public static final int BINARY = 3;
    private int calibrationType = 1;
    String name;
    double[] data;
    double lowerBound;
    double upperBound;
    double originalLowerBound;
    double originalUpperBound;
    boolean hasBounds = false;
    double min;
    double max;
    double offset;
    double[] proportional_dev = null;
    boolean[] calibrationFlag;
    int calibrationDataSize;
    double mean;

    public ParameterData(String paramName) {
        this.name = paramName;
    }

    public ParameterData(ParameterData pdata) {
        int i;
        this.name = pdata.getName();
        this.data = new double[pdata.getDataSize()];
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = pdata.getDataValueAt(i);
        }
        this.calibrationFlag = new boolean[pdata.getDataSize()];
        for (i = 0; i < this.calibrationFlag.length; ++i) {
            this.calibrationFlag[i] = pdata.getCalibrationFlag()[i];
        }
        this.set(this.data, pdata.getOriginalLowerBound(), pdata.getOriginalUpperBound(), pdata.getCalibrationType(), this.calibrationFlag);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasBounds() {
        return this.hasBounds;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getOriginalLowerBound() {
        return this.originalLowerBound;
    }

    public void setOriginalLowerBound(double lowerBound) {
        this.originalLowerBound = lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double getOriginalUpperBound() {
        return this.originalUpperBound;
    }

    public void setOriginalUpperBound(double upperBound) {
        this.originalUpperBound = upperBound;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double[] getDataValue() {
        return this.data;
    }

    public double getDataValueAt(int index) {
        return this.data[index];
    }

    public void setDataValue(double[] data) {
        this.data = data;
    }

    public int getDataSize() {
        return this.data.length;
    }

    public int getCalibrationType() {
        return this.calibrationType;
    }

    public void setCalibrationType(int calibrationType) {
        this.calibrationType = calibrationType;
    }

    public int getCalibrationDataSize() {
        if (this.calibrationType == 1) {
            return 1;
        }
        return this.calibrationDataSize;
    }

    public boolean needCalibrationAt(int index) {
        return this.calibrationFlag[index];
    }

    public boolean[] getCalibrationFlag() {
        return this.calibrationFlag;
    }

    public void setCalibrationFlag(boolean[] calibrate) {
        this.calibrationFlag = calibrate;
        for (int i = 0; i < this.calibrationFlag.length; ++i) {
            if (!calibrate[i]) continue;
            ++this.calibrationDataSize;
        }
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public boolean hasMinAndMax() {
        return this.calibrationType == 1 || this.calibrationDataSize > 0;
    }

    public void removeBounds() {
        this.hasBounds = false;
    }

    public void setStat(double[] dataValue, int calibrationType, boolean[] calibrate) {
        this.data = dataValue;
        this.calibrationType = calibrationType;
        this.calibrationFlag = calibrate;
        this.calibrationDataSize = 0;
        for (int i = 0; i < this.calibrationFlag.length; ++i) {
            if (!calibrate[i]) continue;
            ++this.calibrationDataSize;
        }
        this.calculateMean();
        this.findMin();
        this.findMax();
    }

    public void set(double[] dataValue, double lowerBound, double upperBound, int calibrationType, boolean[] needCalibration) {
        this.setStat(dataValue, calibrationType, needCalibration);
        this.setLowerAndUpperBounds(lowerBound, upperBound);
    }

    public void setLowerAndUpperBounds(double lower, double upper) {
        if (this.data == null) {
            return;
        }
        this.originalLowerBound = lower;
        this.originalUpperBound = upper;
        this.offset = this.originalLowerBound < this.min ? Math.abs(this.originalLowerBound) + 10.0 : Math.abs(this.min) + 10.0;
        if (this.calibrationType == 1) {
            this.lowerBound = (this.originalLowerBound + this.offset) * (this.mean + this.offset) / (this.min + this.offset) - this.offset;
            this.upperBound = (this.originalUpperBound + this.offset) * (this.mean + this.offset) / (this.max + this.offset) - this.offset;
        } else {
            this.lowerBound = this.originalLowerBound;
            this.upperBound = this.originalUpperBound;
        }
        this.hasBounds = true;
        this.setDeviation();
    }

    private void setDeviation() {
        this.proportional_dev = new double[this.data.length];
        for (int i = 0; i < this.proportional_dev.length; ++i) {
            this.proportional_dev[i] = (this.data[i] + this.offset) / (this.mean + this.offset);
        }
    }

    private void calculateMean() {
        double sum = 0.0;
        Integer count = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.calibrationFlag[i]) continue;
            sum += this.data[i];
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.mean = sum / count.doubleValue();
    }

    private void findMax() {
        if (this.calibrationDataSize > 0) {
            int index = 0;
            while (!this.calibrationFlag[index]) {
                ++index;
            }
            this.max = this.data[index];
            for (int i = ++index; i < this.data.length; ++i) {
                if (!this.calibrationFlag[i] || !(this.data[i] > this.max)) continue;
                this.max = this.data[i];
            }
        }
    }

    private void findMin() {
        if (this.calibrationDataSize > 0) {
            int index = 0;
            while (!this.calibrationFlag[index]) {
                ++index;
            }
            this.min = this.data[index];
            for (int i = ++index; i < this.data.length; ++i) {
                if (!this.calibrationFlag[i] || !(this.data[i] < this.min)) continue;
                this.min = this.data[i];
            }
        }
    }

    public double[] getCalibrationData() {
        if (this.calibrationType == 1) {
            double[] meanArray = new double[]{this.mean};
            return meanArray;
        }
        double[] calibrationData = new double[this.calibrationDataSize];
        int index = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.calibrationFlag[i]) continue;
            calibrationData[index] = this.data[i];
            ++index;
        }
        return calibrationData;
    }

    public void generateValues(double newMean) {
        double meanWithOffset = newMean + this.offset;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = meanWithOffset * this.proportional_dev[i] - this.offset;
        }
        this.mean = newMean;
    }

    public void generateValues(double[] values) {
        if (this.calibrationType == 1) {
            this.generateValues(values[0]);
        } else if (this.calibrationType == 2) {
            int index = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if (!this.calibrationFlag[i]) continue;
                this.data[i] = values[index];
                ++index;
            }
            this.calculateMean();
        } else {
            int index = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if (!this.calibrationFlag[i]) continue;
                this.data[i] = values[index] < 0.5 ? 0.0 : 1.0;
                ++index;
            }
            this.calculateMean();
        }
    }
}

