/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.Vector;
import ngmf.util.cosu.Efficiencies;

public class SCE {
    public String parameterIDs;
    public String boundaries;
    public String effMethodName;
    public double[] prediction;
    public double[] observation;
    public int MaximizeEff;
    public int NumberOfComplexes;
    public int maxn;
    public int kstop;
    public double pcento;
    public double peps;
    public boolean enable;
    public String sceFileName;
    double[] parameters;
    String[] parameterNames;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator = new Random();
    PrintWriter writer;
    int N;
    int p;
    int s;
    int m;
    int icall = 0;

    public void init() {
    }

    public double custom_rand() {
        return this.generator.nextDouble();
    }

    private double[] randomSampler() {
        int paras = this.parameterNames.length;
        double[] sample = new double[paras];
        for (int i = 0; i < paras; ++i) {
            double d = this.custom_rand();
            sample[i] = this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    private boolean IsSampleValid(double[] sample) {
        int paras = this.parameterNames.length;
        for (int i = 0; i < paras; ++i) {
            if (!(sample[i] < this.lowBound[i]) && !(sample[i] > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    public double funct(double[] x) {
        for (int j = 0; j < this.parameters.length; ++j) {
            this.parameters[j] = x[j];
        }
        ++this.currentCount;
        double[] preArr = this.prediction;
        double[] obsArr = this.observation;
        Vector<Double> obsVector = new Vector<Double>();
        Vector<Double> preVector = new Vector<Double>();
        for (int i = 0; i < preArr.length; ++i) {
            if (!(preArr[i] > -9999.0) || !(obsArr[i] > -9999.0)) continue;
            obsVector.add(obsArr[i]);
            preVector.add(preArr[i]);
        }
        int dataCount = obsVector.size();
        obsArr = new double[dataCount];
        preArr = new double[dataCount];
        for (int i = 0; i < dataCount; ++i) {
            obsArr[i] = (Double)obsVector.get(i);
            preArr[i] = (Double)preVector.get(i);
        }
        if (this.effMethodName.equals("e2")) {
            return -1.0 * Efficiencies.nashSutcliffe(preArr, obsArr, 2.0);
        }
        if (this.effMethodName.equals("e1")) {
            return -1.0 * Efficiencies.nashSutcliffe(preArr, obsArr, 1.0);
        }
        if (this.effMethodName.equals("le2")) {
            return -1.0 * Efficiencies.nashSutcliffeLog(obsArr, preArr, 2.0);
        }
        if (this.effMethodName.equals("pbias")) {
            return Math.abs(Efficiencies.pbias(obsArr, preArr));
        }
        return -9999.0;
    }

    public void sort(double[][] x, double[] xf) {
        if (x.length == 0) {
            return;
        }
        int n = x[0].length;
        double[][] t = new double[x.length][n + 1];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < n; ++j) {
                t[i][j] = x[i][j];
            }
            t[i][n] = xf[i];
        }
        SCE_Comparator comparator = new SCE_Comparator(n, false);
        Arrays.sort(t, comparator);
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < n; ++j) {
                x[i][j] = t[i][j];
            }
            xf[i] = t[i][n];
        }
    }

    public void sort(int[] x) {
        Arrays.sort(x);
    }

    public double normalizedgeometricRange(double[][] x, double[] bound) {
        if (x.length == 0) {
            return 0.0;
        }
        int n = x[0].length;
        double[] min = new double[n];
        double[] max = new double[n];
        double mean = 0.0;
        for (int i = 0; i < n; ++i) {
            min[i] = Double.POSITIVE_INFINITY;
            max[i] = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < x.length; ++j) {
                if (x[j][i] < min[i]) {
                    min[i] = x[j][i];
                }
                if (!(x[j][i] > max[i])) continue;
                max[i] = x[j][i];
            }
            mean += Math.log(max[i] - min[i]) / bound[i];
        }
        return Math.exp(mean /= (double)n);
    }

    public double[] std(double[][] x) {
        int j;
        if (x.length <= 1) {
            return null;
        }
        int n = x[0].length;
        double[] mean = new double[n];
        double[] var = new double[n];
        int i = 0;
        while (i < n) {
            mean[i] = 0.0;
            for (j = 0; j < x.length; ++j) {
                int n2 = i;
                mean[n2] = mean[n2] + x[j][i];
            }
            int n3 = i++;
            mean[n3] = mean[n3] / (double)n;
        }
        for (i = 0; i < n; ++i) {
            var[i] = 0.0;
            for (j = 0; j < x.length; ++j) {
                int n4 = i;
                var[n4] = var[n4] + (mean[i] - x[j][i]) * (mean[i] - x[j][i]);
            }
            var[i] = Math.sqrt(var[i]) / (double)(n - 1);
        }
        return var;
    }

    public int find(int[] lcs, int startindex, int endindex, int value) {
        for (int i = startindex; i < endindex; ++i) {
            if (lcs[i] != value) continue;
            return i;
        }
        return -1;
    }

    public double[] cceua(double[][] s, double[] sf, double[] bl, double[] bu) {
        double fnew;
        int nps = s.length;
        int nopt = s[0].length;
        int n = nps;
        int m = nopt;
        double alpha = 1.0;
        double beta = 0.5;
        double[] sb = new double[nopt];
        double[] sw = new double[nopt];
        double fb = sf[0];
        double fw = sf[n - 1];
        for (int i = 0; i < nopt; ++i) {
            sb[i] = s[0][i];
            sw[i] = s[n - 1][i];
        }
        double[] ce = new double[nopt];
        int i = 0;
        while (i < nopt) {
            ce[i] = 0.0;
            for (int j = 0; j < n - 1; ++j) {
                int n2 = i;
                ce[n2] = ce[n2] + s[j][i];
            }
            int n3 = i++;
            ce[n3] = ce[n3] / (double)(n - 1);
        }
        double[] snew = new double[nopt];
        for (int i2 = 0; i2 < nopt; ++i2) {
            snew[i2] = ce[i2] + alpha * (ce[i2] - sw[i2]);
        }
        int ibound = 0;
        for (int i3 = 0; i3 < nopt; ++i3) {
            if (snew[i3] - bl[i3] < 0.0) {
                ibound = 1;
            }
            if (!(bu[i3] - snew[i3] < 0.0)) continue;
            ibound = 2;
        }
        if (ibound >= 1) {
            snew = this.randomSampler();
        }
        if ((fnew = this.funct(snew)) > fw) {
            for (int i4 = 0; i4 < nopt; ++i4) {
                snew[i4] = sw[i4] + beta * (ce[i4] - sw[i4]);
            }
            fnew = this.funct(snew);
        }
        if (fnew > fw) {
            snew = this.randomSampler();
            fnew = this.funct(snew);
        }
        double[] result = new double[nopt + 1];
        for (int i5 = 0; i5 < nopt; ++i5) {
            result[i5] = snew[i5];
        }
        result[nopt] = fnew;
        return result;
    }

    public double[] sceua(double[] x0, double[] bl, double[] bu, int maxn, int kstop, double pcento, double peps, int ngs, int iseed, int iniflg) {
        int i;
        int nopt = x0.length;
        int npg = 2 * nopt + 1;
        int nps = nopt + 1;
        int nspl = npg;
        int mings = ngs;
        int npt = npg * ngs;
        double[] bound = new double[nopt];
        for (int i2 = 0; i2 < nopt; ++i2) {
            bound[i2] = bu[i2] - bl[i2];
        }
        double[][] x = new double[npt][nopt];
        for (int i3 = 0; i3 < npt; ++i3) {
            x[i3] = this.randomSampler();
        }
        if (iniflg == 1) {
            x[0] = x0;
        }
        int nloop = 0;
        double[] xf = new double[npt];
        for (int i4 = 0; i4 < npt; ++i4) {
            xf[i4] = this.funct(x[i4]);
        }
        double f0 = xf[0];
        this.sort(x, xf);
        double[] bestx = new double[nopt];
        double[] worstx = new double[nopt];
        for (int i5 = 0; i5 < nopt; ++i5) {
            bestx[i5] = x[0][i5];
            worstx[i5] = x[npt - 1][i5];
        }
        double bestf = xf[0];
        double worstf = xf[npt - 1];
        double[] xnstd = this.std(x);
        double gnrng = this.normalizedgeometricRange(x, bound);
        System.out.println("The Inital Loop: 0");
        System.out.println("BestF: " + bestf);
        System.out.print("BestX");
        for (i = 0; i < nopt; ++i) {
            System.out.print("\t\t" + bestx[i]);
        }
        for (i = 0; i < nopt; ++i) {
        }
        System.out.println("");
        System.out.println("WorstF: " + worstf);
        System.out.print("WorstX");
        for (i = 0; i < nopt; ++i) {
            System.out.print("\t\t" + worstx[i]);
        }
        System.out.println("");
        if (this.icall >= maxn) {
            System.out.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
            System.out.println("ON THE MAXIMUM NUMBER OF TRIALS" + maxn);
            System.out.println("HAS BEEN EXCEEDED.  SEARCH WAS STOPPED AT TRIAL NUMBER:" + this.icall);
            System.out.println("OF THE INITIAL LOOP!");
            this.writer.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
            this.writer.println("ON THE MAXIMUM NUMBER OF TRIALS" + maxn);
            this.writer.println("HAS BEEN EXCEEDED.  SEARCH WAS STOPPED AT TRIAL NUMBER:" + this.icall);
            this.writer.println("OF THE INITIAL LOOP!");
            this.writer.flush();
        }
        if (gnrng < peps) {
            this.writer.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
            System.out.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
            this.writer.flush();
        }
        nloop = 0;
        double[] criter = new double[kstop];
        double criter_change = 100000.0;
        while (this.icall < maxn && gnrng > peps && criter_change > pcento) {
            int i6;
            ++nloop;
            for (int igs = 0; igs < ngs; ++igs) {
                int i7;
                int[] k1 = new int[npg];
                int[] k2 = new int[npg];
                for (int i8 = 0; i8 < npg; ++i8) {
                    k1[i8] = i8;
                    k2[i8] = k1[i8] * ngs + igs;
                }
                double[][] cx = new double[npg][nopt];
                double[] cf = new double[npg];
                for (i7 = 0; i7 < npg; ++i7) {
                    for (int j = 0; j < nopt; ++j) {
                        cx[k1[i7]][j] = x[k2[i7]][j];
                    }
                    cf[k1[i7]] = xf[k2[i7]];
                }
                for (int loop = 0; loop < nspl; ++loop) {
                    int i9;
                    int[] lcs = new int[nps];
                    lcs[0] = 0;
                    for (int k3 = 1; k3 < nps; ++k3) {
                        int idx;
                        int lpos = 0;
                        for (int iter = 0; iter < 1000 && (idx = this.find(lcs, 0, k3, lpos = (int)Math.floor((double)npg + 0.5 - Math.sqrt(((double)npg + 0.5) * ((double)npg + 0.5) - (double)(npg * (npg + 1)) * this.custom_rand())))) != -1; ++iter) {
                        }
                        lcs[k3] = lpos;
                    }
                    this.sort(lcs);
                    double[][] s = new double[nps][nopt];
                    double[] sf = new double[nps];
                    for (int i10 = 0; i10 < nps; ++i10) {
                        for (int j = 0; j < nopt; ++j) {
                            s[i10][j] = cx[lcs[i10]][j];
                        }
                        sf[i10] = cf[lcs[i10]];
                    }
                    double[] snew = new double[nopt];
                    double[] xnew = this.cceua(s, sf, bl, bu);
                    ++this.icall;
                    for (i9 = 0; i9 < nopt; ++i9) {
                        snew[i9] = xnew[i9];
                    }
                    double fnew = xnew[nopt];
                    s[nps - 1] = snew;
                    sf[nps - 1] = fnew;
                    for (i9 = 0; i9 < nps; ++i9) {
                        for (int j = 0; j < nopt; ++j) {
                            cx[lcs[i9]][j] = s[i9][j];
                        }
                        cf[lcs[i9]] = sf[i9];
                    }
                    this.sort(cx, cf);
                }
                for (i7 = 0; i7 < npg; ++i7) {
                    for (int j = 0; j < nopt; ++j) {
                        x[k2[i7]][j] = cx[k1[i7]][j];
                    }
                    xf[k2[i7]] = cf[k1[i7]];
                }
            }
            this.sort(x, xf);
            for (i6 = 0; i6 < nopt; ++i6) {
                bestx[i6] = x[0][i6];
                worstx[i6] = x[nopt - 1][i6];
            }
            bestf = xf[0];
            worstf = xf[npt - 1];
            xnstd = this.std(x);
            gnrng = this.normalizedgeometricRange(x, bound);
            System.out.println("Evolution Loop:" + nloop + " - Trial - " + this.icall);
            System.out.println("BESTF:" + bestf);
            System.out.print("BESTX:");
            for (i6 = 0; i6 < nopt; ++i6) {
                System.out.print("\t" + bestx[i6]);
            }
            for (i6 = 0; i6 < nopt; ++i6) {
            }
            System.out.println("\nWORSTF:" + worstf);
            System.out.print("WORSTX:");
            for (i6 = 0; i6 < nopt; ++i6) {
                System.out.print("\t" + worstx[i6]);
            }
            System.out.println("");
            if (this.icall >= maxn) {
                System.out.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
                System.out.println("ON THE MAXIMUM NUMBER OF TRIALS " + maxn + " HAS BEEN EXCEEDED!");
                this.writer.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
                this.writer.println("ON THE MAXIMUM NUMBER OF TRIALS " + maxn + " HAS BEEN EXCEEDED!");
                this.writer.flush();
            }
            if (gnrng < peps) {
                System.out.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                this.writer.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                this.writer.flush();
            }
            for (i6 = 0; i6 < kstop - 1; ++i6) {
                criter[i6] = criter[i6 + 1];
            }
            criter[kstop - 1] = bestf;
            if (nloop < kstop) continue;
            criter_change = Math.abs(criter[0] - criter[kstop - 1]) * 100.0;
            double criter_mean = 0.0;
            for (int i11 = 0; i11 < kstop; ++i11) {
                criter_mean += Math.abs(criter[i11]);
            }
            if (!((criter_change /= (criter_mean /= (double)kstop)) < pcento)) continue;
            System.out.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY");
            System.out.println("LESS THAN THE THRESHOLD " + pcento + "%");
            System.out.println("CONVERGENCY HAS ACHIEVED BASED ON OBJECTIVE FUNCTION CRITERIA!!!");
            this.writer.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY");
            this.writer.println("LESS THAN THE THRESHOLD " + pcento + "%");
            this.writer.println("CONVERGENCY HAS ACHIEVED BASED ON OBJECTIVE FUNCTION CRITERIA!!!");
            this.writer.flush();
        }
        System.out.println("SEARCH WAS STOPPED AT TRIAL NUMBER: " + this.icall);
        System.out.println("NORMALIZED GEOMETRIC RANGE = " + gnrng);
        System.out.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY " + criter_change + "%");
        this.writer.println("SEARCH WAS STOPPED AT TRIAL NUMBER: " + this.icall);
        this.writer.println("NORMALIZED GEOMETRIC RANGE = " + gnrng);
        this.writer.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY " + criter_change + "%");
        this.writer.flush();
        double[] retVal = new double[nopt + 1];
        for (int i12 = 0; i12 < nopt; ++i12) {
            retVal[i12] = bestx[i12];
        }
        retVal[nopt] = bestf;
        return retVal;
    }

    public void run() {
        this.maxn = 10000;
        this.kstop = 10;
        this.pcento = 0.01;
        this.peps = 1.0E-5;
        int iseed = 10;
        int iniflg = 0;
        System.out.println("Pcento: " + this.pcento);
        double[] x0 = this.randomSampler();
        double[] bestpoint = this.sceua(x0, this.lowBound, this.upBound, this.maxn, this.kstop, this.pcento, this.peps, this.NumberOfComplexes, iseed, iniflg);
        double[] bestx = new double[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            bestx[i] = bestpoint[i];
        }
        double bestf = bestpoint[this.parameters.length];
    }

    static class SCE_Comparator
    implements Comparator<double[]> {
        int col = 0;
        int order = 1;

        SCE_Comparator(int col, boolean decreasing_order) {
            this.col = col;
            this.order = decreasing_order ? -1 : 1;
        }

        @Override
        public int compare(double[] b1, double[] b2) {
            if (b1[this.col] < b2[this.col]) {
                return -1 * this.order;
            }
            if (b1[this.col] == b2[this.col]) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

