/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import ngmf.util.cosu.Sample;

public class NelderMead {
    Sample[] initialSimplex = null;
    int n;
    double[] lowBound;
    double[] upBound;
    double[] x0 = null;
    int mode;
    Random generator = new Random();
    int currentSampleCount;
    double effValue;
    int maxn;
    double[] parameters;

    void sort(Sample[] array) {
        Arrays.sort(array, new SampleComperator(false));
    }

    double normalizedgeometricRange(Sample[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double[] min = new double[this.n];
        double[] max = new double[this.n];
        double mean = 0.0;
        for (int i = 0; i < this.n; ++i) {
            min[i] = Double.POSITIVE_INFINITY;
            max[i] = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < x.length; ++j) {
                min[i] = Math.min(x[j].x[i], min[i]);
                max[i] = Math.max(x[j].x[i], max[i]);
            }
            mean += Math.log(max[i] - min[i]);
        }
        return Math.exp(mean / (double)this.n);
    }

    boolean feasible(double[] point) {
        for (int i = 0; i < point.length; ++i) {
            if (!(point[i] < this.lowBound[i]) && !(point[i] > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    Sample getSample(double[] x) {
        return new Sample(x, this.funct(x));
    }

    public double funct(double[] x) {
        for (int j = 0; j < this.parameters.length; ++j) {
            try {
                this.parameters[j] = x[j];
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error! Parameter No. " + j + " wasn^t found" + e.toString());
            }
        }
        double value = this.effValue;
        double bigNumber = 1.0E7;
        this.effValue = Math.max(this.effValue, -bigNumber);
        this.effValue = Math.min(this.effValue, bigNumber);
        if (Double.isNaN(this.effValue)) {
            this.effValue = -bigNumber;
        }
        ++this.currentSampleCount;
        switch (this.mode) {
            case 2: {
                return value;
            }
            case 1: {
                return -value;
            }
            case 4: {
                return Math.abs(value);
            }
            case 3: {
                return -Math.abs(value);
            }
        }
        return 0.0;
    }

    double[] randomSample() {
        double[] sample = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            sample[i] = this.lowBound[i] + this.generator.nextDouble() * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        simplex = new Sample[this.n + 1];
        if (this.initialSimplex != null) {
            simplex = this.initialSimplex;
        } else {
            for (i = 0; i < this.n + 1; ++i) {
                simplex[i] = i == 0 && this.x0 != null ? this.getSample(this.x0) : this.getSample(this.randomSample());
            }
        }
        m = simplex.length;
        alpha = 1.0;
        gamma = 2.0;
        rho = 0.5;
        sigma = 0.5;
        epsilon = 0.01;
        max_restart_count = 5.0;
        restart_counter = 0;
        iterationcounter = 0;
        block1: while (true) {
            if (iterationcounter++ > this.maxn) {
                System.out.println("*********************************************************");
                System.out.println("Maximum number of iterations reached, finished optimization");
                System.out.println("Bestpoint:" + simplex[0]);
                System.out.println("*********************************************************");
                return;
            }
            if (this.normalizedgeometricRange(simplex) < epsilon) {
                if (max_restart_count < (double)(++restart_counter)) {
                    System.out.println("*********************************************************");
                    System.out.println("Maximum number of restarts reached, finished optimization");
                    System.out.println("Bestpoint:" + simplex[0]);
                    System.out.println("*********************************************************");
                    return;
                }
                System.out.println("restart");
                for (i = 1; i < m; ++i) {
                    simplex[i] = this.getSample(this.randomSample());
                }
            }
            this.sort(simplex);
            centroid = new double[this.n];
            for (j = 0; j < this.n; ++j) {
                centroid[j] = 0.0;
                for (i = 0; i < m - 1; ++i) {
                    v0 = j;
                    centroid[v0] = centroid[v0] + simplex[i].x[j] * (1.0 / ((double)m - 1.0));
                }
            }
            reflection = new double[this.n];
            for (i = 0; i < this.n; ++i) {
                reflection[i] = centroid[i] + alpha * (centroid[i] - simplex[m - 1].x[i]);
            }
            reflection_sample = null;
            if (this.feasible(reflection)) {
                System.out.println("reflection step");
                reflection_sample = this.getSample(reflection);
                if (simplex[0].fx < reflection_sample.fx && reflection_sample.fx < simplex[m - 1].fx) {
                    simplex[m - 1] = reflection_sample;
                    continue;
                }
            }
            if (this.feasible(reflection) && simplex[0].fx >= reflection_sample.fx) {
                expansion = new double[this.n];
                for (i = 0; i < this.n; ++i) {
                    expansion[i] = centroid[i] + gamma * (centroid[i] - simplex[m - 1].x[i]);
                }
                System.out.println("expansion step");
                expansion_sample = this.getSample(expansion);
                if (this.feasible(expansion) && expansion_sample.fx < reflection_sample.fx) {
                    simplex[m - 1] = expansion_sample;
                    continue;
                }
                simplex[m - 1] = reflection_sample;
                continue;
            }
            if (!this.feasible(reflection) || simplex[m - 1].fx <= reflection_sample.fx) {
                contraction = new double[this.n];
                for (i = 0; i < this.n; ++i) {
                    contraction[i] = centroid[i] + rho * (centroid[i] - simplex[m - 1].x[i]);
                }
                System.out.println("contraction step");
                contraction_sample = null;
                if (!this.feasible(contraction)) {
                    System.out.println("not feasible after contraction step");
                    contraction_sample = this.getSample(this.randomSample());
                } else {
                    contraction_sample = this.getSample(contraction);
                }
                if (contraction_sample.fx < simplex[m - 1].fx) {
                    simplex[m - 1] = contraction_sample;
                    continue;
                }
            }
            i = 1;
            while (true) {
                if (i < m) ** break;
                continue block1;
                shrink = new double[this.n];
                for (j = 0; j < this.n; ++j) {
                    shrink[j] = simplex[0].x[j] + sigma * (simplex[i].x[j] - simplex[0].x[j]);
                }
                System.out.println("shrink step");
                simplex[i] = this.getSample(shrink);
                ++i;
            }
            break;
        }
    }

    static class SampleComperator
    implements Comparator<Sample> {
        private int order = 1;

        public SampleComperator(boolean decreasing_order) {
            this.order = decreasing_order ? -1 : 1;
        }

        @Override
        public int compare(Sample d1, Sample d2) {
            if (d1.fx < d2.fx) {
                return -1 * this.order;
            }
            if (d1.fx == d2.fx) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

