/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

class InputTransitions
extends Panel {
    private int dimension;
    private TextField[][] pIn;

    public InputTransitions(int dimension) {
        this.dimension = dimension;
        Panel matrixPanel = new Panel();
        this.pIn = new TextField[dimension][dimension];
        matrixPanel.setLayout(new GridLayout(dimension, dimension));
        for (int d1 = 0; d1 < dimension; ++d1) {
            for (int d2 = 0; d2 < dimension; ++d2) {
                this.pIn[d1][d2] = new TextField(10);
                matrixPanel.add(this.pIn[d1][d2]);
            }
        }
        this.setLayout(new BorderLayout(20, 20));
        this.add("North", new Label("Transition matrix"));
        this.add("Center", matrixPanel);
    }

    public InputTransitions(int dimension, double[][] P0) {
        this(dimension);
        for (int d1 = 0; d1 < dimension; ++d1) {
            for (int d2 = 0; d2 < dimension; ++d2) {
                this.pIn[d1][d2].setText(P0[d1][d2] + "");
            }
        }
    }

    public double[][] getP() {
        double[][] P = new double[this.dimension][this.dimension];
        for (int d1 = 0; d1 < this.dimension; ++d1) {
            for (int d2 = 0; d2 < this.dimension; ++d2) {
                P[d1][d2] = new Double(this.pIn[d1][d2].getText());
            }
        }
        double[] rowsum = new double[this.dimension];
        double[] colsum = new double[this.dimension];
        for (int d1 = 0; d1 < this.dimension; ++d1) {
            for (int d2 = 0; d2 < this.dimension; ++d2) {
                int n = d1;
                rowsum[n] = rowsum[n] + P[d1][d2];
                int n2 = d2;
                colsum[n2] = colsum[n2] + P[d1][d2];
            }
        }
        for (int d = 0; d < this.dimension; ++d) {
            if (!(Math.abs(rowsum[d] - 1.0) > 1.0E-10) && !(Math.abs(colsum[d] - 1.0) > 1.0E-10)) continue;
            return null;
        }
        return P;
    }

    public void setEditable(boolean editable) {
        for (int d1 = 0; d1 < this.dimension; ++d1) {
            for (int d2 = 0; d2 < this.dimension; ++d2) {
                this.pIn[d1][d2].setEditable(editable);
            }
        }
    }
}

