/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util.cosu;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

class GraphCanvas
extends Canvas {
    private int n;
    private double[] obs;
    private int age0;
    private int width;
    private int height;
    private double ymin;
    private double ymax;
    private double yscale;
    private double xscale;

    public GraphCanvas(int width, int height) {
        this.resize(width, height);
    }

    public void draw(double[] obs, int n, int age0) {
        this.obs = obs;
        this.n = n;
        this.age0 = age0;
        if (n > 0) {
            this.ymin = this.ymax = obs[0];
            for (int i = 1; i < n; ++i) {
                this.ymin = Math.min(this.ymin, obs[i]);
                this.ymax = Math.max(this.ymax, obs[i]);
            }
            if (this.ymax - this.ymin < 1.0E-10) {
                n = 0;
            }
        }
        this.repaint();
    }

    private int xcoord(int x) {
        return (int)((double)x * this.xscale);
    }

    private int ycoord(double y) {
        return (int)((double)(this.height - 15) - (y - this.ymin) * this.yscale);
    }

    @Override
    public void paint(Graphics g) {
        if (this.obs != null && this.n > 0) {
            int yc;
            int step;
            this.width = this.size().width;
            this.height = this.size().height;
            this.yscale = ((double)this.height - 25.0) / (this.ymax - this.ymin);
            this.xscale = (double)this.width / (double)(this.n + 2);
            g.clearRect(0, 0, this.width, this.height);
            g.setColor(Color.black);
            for (int i = 1; i < this.n; ++i) {
                g.drawLine(this.xcoord(i - 1), this.ycoord(this.obs[i - 1]), this.xcoord(i), this.ycoord(this.obs[i]));
            }
            g.setColor(Color.green);
            g.drawLine(0, this.ycoord(0.0), this.width, this.ycoord(0.0));
            int agen = this.age0 + this.n;
            for (step = 1; step < this.n / 20; step *= 10) {
            }
            for (int x = (this.age0 / step + 1) * step; x < agen; x += step) {
                yc = this.ycoord(0.0);
                if (yc < 0 || yc > this.height - 15) {
                    yc = this.height - 15;
                }
                int xc = this.xcoord(x - this.age0);
                g.drawLine(xc, yc - 10, xc, yc);
                g.drawString(x + "", xc - 10, yc + 10);
            }
            step = 1;
            while ((double)step < (this.ymax - this.ymin) / 20.0) {
                step *= 10;
            }
            int y = (int)(this.ymin / (double)step) * step;
            while ((double)y < this.ymax) {
                yc = this.ycoord(y);
                g.drawString(y + "", 5, yc + 5);
                y += step;
            }
        }
    }
}

