/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util;

import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import ngmf.util.OutputStragegy;

public class NumDirectoryOutput
extends OutputStragegy {
    private static DecimalFormat df = new DecimalFormat("0000");

    public NumDirectoryOutput(File base, String simName) {
        super(new File(base, simName));
    }

    @Override
    public File nextOutputFolder() {
        if (!this.basedir.exists()) {
            this.basedir.mkdirs();
        }
        File[] files = this.basedir.listFiles(new FF());
        int no = 0;
        if (files != null && files.length > 0) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return Integer.parseInt(o1.getName()) - Integer.parseInt(o2.getName());
                }
            });
            no = Integer.parseInt(files[files.length - 1].getName()) + 1;
        }
        String filename = df.format(no);
        File nextFolder = new File(this.basedir, filename);
        return nextFolder;
    }

    private static class FF
    implements FilenameFilter {
        private FF() {
        }

        @Override
        public boolean accept(File dir, String name) {
            try {
                Integer.parseInt(name);
                return true;
            }
            catch (NumberFormatException E) {
                return false;
            }
        }
    }
}

