/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ui.mms;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import ngmf.ui.mms.Dimension;
import ngmf.ui.mms.MmsDimension;
import ngmf.ui.mms.MmsParameter;
import ngmf.ui.mms.MmsParameterSet;
import ngmf.ui.mms.ParameterSet;

public class MmsParamsReader {
    private FileReader file;
    private Logger log;
    private String fileName;
    private ParameterSet mps;

    public MmsParamsReader(String fileName) throws IOException {
        this(new FileReader(fileName), Logger.getLogger(MmsParamsReader.class.getName()));
        this.fileName = fileName;
    }

    public MmsParamsReader(FileReader file) throws IOException {
        this(file, Logger.getLogger(MmsParamsReader.class.getName()));
    }

    public MmsParamsReader(FileReader file, Logger log) throws IOException {
        this.file = file;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterSet read() throws IOException {
        this.mps = new MmsParameterSet();
        this.mps.setFileName(this.fileName);
        BufferedReader in = null;
        try {
            in = new BufferedReader(this.file);
            this.mps.setDescription(in.readLine());
            this.mps.setVersion(in.readLine());
            String line = in.readLine();
            while (line != null && !line.equals("** Parameters **")) {
                if (line.startsWith("<history")) {
                    this.mps.addHistory(line);
                    line = in.readLine();
                    continue;
                }
                if (line.startsWith("####")) {
                    String name = line = in.readLine();
                    int size = Integer.valueOf(in.readLine());
                    MmsDimension dim = new MmsDimension(name, size);
                    this.mps.addDimension(dim);
                    line = in.readLine();
                    int i = 0;
                    while (!line.startsWith("####") && !line.startsWith("** Parameters **")) {
                        if (line.startsWith("@")) {
                            dim.addItemDesc(i - 1, line, size);
                        } else {
                            dim.addItemName(i, line, size);
                            ++i;
                        }
                        line = in.readLine();
                    }
                    continue;
                }
                line = in.readLine();
            }
            line = in.readLine();
            line = in.readLine();
            while (line != null) {
                int i;
                StringTokenizer st = new StringTokenizer(line, " ");
                String name = st.nextToken();
                int width = 10;
                if (st.hasMoreTokens()) {
                    width = Integer.parseInt(st.nextToken());
                }
                st = new StringTokenizer(in.readLine(), " ");
                int num_dim = Integer.parseInt(st.nextToken());
                String dim1 = in.readLine();
                String dim2 = null;
                if (num_dim == 2) {
                    dim2 = in.readLine();
                }
                st = new StringTokenizer(in.readLine(), " ");
                int size = Integer.parseInt(st.nextToken());
                st = new StringTokenizer(in.readLine(), " ");
                int type = Integer.parseInt(st.nextToken());
                Object[] vals = null;
                Class type_class = null;
                if (type == 1) {
                    vals = new int[size];
                    type_class = Integer.class;
                    for (i = 0; i < size; ++i) {
                        st = new StringTokenizer(in.readLine(), " ");
                        vals[i] = Integer.parseInt(st.nextToken());
                    }
                } else {
                    vals = new double[size];
                    type_class = Double.class;
                    for (i = 0; i < size; ++i) {
                        st = new StringTokenizer(in.readLine(), " ");
                        ((double[])vals)[i] = Double.parseDouble(st.nextToken());
                    }
                }
                Dimension[] dims = new MmsDimension[num_dim];
                dims[0] = (MmsDimension)this.mps.getDimension(dim1);
                if (num_dim > 1) {
                    dims[1] = (MmsDimension)this.mps.getDimension(dim2);
                }
                this.mps.addParameter(new MmsParameter(name, width, dims, type_class, vals));
                line = in.readLine();
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            this.log.severe("Problem reading parameters");
            ex.printStackTrace();
            throw ex;
        }
        catch (NumberFormatException ex) {
            this.log.severe("NumberFormatException while reading parameters");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (IOException iOException) {}
        }
        if (this.mps.getDims().isEmpty() && this.mps.getParams().isEmpty()) {
            this.mps = null;
            throw new IOException("Invalid MMS parameter file.");
        }
        return this.mps;
    }

    public static void main(String[] arg) {
        try {
            MmsParamsReader mp = new MmsParamsReader(new FileReader(arg[0]));
            ParameterSet ps = mp.read();
            System.out.println("Dimensions = " + ps.getDims());
            System.out.println("Parameters = " + ps.getParams());
        }
        catch (FileNotFoundException e) {
            System.out.println(arg[0] + " not found");
        }
        catch (IOException e) {
            System.out.println(arg[0] + " io exception");
        }
    }
}

