/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ui.calc;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import ngmf.ui.calc.JelLibrarySupport;
import ngmf.ui.calc.Util;

public class TableCalculator {
    String usage() {
        try {
            int c;
            InputStream is = this.getClass().getResourceAsStream("/ngmf/ui/calc/Functions.txt");
            if (is == null) {
                return "";
            }
            StringBuffer b = new StringBuffer();
            while ((c = is.read()) != -1) {
                b.append((char)c);
            }
            is.close();
            return b.toString();
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String apply(JelLibrarySupport jel, JTable table, String expr) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        String lhs = null;
        String rhs = expr;
        if (expr.equals("help")) {
            return this.usage();
        }
        int idx = expr.indexOf(61);
        if (idx > 0 && expr.charAt(idx + 1) != '=' && expr.charAt(idx - 1) != '!' && expr.charAt(idx - 1) != '<' && expr.charAt(idx - 1) != '>') {
            lhs = expr.substring(0, expr.indexOf(61)).trim();
            rhs = expr.substring(expr.indexOf(61) + 1).trim();
        }
        if ((expr = expr.trim()).startsWith("=")) {
            if (table.getSelectedColumns().length <= 0 || table.getSelectedRows().length <= 0) return "";
            int[] cols = table.getSelectedColumns();
            int[] rows = table.getSelectedRows();
            for (int r = 0; r < rows.length; ++r) {
                for (int c = 0; c < cols.length; ++c) {
                    model.setValueAt(expr.substring(1), rows[r], cols[c]);
                    model.fireTableCellUpdated(rows[r], cols[c]);
                }
            }
            return "";
        } else {
            if (expr.startsWith("*") || expr.startsWith("/") || expr.startsWith("+") || expr.startsWith("-")) {
                if (table.getSelectedColumns().length <= 0 || table.getSelectedRows().length <= 0) return "Error : nothing selected in table";
                int[] cols = table.getSelectedColumns();
                int[] rows = table.getSelectedRows();
                for (int r = 0; r < rows.length; ++r) {
                    for (int c = 0; c < cols.length; ++c) {
                        try {
                            String val = table.getValueAt(rows[r], cols[c]).toString() + expr;
                            CompiledExpression expr_c = Evaluator.compile(val, jel.getLibrary());
                            Object result = expr_c.evaluate(jel.getContext());
                            model.setValueAt(result, rows[r], cols[c]);
                            model.fireTableCellUpdated(rows[r], cols[c]);
                            continue;
                        }
                        catch (Throwable ex) {
                            return "Error " + ex.getMessage();
                        }
                    }
                }
                return "";
            }
            try {
                if (expr.indexOf(36) == -1) {
                    CompiledExpression expr_c = Evaluator.compile(rhs, jel.getLibrary());
                    if (lhs != null) return "";
                    try {
                        Object result = expr_c.evaluate(jel.getContext());
                        if (result == null) return "";
                        return " Result of '" + rhs + "': " + result + "\n";
                    }
                    catch (Throwable ex) {
                        return "Error " + ex.getMessage();
                    }
                }
                if (lhs != null) {
                    CompiledExpression expr_c = Evaluator.compile(rhs, jel.getLibrary());
                    if (!lhs.startsWith("$")) return "lhs array not supported yet. \n";
                    int col = Util.findColumn(model, lhs = lhs.substring(1));
                    if (col == -1) {
                        return "No such column " + lhs + "\n";
                    }
                    for (int row = 0; row < model.getRowCount(); ++row) {
                        try {
                            jel.getResolver().setRow(row);
                            Object result = expr_c.evaluate(jel.getContext());
                            if (result == null) continue;
                            model.setValueAt(result, row, col);
                            model.fireTableCellUpdated(row, col);
                            continue;
                        }
                        catch (Throwable ex) {
                            return "Error " + ex.getMessage();
                        }
                    }
                    return "";
                }
                CompiledExpression expr_c = Evaluator.compile(rhs, jel.getLibrary());
                table.clearSelection();
                table.setColumnSelectionAllowed(false);
                StringBuffer b = new StringBuffer();
                for (int row = 0; row < model.getRowCount(); ++row) {
                    try {
                        jel.getResolver().setRow(row);
                        Object result = expr_c.evaluate(jel.getContext());
                        if (result == null) continue;
                        if (result.getClass() == Boolean.class) {
                            boolean r = (Boolean)result;
                            if (!r) continue;
                            table.addRowSelectionInterval(row, row);
                            continue;
                        }
                        b.append(result);
                        continue;
                    }
                    catch (Throwable ex) {
                        return "Error " + ex.getMessage();
                    }
                }
                return b.toString();
            }
            catch (CompilationException ce) {
                StringBuffer b = new StringBuffer();
                b.append("  ERROR: ");
                b.append(ce.getMessage() + "\n");
                b.append("                       ");
                b.append(rhs + "\n");
                int column = ce.getColumn();
                for (int i = 0; i < column + 23 - 1; ++i) {
                    b.append(' ');
                }
                b.append("^\n");
                return b.toString();
            }
        }
    }
}

