/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ui.calc;

import java.util.Random;

public class RandomNormal {
    private float mean;
    private float stddev;
    private float nextPolar;
    private boolean haveNextPolar = false;
    private static Random gen = new Random();
    private static final float C1 = (float)Math.sqrt(2.9430355293715387);
    private static final float C2 = (float)(4.0 * Math.exp(0.25));
    private static final float C3 = (float)(4.0 * Math.exp(-1.35));

    public void setParameters(float mean, float stddev) {
        this.mean = mean;
        this.stddev = stddev;
    }

    public float nextCentral() {
        float sum = 0.0f;
        for (int j = 0; j < 12; ++j) {
            sum += gen.nextFloat();
        }
        return this.stddev * (sum - 6.0f) + this.mean;
    }

    public float nextPolar() {
        float u2;
        float u1;
        float r;
        if (this.haveNextPolar) {
            this.haveNextPolar = false;
            return this.nextPolar;
        }
        while ((r = (u1 = 2.0f * gen.nextFloat() - 1.0f) * u1 + (u2 = 2.0f * gen.nextFloat() - 1.0f) * u2) >= 1.0f) {
        }
        float factor = (float)((double)this.stddev * Math.sqrt(-2.0 * Math.log(r) / (double)r));
        float v1 = factor * u1 + this.mean;
        float v2 = factor * u2 + this.mean;
        this.nextPolar = v1;
        this.haveNextPolar = true;
        return v2;
    }

    public float nextRatio() {
        float v;
        float y;
        float x;
        float xx;
        float u;
        while ((u = gen.nextFloat()) == 0.0f || (xx = (x = (y = C1 * ((v = gen.nextFloat()) - 0.5f)) / u) * x) > 5.0f - C2 * u && (xx >= C3 / u + 1.4f || xx > (float)(-4.0 * Math.log(u)))) {
        }
        return this.stddev * x + this.mean;
    }
}

