/*
 * Decompiled with CFR 0.152.
 */
package ngmf.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import ngmf.ui.CommandHandler;
import ngmf.ui.Convert;
import ngmf.ui.JConsolePanel;
import ngmf.ui.TableListener;
import ngmf.ui.calc.JelLibrarySupport;
import ngmf.ui.calc.TableCalculator;
import oms3.io.CSProperties;
import oms3.io.DataIO;
import oms3.util.Stats;

public class PEditor
extends JPanel
implements CommandHandler {
    private static final long serialVersionUID = 9177364340914985294L;
    JConsolePanel cp = new JConsolePanel();
    JTable table = new JTable();
    TableListener listener = new TableListener(this.table);
    JScrollPane sp = new JScrollPane(this.table);
    CSProperties p;
    TableCalculator calc = new TableCalculator();
    JelLibrarySupport jel = new JelLibrarySupport(this.table.getModel());
    static DecimalFormat fmt = new DecimalFormat("#.#####");
    private JComboBox dimCombo;
    private JComboBox fileCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JLabel numLabel;
    private JButton saveButton;
    private JSplitPane split;

    public PEditor(List<File> file) {
        this(file.toArray(new File[0]));
    }

    public PEditor(File[] file) {
        this.initComponents();
        this.setupComponents();
        for (File f : file) {
            this.fileCombo.addItem(f);
        }
    }

    private void setupComponents() {
        this.cp.setCommandHandler(this);
        this.cp.setRows(6);
        this.cp.getOut().println("Parameter Console, type 'help' for commands.");
        this.cp.prompt();
        JScrollPane sp1 = new JScrollPane();
        sp1.setHorizontalScrollBarPolicy(31);
        sp1.setVerticalScrollBarPolicy(22);
        sp1.setViewportView(this.cp);
        sp1.setMinimumSize(new Dimension(100, 100));
        this.fileCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PEditor.this.showP((File)e.getItem());
                }
            }
        });
        this.saveButton.setIcon(new ImageIcon(PEditor.class.getResource("/ngmf/ui/save-16x16.png")));
        this.saveButton.setText("");
        this.saveButton.setToolTipText("Save.");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = (File)PEditor.this.fileCombo.getSelectedItem();
                PEditor.copy(f, new File(f.toString() + "~"));
                DataIO.save(PEditor.this.p, f, "Parameter");
            }
        });
        this.table.setSelectionMode(2);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setDoubleBuffered(true);
        this.table.setAutoResizeMode(3);
        this.table.setIntercellSpacing(new Dimension(3, 1));
        this.table.setDefaultRenderer(Object.class, new MyCellRenderer());
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(true);
        this.table.setGridColor(Color.lightGray);
        ListSelectionListener lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PEditor.this.table.getClientProperty("KV") != null) {
                    return;
                }
                if (PEditor.this.table.getRowSelectionAllowed() && PEditor.this.table.getColumnSelectionAllowed() && !e.getValueIsAdjusting()) {
                    int[] scols = PEditor.this.table.getSelectedColumns();
                    int[] srows = PEditor.this.table.getSelectedRows();
                    if (srows.length * scols.length < 2) {
                        PEditor.this.stats(null);
                        return;
                    }
                    double[] v = new double[srows.length * scols.length];
                    int vi = 0;
                    for (int i = 0; i < srows.length; ++i) {
                        int j = srows[i];
                        for (int k = 0; k < scols.length; ++k) {
                            int l = scols[k];
                            Object o = PEditor.this.table.getValueAt(j, l);
                            try {
                                v[vi++] = Double.parseDouble(o.toString());
                                continue;
                            }
                            catch (NumberFormatException E) {
                                PEditor.this.stats(null);
                                return;
                            }
                        }
                    }
                    PEditor.this.stats(v);
                }
            }
        };
        this.table.getSelectionModel().addListSelectionListener(lsl);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(lsl);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PEditor.this.table.getClientProperty("KV") != null) {
                    return;
                }
                JTableHeader header = PEditor.this.table.getTableHeader();
                TableColumnModel columns = header.getColumnModel();
                if (!columns.getColumnSelectionAllowed()) {
                    return;
                }
                int column = header.columnAtPoint(e.getPoint());
                if (column == -1) {
                    return;
                }
                int count = PEditor.this.table.getRowCount();
                if (count != 0) {
                    PEditor.this.table.setRowSelectionInterval(0, count - 1);
                }
                ListSelectionModel selection = columns.getSelectionModel();
                if (e.isShiftDown()) {
                    int anchor = selection.getAnchorSelectionIndex();
                    int lead = selection.getLeadSelectionIndex();
                    if (anchor != -1) {
                        boolean old = selection.getValueIsAdjusting();
                        selection.setValueIsAdjusting(true);
                        boolean anchorSelected = selection.isSelectedIndex(anchor);
                        if (lead != -1) {
                            if (anchorSelected) {
                                selection.removeSelectionInterval(anchor, lead);
                            } else {
                                selection.addSelectionInterval(anchor, lead);
                            }
                        }
                        if (anchorSelected) {
                            selection.addSelectionInterval(anchor, column);
                        } else {
                            selection.removeSelectionInterval(anchor, column);
                        }
                        selection.setValueIsAdjusting(old);
                    } else {
                        selection.setSelectionInterval(column, column);
                    }
                } else if (e.isControlDown()) {
                    if (selection.isSelectedIndex(column)) {
                        selection.removeSelectionInterval(column, column);
                    } else {
                        selection.addSelectionInterval(column, column);
                    }
                } else {
                    PEditor.this.table.setColumnSelectionInterval(column, column);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PEditor.this.table.setColumnSelectionAllowed(true);
            }
        });
        final JList rowHeader = new JList(new AbstractListModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSize() {
                return PEditor.this.table.getModel().getRowCount();
            }

            @Override
            public Object getElementAt(int index) {
                return new Integer(index);
            }
        });
        rowHeader.setFixedCellWidth(30);
        rowHeader.setFixedCellHeight(this.table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
        rowHeader.setOpaque(false);
        this.sp.setRowHeaderView(rowHeader);
        rowHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (PEditor.this.table.getClientProperty("KV") != null) {
                    return;
                }
                if (PEditor.this.table.getColumnCount() != 0) {
                    PEditor.this.table.setColumnSelectionInterval(0, PEditor.this.table.getColumnCount() - 1);
                }
                if ((row = rowHeader.getSelectionModel().getLeadSelectionIndex()) == -1) {
                    return;
                }
                ListSelectionModel selection = rowHeader.getSelectionModel();
                if (e.isShiftDown()) {
                    int anchor = selection.getAnchorSelectionIndex();
                    int lead = selection.getLeadSelectionIndex();
                    if (anchor != -1) {
                        boolean anchorSelected = PEditor.this.table.isRowSelected(anchor);
                        if (lead != -1) {
                            if (anchorSelected) {
                                PEditor.this.table.removeRowSelectionInterval(anchor, lead);
                            } else {
                                PEditor.this.table.addRowSelectionInterval(anchor, lead);
                            }
                        }
                        if (anchorSelected) {
                            PEditor.this.table.addRowSelectionInterval(anchor, row);
                        } else {
                            PEditor.this.table.removeRowSelectionInterval(anchor, row);
                        }
                    } else {
                        PEditor.this.table.setRowSelectionInterval(row, row);
                    }
                } else if (e.isControlDown()) {
                    if (PEditor.this.table.isRowSelected(row)) {
                        PEditor.this.table.removeRowSelectionInterval(row, row);
                    } else {
                        PEditor.this.table.addRowSelectionInterval(row, row);
                    }
                } else {
                    PEditor.this.table.setRowSelectionInterval(row, row);
                }
            }
        });
        this.dimCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String item = e.getItem().toString().trim();
                    if (item.contains("----")) {
                        return;
                    }
                    AbstractTableModel model = null;
                    if (PEditor.this.dimCombo.getSelectedIndex() == 1) {
                        model = DataIO.getProperties(PEditor.this.p);
                        PEditor.this.setTableModel(model);
                        PEditor.this.table.setAutoResizeMode(3);
                        PEditor.this.table.getColumnModel().getColumn(0).setPreferredWidth(125);
                        PEditor.this.table.getColumnModel().getColumn(0).setMaxWidth(125);
                        TableRowSorter<AbstractTableModel> sorter = new TableRowSorter<AbstractTableModel>(model);
                        PEditor.this.table.setRowSorter(sorter);
                        PEditor.this.table.putClientProperty("KV", Boolean.TRUE);
                    } else {
                        if (PEditor.this.dimCombo.getSelectedIndex() == 2) {
                            try {
                                model = DataIO.getUnBoundProperties(PEditor.this.p);
                                PEditor.this.setTableModel(model);
                                PEditor.this.table.setAutoResizeMode(3);
                                PEditor.this.table.getColumnModel().getColumn(0).setPreferredWidth(125);
                                PEditor.this.table.getColumnModel().getColumn(0).setMaxWidth(125);
                                TableRowSorter<AbstractTableModel> sorter = new TableRowSorter<AbstractTableModel>(model);
                                PEditor.this.table.setRowSorter(sorter);
                                PEditor.this.table.putClientProperty("KV", Boolean.TRUE);
                            }
                            catch (ParseException E) {
                                E.printStackTrace();
                                return;
                            }
                        }
                        if (PEditor.this.dimCombo.getSelectedIndex() > 3) {
                            try {
                                if (DataIO.playsRole(PEditor.this.p, item, "dimension")) {
                                    model = DataIO.getBoundProperties(PEditor.this.p, item);
                                } else if (DataIO.isBound(PEditor.this.p, item, 2)) {
                                    model = DataIO.get2DBounded(PEditor.this.p, item);
                                }
                                PEditor.this.table.setAutoResizeMode(0);
                                PEditor.this.table.setRowSorter(null);
                                PEditor.this.setTableModel(model);
                                PEditor.this.table.putClientProperty("KV", null);
                            }
                            catch (ParseException E) {
                                E.printStackTrace();
                                return;
                            }
                        }
                    }
                }
            }
        });
        this.split.setTopComponent(sp1);
        this.split.setBottomComponent(this.sp);
        this.split.setOneTouchExpandable(true);
        this.stats(null);
    }

    void stats(double[] v) {
        if (v == null) {
            this.numLabel.setText(" ");
        } else {
            double min = Stats.min(v);
            double max = Stats.max(v);
            double mean = Stats.mean(v);
            double range = Stats.range(v);
            double median = Stats.median(v);
            double sum = Stats.sum(v);
            this.numLabel.setText("#" + v.length + "   Sum[" + fmt.format(sum) + "] Min[" + fmt.format(min) + "]  Max[" + fmt.format(max) + "]  Mean[" + fmt.format(mean) + "]  Range[" + fmt.format(range) + "]  Median[" + fmt.format(median) + "]");
        }
    }

    private static void copy(File f1, File f2) {
        try {
            int len;
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[4096];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String handle(String cmd) {
        if (cmd.equals("clear")) {
            this.cp.clear();
            return "";
        }
        if (cmd.startsWith("new")) {
            return this.handleCreate(cmd);
        }
        if (cmd.startsWith("del")) {
            return this.handleDelete(cmd);
        }
        if (cmd.startsWith("con")) {
            return this.handleConv(cmd);
        }
        return this.calc.apply(this.jel, this.table, cmd);
    }

    private String handleConv(String cmd) {
        String[] arg = cmd.split("\\s+");
        if (arg.length == 1) {
            return " usage: con <file>.[statvar|params|data]\n";
        }
        if (arg[1].endsWith("statvar")) {
            return Convert.statvar(arg[1]);
        }
        if (arg[1].endsWith("params")) {
            return Convert.param(arg[1]);
        }
        if (arg[1].endsWith("data")) {
            return Convert.data(arg[1]);
        }
        return " cannot convert: " + arg[1];
    }

    private String handleCreate(String cmd) {
        String[] arg = cmd.split("\\s+");
        if (arg.length == 1) {
            return " usage: new [param | dim | array]\n";
        }
        if (arg[1].startsWith("p")) {
            if (arg.length < 3) {
                return " usage: new param <name>...\n";
            }
            for (int i = 2; i < arg.length; ++i) {
                this.p.put(arg[i], "");
            }
        } else if (arg[1].startsWith("d")) {
            if (arg.length != 3) {
                return " usage: new dim <name>\n";
            }
            String name = arg[2];
            this.p.put(name, "");
            this.p.getInfo(name).put("role", "dimension");
        } else if (arg[1].startsWith("a")) {
            if (arg.length < 4) {
                return " usage: new array <name> <dim>\n";
            }
            String name = arg[2];
            this.p.put(name, "");
            this.p.getInfo(name).put("bound", arg[3]);
        } else {
            return " usage: new [param | dim | array]\n";
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.sp.repaint();
        return "";
    }

    private String handleDelete(String cmd) {
        String[] arg = cmd.split("\\s+");
        if (arg.length < 2) {
            return " usage: del <name>...\n";
        }
        for (int i = 1; i < arg.length; ++i) {
            this.p.remove(arg[i]);
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.sp.repaint();
        return "";
    }

    private void setTableModel(AbstractTableModel model) {
        this.table.setModel(model);
        this.jel.setModel(model);
        model.fireTableDataChanged();
        this.sp.repaint();
    }

    private void showP(File file) {
        try {
            this.p = DataIO.properties(new FileReader(file), "Parameter");
            List<String> dims = DataIO.keysByMeta(this.p, "role", "dimension");
            List<String> dims2d = DataIO.keysForBounds(this.p, 2);
            this.dimCombo.removeAllItems();
            this.dimCombo.addItem("---- GENERAL ----");
            this.dimCombo.addItem(" <ALL>");
            this.dimCombo.addItem(" <SCALARS>");
            this.dimCombo.addItem("------ DIMS -----");
            for (String s : dims) {
                this.dimCombo.addItem("  " + s);
            }
            this.dimCombo.addItem("------- 2D -------");
            for (String s : dims2d) {
                this.dimCombo.addItem("  " + s);
            }
            this.dimCombo.setSelectedIndex(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel9 = new JLabel();
        this.split = new JSplitPane();
        this.jToolBar1 = new JToolBar();
        this.saveButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jLabel2 = new JLabel();
        this.dimCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.fileCombo = new JComboBox();
        this.jPanel1 = new JPanel();
        this.numLabel = new JLabel();
        this.jLabel6.setText("jLabel6");
        this.jLabel9.setText("jLabel9");
        this.setLayout(new BorderLayout());
        this.split.setOrientation(0);
        this.add((Component)this.split, "Center");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.saveButton.setText("save");
        this.saveButton.setFocusable(false);
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setVerticalTextPosition(3);
        this.jToolBar1.add(this.saveButton);
        this.jToolBar1.add(this.jSeparator1);
        this.jLabel2.setText("  Filter: ");
        this.jToolBar1.add(this.jLabel2);
        this.jToolBar1.add(this.dimCombo);
        this.jLabel1.setText("     File: ");
        this.jToolBar1.add(this.jLabel1);
        this.jToolBar1.add(this.fileCombo);
        this.add((Component)this.jToolBar1, "First");
        this.numLabel.setText(" ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.numLabel, -1, 308, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numLabel, -1, -1, Short.MAX_VALUE));
        this.add((Component)this.jPanel1, "Last");
    }

    public static JFrame create(File[] csv) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        final PEditor p = new PEditor(csv);
        JFrame f = new JFrame();
        f.getContentPane().add(p);
        f.setTitle("Parameter Editor v3.0");
        f.setIconImage(new ImageIcon(PEditor.class.getResource("/ngmf/ui/table.png")).getImage());
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.setLocation(500, 200);
        f.setVisible(true);
        f.toFront();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                p.cp.requestFocus();
            }
        });
        return f;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("work", "c:/tmp");
        File file = new File("C:/od/projects/oms3.prj.prms2008/data/efc_svntest3_1.csv");
        PEditor.create(new File[]{file});
    }

    static class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private static Color whiteColor = new Color(254, 254, 254);
        private static Color alternateColor = new Color(244, 244, 244);
        private static Color selectedColor = new Color(193, 210, 238);

        MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            Color bg = !selected ? (row % 2 == 0 ? alternateColor : whiteColor) : selectedColor;
            this.setBackground(bg);
            this.setForeground(Color.black);
            return this;
        }
    }

    static class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

