/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.string;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.properties.DefaultPropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.string.StringFileNameExtractor;
import org.geotools.resources.i18n.Errors;

public class StringFileNameExtractorSPI
extends DefaultPropertiesCollectorSPI
implements PropertiesCollectorSPI {
    public StringFileNameExtractorSPI() {
        super("StringFileNameExtractorSPI");
    }

    @Override
    public PropertiesCollector create(Object o, List<String> propertyNames) {
        URL source = null;
        if (o instanceof URL) {
            source = (URL)o;
        } else if (o instanceof File) {
            source = DataUtilities.fileToURL((File)((File)o));
        } else if (o instanceof String) {
            try {
                source = new URL((String)o);
            }
            catch (MalformedURLException e) {
                return null;
            }
        } else {
            return null;
        }
        Properties properties = Utils.loadPropertiesFromURL(source);
        if (properties == null) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"Unable to load source for properties collector", (Object)source));
        }
        if (properties.containsKey("regex")) {
            return new StringFileNameExtractor(this, propertyNames, properties.getProperty("regex"));
        }
        return null;
    }
}

