/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel;

import org.eclipse.swt.graphics.ImageData;

final class ImageMetricPosition {
    private int maxX;
    private int maxY;
    private int hScrollValue = 0;
    private int vScrollValue = 0;
    private int hScrollBeforeZoom = 0;
    private int vScrollBeforeZoom = 0;
    private float scale = 1.0f;
    private float previousScale;
    private float scaleBeforeZoom;
    private ImageData imageData;

    public void setImageData(ImageData data) {
        this.imageData = data;
    }

    public void updateMaxXY(int x, int y) {
        this.maxX = x;
        this.maxY = y;
    }

    public void updateMaxXY() {
        this.maxX = Math.round((float)this.imageData.width * this.scale);
        this.maxY = Math.round((float)this.imageData.height * this.scale);
    }

    public void updateScrollValues(int hScroll, int vScroll) {
        this.hScrollValue = hScroll;
        this.vScrollValue = vScroll;
    }

    public void updateScale(float scale) {
        this.scale = scale;
        this.scaleBeforeZoom = this.previousScale;
        this.previousScale = scale;
    }

    public void setDefaultValues() {
        assert (this.imageData != null) : "can't be null imageData";
        this.scale = 1.0f;
        this.hScrollValue = 0;
        this.vScrollValue = 0;
        this.hScrollBeforeZoom = 0;
        this.vScrollBeforeZoom = 0;
        this.previousScale = 1.0f;
        this.maxX = this.imageData.width;
        this.maxY = this.imageData.height;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getHScrollValue() {
        return this.hScrollValue;
    }

    public int getVScrollValue() {
        return this.vScrollValue;
    }

    public float getScale() {
        return this.scale;
    }

    public float getPreviousScale() {
        return this.previousScale;
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void increaseScale(float add) {
        this.scale += add;
    }

    public void decreaseScale(float subtractValue) {
        if (this.scale - subtractValue > 0.0f) {
            this.scale -= subtractValue;
        }
    }

    public void updatePreviousScale() {
        this.scaleBeforeZoom = this.previousScale;
        this.previousScale = this.scale;
    }

    public void updatePreviousScroll() {
        this.hScrollBeforeZoom = this.hScrollValue;
        this.vScrollBeforeZoom = this.vScrollValue;
    }

    public float getScaleBeforeZoom() {
        return this.scaleBeforeZoom;
    }

    public int getHScrollBeforeZoom() {
        return this.hScrollBeforeZoom;
    }

    public int getVScrollBeforeZoom() {
        return this.vScrollBeforeZoom;
    }
}

