/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.image.georeferencing.internal.ui.imagepanel;

import eu.udig.image.georeferencing.internal.i18n.Messages;
import eu.udig.image.georeferencing.internal.preferences.Preferences;
import eu.udig.image.georeferencing.internal.process.MarkModel;
import eu.udig.image.georeferencing.internal.ui.GeoReferencingCommand;
import eu.udig.image.georeferencing.internal.ui.GeoReferencingComposite;
import eu.udig.image.georeferencing.internal.ui.GeoreferencingCommandEventChange;
import eu.udig.image.georeferencing.internal.ui.InputEvent;
import eu.udig.image.georeferencing.internal.ui.MainComposite;
import eu.udig.image.georeferencing.internal.ui.MouseSelectionListener;
import eu.udig.image.georeferencing.internal.ui.imagepanel.ImageMetricPosition;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenter;
import eu.udig.image.georeferencing.internal.ui.imagepanel.MarkImagePresenterFactory;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.AddMarkImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.DeleteMarkImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ImageInputEvent;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.MoveMarkImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.PanImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ZoomInImageTool;
import eu.udig.image.georeferencing.internal.ui.imagepanel.tools.ZoomOutImageTool;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class ImageComposite
extends Composite
implements Observer,
GeoReferencingComposite {
    private Composite imageComposite = null;
    private Composite buttonComposite = null;
    private Canvas canvas = null;
    private Image image = null;
    private IToolContext toolContext = null;
    private ToolBar imageToolBar = null;
    private ToolItem itemLoad = null;
    private ToolItem itemAdd = null;
    private ToolItem itemDelete = null;
    private ToolItem itemDeleteAll = null;
    private ToolItem itemDragDrop = null;
    private ToolItem itemZoomIn = null;
    private ToolItem itemZoomOut = null;
    private ToolItem itemZoomFit = null;
    private ToolItem itemPan = null;
    private ImageRegistry registry = null;
    private Thread uiThread = null;
    private List<MarkImagePresenter> markPresenterList = new LinkedList<MarkImagePresenter>();
    private GeoReferencingCommand cmd = null;
    private ImageMetricPosition imageMetrics = null;
    private List<ImageTool> tools = null;
    private ZoomFeedBack zoomFeedback = null;
    private MouseSelectionListener mapMouseSelectionListener = null;
    private MouseSelectionListener coordPanelMouseSelectionListener = null;

    public ImageComposite(GeoReferencingCommand cmd, Composite parent, int style) {
        super(parent, style);
        assert (cmd != null);
        this.cmd = cmd;
        this.createContent();
        this.pack();
    }

    private void createContent() {
        this.registry = this.createImageRegistry();
        this.uiThread = Thread.currentThread();
        this.imageMetrics = new ImageMetricPosition();
        this.createListeners();
        this.createNewTools();
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 3;
        gridData2.verticalAlignment = 4;
        GridLayout gridlayout = new GridLayout(3, true);
        this.setLayout((Layout)gridlayout);
        this.buttonComposite = new Composite((Composite)this, 2048);
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setLayout((Layout)gridlayout);
        this.createButtons(this.buttonComposite);
        this.imageComposite = new Composite((Composite)this, 2048);
        this.imageComposite.setLayoutData((Object)gridData2);
        this.imageComposite.setLayout((Layout)gridlayout);
        this.createCanvas(this.imageComposite);
    }

    private void createListeners() {
        this.mapMouseSelectionListener = new MouseSelectionListener(){

            @Override
            public void inEvent(MarkModel mark) {
                ImageComposite.this.mouseOverFeedback(mark);
            }

            @Override
            public void outEvent(MarkModel mark) {
                ImageComposite.this.mouseNotOverFeedback(mark);
            }
        };
        this.coordPanelMouseSelectionListener = new MouseSelectionListener(){

            @Override
            public void inEvent(MarkModel mark) {
                ImageComposite.this.mouseOverFeedback(mark);
            }

            @Override
            public void outEvent(MarkModel mark) {
                ImageComposite.this.mouseNotOverFeedback(mark);
            }
        };
    }

    private ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry(this.getDisplay());
        String opId = "DeleteAll";
        String imgFile = "image/cancel_all_co2.gif";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "Delete";
        imgFile = "image/clear_co2.gif";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "Load";
        imgFile = "image/folder.png";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "Add";
        imgFile = "image/placemark_pointer2.gif";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "Move";
        imgFile = "image/movemarker.png";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "ZoomIn";
        imgFile = "image/zoom-in-5.png";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "ZoomOut";
        imgFile = "image/zoom-out-5.png";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "ZoomFit";
        imgFile = "image/zoom_extent.gif";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        opId = "Pan";
        imgFile = "image/pan.png";
        registry.put(opId, ImageDescriptor.createFromFile(ImageComposite.class, (String)imgFile));
        return registry;
    }

    private void createNewTools() {
        this.tools = new LinkedList<ImageTool>();
        Cursor cursor = null;
        Image image = null;
        Display device = Display.getCurrent();
        image = this.registry.get("Add");
        cursor = new Cursor((Device)device, image.getImageData(), 8, 8);
        AddMarkImageTool addTool = new AddMarkImageTool(cursor, this);
        image = this.registry.get("Delete");
        cursor = new Cursor((Device)device, image.getImageData(), 1, 14);
        DeleteMarkImageTool deleteTool = new DeleteMarkImageTool(cursor, this);
        image = this.registry.get("Move");
        cursor = new Cursor((Device)device, image.getImageData(), 6, 6);
        MoveMarkImageTool moveTool = new MoveMarkImageTool(cursor, this);
        image = this.registry.get("ZoomIn");
        cursor = new Cursor((Device)device, image.getImageData(), 5, 5);
        ZoomInImageTool zoomInTool = new ZoomInImageTool(cursor, this);
        image = this.registry.get("ZoomOut");
        cursor = new Cursor((Device)device, image.getImageData(), 5, 5);
        ZoomOutImageTool zoomOutTool = new ZoomOutImageTool(cursor, this);
        image = this.registry.get("Pan");
        cursor = new Cursor((Device)device, image.getImageData(), 7, 7);
        PanImageTool panTool = new PanImageTool(cursor, this);
        this.tools.add(addTool);
        this.tools.add(deleteTool);
        this.tools.add(moveTool);
        this.tools.add(zoomInTool);
        this.tools.add(zoomOutTool);
        this.tools.add(panTool);
    }

    private void setToolActive(Class<?> clazz) {
        for (ImageTool tool : this.tools) {
            if (tool.getClass().equals(clazz)) {
                tool.setActive(true);
                continue;
            }
            tool.setActive(false);
        }
    }

    private void createButtons(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        this.imageToolBar = new ToolBar(parent, 0x2000000);
        this.itemLoad = new ToolItem(this.imageToolBar, 8);
        this.itemLoad.setImage(this.registry.get("Load"));
        this.itemLoad.setToolTipText(Messages.ImageComposite_itemLoadTooltip);
        this.itemLoad.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.loadFile();
            }
        });
        this.itemLoad.setEnabled(false);
        this.itemAdd = new ToolItem(this.imageToolBar, 16);
        this.itemAdd.setImage(this.registry.get("Add"));
        this.itemAdd.setToolTipText(Messages.ImageComposite_itemAddTooltip);
        this.itemAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.setToolActive(AddMarkImageTool.class);
            }
        });
        this.itemDelete = new ToolItem(this.imageToolBar, 16);
        this.itemDelete.setImage(this.registry.get("Delete"));
        this.itemDelete.setToolTipText(Messages.ImageComposite_itemDeleteTooltip);
        this.itemDelete.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.setToolActive(DeleteMarkImageTool.class);
            }
        });
        this.itemDragDrop = new ToolItem(this.imageToolBar, 16);
        this.itemDragDrop.setImage(this.registry.get("Move"));
        this.itemDragDrop.setToolTipText(Messages.ImageComposite_itemDragDropTooltip);
        this.itemDragDrop.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.setToolActive(MoveMarkImageTool.class);
            }
        });
        this.itemZoomIn = new ToolItem(this.imageToolBar, 16);
        this.itemZoomIn.setImage(this.registry.get("ZoomIn"));
        this.itemZoomIn.setToolTipText(Messages.ImageComposite_itemZoomInTooltip);
        this.itemZoomIn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.setToolActive(ZoomInImageTool.class);
            }
        });
        this.itemZoomOut = new ToolItem(this.imageToolBar, 16);
        this.itemZoomOut.setImage(this.registry.get("ZoomOut"));
        this.itemZoomOut.setToolTipText(Messages.ImageComposite_itemZoomOutTooltip);
        this.itemZoomOut.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.setToolActive(ZoomOutImageTool.class);
            }
        });
        this.itemPan = new ToolItem(this.imageToolBar, 16);
        this.itemPan.setImage(this.registry.get("Pan"));
        this.itemPan.setToolTipText(Messages.ImageComposite_itemPanTooltip);
        this.itemPan.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.setToolActive(PanImageTool.class);
            }
        });
        this.itemDeleteAll = new ToolItem(this.imageToolBar, 8);
        this.itemDeleteAll.setImage(this.registry.get("DeleteAll"));
        this.itemDeleteAll.setToolTipText(Messages.ImageComposite_itemDelAllTooltip);
        this.itemDeleteAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.deactivateTools();
                ImageComposite.this.deleteAllPoints();
                ImageComposite.this.getMainComposite().refreshMapGraphicLayer();
            }
        });
        this.itemZoomFit = new ToolItem(this.imageToolBar, 8);
        this.itemZoomFit.setImage(this.registry.get("ZoomFit"));
        this.itemZoomFit.setToolTipText(Messages.ImageComposite_itemFitTooltip);
        this.itemZoomFit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImageComposite.this.zoomFit();
            }
        });
        this.setItemsEnabled(false);
        this.setCertainToolsEnabled(false);
    }

    private void deactivateTools() {
        for (ImageTool tool : this.tools) {
            tool.setActive(false);
        }
        this.setItemsSelected(false);
    }

    private void setItemsSelected(boolean selected) {
        this.itemAdd.setSelection(selected);
        this.itemDelete.setSelection(selected);
        this.itemDragDrop.setSelection(selected);
        this.itemDeleteAll.setSelection(selected);
        this.itemZoomIn.setSelection(selected);
        this.itemZoomOut.setSelection(selected);
        this.itemZoomFit.setSelection(selected);
        this.itemPan.setSelection(selected);
    }

    private void setItemsEnabled(boolean enabled) {
        this.itemAdd.setEnabled(enabled);
        this.itemZoomIn.setEnabled(enabled);
        this.itemZoomOut.setEnabled(enabled);
        this.itemZoomFit.setEnabled(enabled);
        this.itemPan.setEnabled(enabled);
    }

    private void setCertainToolsEnabled(boolean enabled) {
        this.itemDelete.setEnabled(enabled);
        this.itemDragDrop.setEnabled(enabled);
        this.itemDeleteAll.setEnabled(enabled);
        if (!enabled) {
            this.itemDelete.setSelection(false);
            this.itemDragDrop.setSelection(false);
            this.itemDeleteAll.setSelection(false);
        }
    }

    private void createCanvas(Composite parent) {
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 3;
        gridData2.verticalAlignment = 4;
        this.canvas = new Canvas(parent, 0x20000008);
        this.canvas.setLayoutData((Object)gridData2);
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ImageComposite.this.performAction(e, InputEvent.MOUSE_UP);
            }

            public void mouseDown(MouseEvent e) {
                ImageComposite.this.performAction(e, InputEvent.MOUSE_DOWN);
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ImageComposite.this.performAction(e, InputEvent.MOUSE_DRAG);
            }
        });
        this.canvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                ImageComposite.this.performAction(e, InputEvent.MOUSE_SCROLL);
            }
        });
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (ImageComposite.this.image == null) {
                    return;
                }
                GC gc = event.gc;
                ImageData imageData = ImageComposite.this.imageMetrics.getImageData();
                if (ImageComposite.this.zoomFeedback != null) {
                    ImageComposite.this.zoomFeedback(gc, imageData);
                } else {
                    int w = Math.round((float)imageData.width * ImageComposite.this.imageMetrics.getScale());
                    int h = Math.round((float)imageData.height * ImageComposite.this.imageMetrics.getScale());
                    gc.drawImage(ImageComposite.this.image, 0, 0, imageData.width, imageData.height, ImageComposite.this.imageMetrics.getHScrollValue() + imageData.x, ImageComposite.this.imageMetrics.getVScrollValue() + imageData.y, w, h);
                }
            }
        });
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (ImageComposite.this.image == null) {
                    return;
                }
                ImageComposite.this.imageMetrics.updateMaxXY();
            }
        });
    }

    private void loadFile() {
        this.setCursor(Display.getCurrent().getSystemCursor(1));
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
        dialog.setFileName(Preferences.getImagePath());
        String file = dialog.open();
        if (file != null && !file.equals("")) {
            this.image = new Image((Device)Display.getCurrent(), file);
            this.setDefaultLoadData();
            Preferences.setImagePath(file);
            this.cmd.setImagePath(file);
            this.cmd.setImageData(this.imageMetrics.getImageData());
            this.canvas.redraw(0, 0, this.canvas.getClientArea().width, this.canvas.getClientArea().height, false);
            this.deleteAllPoints();
            this.getMainComposite().refreshMapGraphicLayer();
        }
        this.setCursor(null);
    }

    private void setDefaultLoadData() {
        assert (this.image != null);
        assert (this.imageMetrics != null);
        this.imageMetrics.setImageData(this.image.getImageData());
        this.imageMetrics.setDefaultValues();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof GeoreferencingCommandEventChange)) {
            return;
        }
        GeoreferencingCommandEventChange cmdEvent = (GeoreferencingCommandEventChange)arg;
        switch (cmdEvent.getEvent()) {
            case IMAGE_LOADED: {
                this.setItemsEnabled(true);
                break;
            }
            default: {
                this.setCertainToolsEnabled(this.cmd.canEnableImageTools());
            }
        }
    }

    private void resetRadioButtons() {
        this.itemAdd.setSelection(false);
        this.itemDelete.setSelection(false);
        this.itemDragDrop.setSelection(false);
        this.itemZoomIn.setSelection(false);
        this.itemZoomOut.setSelection(false);
        this.itemPan.setSelection(false);
    }

    public void deleteAllPoints() {
        this.markPresenterList.clear();
        this.cmd.deleteAllMarks();
        this.canvas.redraw();
        this.canvas.setCursor(null);
        this.resetRadioButtons();
        this.deactivateTools();
    }

    private void performAction(MouseEvent e, InputEvent eventType) {
        int x = e.x;
        int y = e.y;
        ImageInputEvent event = new ImageInputEvent(e, eventType, x, y);
        ImageTool tool = this.getActiveTool();
        if (tool == null) {
            return;
        }
        this.canvas.setCursor(tool.getCursor());
        tool.eventHandle(event);
    }

    private ImageTool getActiveTool() {
        for (ImageTool tool : this.tools) {
            if (!tool.isActive()) continue;
            return tool;
        }
        return null;
    }

    @Override
    public void setContext(IToolContext newContext) {
        if (this.toolContext == null) {
            this.getMainComposite().getMapMarkGraphic().addMouseSelectionListener(this.mapMouseSelectionListener);
            this.getMainComposite().addMouseSelectionListenerToCoordinate(this.coordPanelMouseSelectionListener);
        }
        this.toolContext = newContext;
        if (this.cmd.getMap() != null) {
            this.itemLoad.setEnabled(true);
        }
    }

    public void close(MainComposite mainComposite) {
        if (this.toolContext != null) {
            mainComposite.getMapMarkGraphic().deleteMouseSelectionListener(this.mapMouseSelectionListener);
            mainComposite.deleteMouseSelectionListenerToCoordinate(this.coordPanelMouseSelectionListener);
        }
    }

    public void createMarks(Map<String, MarkModel> marks) {
        int hScroll = Math.abs(this.imageMetrics.getHScrollValue());
        int vScroll = Math.abs(this.imageMetrics.getVScrollValue());
        Set<Map.Entry<String, MarkModel>> entrySet = marks.entrySet();
        for (Map.Entry<String, MarkModel> entry : entrySet) {
            MarkModel markModel = entry.getValue();
            Point position = new Point(markModel.getXImage(), markModel.getYImage());
            MarkImagePresenter markPresenter = MarkImagePresenterFactory.createMarkPresenter(markModel, position, hScroll, vScroll, this.getCanvas(), this.getScale());
            this.addMarkPresenter(markPresenter);
            this.cmd.addMark(markModel);
        }
        this.cmd.evalPrecondition();
        this.canvas.redraw();
    }

    public MainComposite getMainComposite() {
        Composite parent = this.getParent();
        while (!(parent instanceof MainComposite)) {
            parent = parent.getParent();
        }
        return (MainComposite)parent;
    }

    public void setEnabled(boolean enabled) {
        this.imageToolBar.setEnabled(enabled);
        this.canvas.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public float getScale() {
        return this.imageMetrics.getScale();
    }

    public void broadcastPanEvent() {
        int hScroll = Math.abs(this.imageMetrics.getHScrollValue());
        int vScroll = Math.abs(this.imageMetrics.getVScrollValue());
        for (MarkImagePresenter presenter : this.markPresenterList) {
            presenter.eventHandler(InputEvent.PAN, hScroll, vScroll);
        }
    }

    public void broadcastZoomEvent() {
        for (MarkImagePresenter presenter : this.markPresenterList) {
            presenter.eventHandler(InputEvent.ZOOM, this.imageMetrics.getScale());
        }
    }

    private void zoomFit() {
        this.imageMetrics.updateScrollValues(0, 0);
        ImageData imageData = this.imageMetrics.getImageData();
        float canvasHeight = this.canvas.getClientArea().height;
        float canvasWidth = this.canvas.getClientArea().width;
        float imageHeight = imageData.height;
        float imageWidth = imageData.width;
        float heightFactor = canvasHeight / imageHeight;
        float widthFactor = canvasWidth / imageWidth;
        if (heightFactor > widthFactor) {
            this.imageMetrics.updateScale(heightFactor);
        } else {
            this.imageMetrics.updateScale(widthFactor);
        }
        this.updateZoomState();
    }

    private void updateZoomState() {
        this.imageMetrics.updateMaxXY();
        this.broadcastPanEvent();
        this.broadcastZoomEvent();
        if (this.image != null) {
            this.canvas.redraw();
        }
    }

    public MarkImagePresenter getMarkUnderCursor(int x, int y) {
        for (MarkImagePresenter presenter : this.markPresenterList) {
            if (!presenter.eventHandler(InputEvent.MOUSE_OVER, x, y)) continue;
            return presenter;
        }
        return null;
    }

    public List<MarkImagePresenter> getMarkPresenterList() {
        return this.markPresenterList;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GeoReferencingCommand getCmd() {
        return this.cmd;
    }

    public void addMarkPresenter(MarkImagePresenter newMarkPresenter) {
        this.markPresenterList.add(newMarkPresenter);
    }

    public Rectangle getCanvasClientArea() {
        return this.canvas.getClientArea();
    }

    public void canvasRedraw() {
        this.canvas.redraw();
    }

    public int getHScrollValue() {
        return this.imageMetrics.getHScrollValue();
    }

    public int getVScrollValue() {
        return this.imageMetrics.getVScrollValue();
    }

    public int getMaxX() {
        return this.imageMetrics.getMaxX();
    }

    public int getMaxY() {
        return this.imageMetrics.getMaxY();
    }

    public void updateScrollValues(int xScrollSelection, int yScrollSelection) {
        this.imageMetrics.updateScrollValues(xScrollSelection, yScrollSelection);
    }

    public void increaseScale(float addValue) {
        this.imageMetrics.increaseScale(addValue);
    }

    public void decreaseScale(float subtractValue) {
        this.imageMetrics.decreaseScale(subtractValue);
    }

    public boolean validateInside(Point point) {
        return this.image.getBounds().contains(point);
    }

    public void focusPosition(int x, int y) {
        int VScroll;
        int HScroll;
        ImageData imageData = this.imageMetrics.getImageData();
        int w = Math.round((float)imageData.width * this.imageMetrics.getScale());
        int h = Math.round((float)imageData.height * this.imageMetrics.getScale());
        Rectangle area = this.getCanvasClientArea();
        if (area.width >= w || area.height >= h) {
            HScroll = 0;
            VScroll = 0;
        } else {
            float oldHScrollValue = this.imageMetrics.getHScrollValue();
            float oldVScrollValue = this.imageMetrics.getVScrollValue();
            int xImg = x + Math.abs(Math.round(oldHScrollValue));
            int yImg = y + Math.abs(Math.round(oldVScrollValue));
            int actualXimg = Math.round((float)Math.round((float)xImg * this.imageMetrics.getScale()) / this.imageMetrics.getPreviousScale());
            int actualYimg = Math.round((float)Math.round((float)yImg * this.imageMetrics.getScale()) / this.imageMetrics.getPreviousScale());
            HScroll = -Math.abs(actualXimg - x);
            VScroll = -Math.abs(actualYimg - y);
            if (HScroll != 0 && Math.abs(HScroll) + this.imageMetrics.getMaxX() < area.width) {
                HScroll = 0;
            }
            if (VScroll != 0 && Math.abs(VScroll) + this.imageMetrics.getMaxY() < area.height) {
                VScroll = 0;
            }
        }
        this.imageMetrics.updatePreviousScroll();
        this.imageMetrics.updateScrollValues(HScroll, VScroll);
        this.imageMetrics.updatePreviousScale();
        this.updateZoomState();
    }

    public void setZoomInFeedback(int x, int y) {
        this.zoomFeedback = new ZoomFeedBack(x, y, ZoomFeedBack.ZOOM_TYPE.ZOOM_IN);
    }

    public void setZoomOutFeedback(int x, int y) {
        this.zoomFeedback = new ZoomFeedBack(x, y, ZoomFeedBack.ZOOM_TYPE.ZOOM_OUT);
    }

    private void zoomFeedback(GC gc, ImageData imageData) {
        int w = Math.round((float)imageData.width * this.imageMetrics.getScaleBeforeZoom());
        int h = Math.round((float)imageData.height * this.imageMetrics.getScaleBeforeZoom());
        gc.drawImage(this.image, 0, 0, imageData.width, imageData.height, this.imageMetrics.getHScrollBeforeZoom() + imageData.x, this.imageMetrics.getVScrollBeforeZoom() + imageData.y, w, h);
        switch (this.zoomFeedback.type) {
            case ZOOM_IN: {
                this.zoomInFeedBack(gc, this.zoomFeedback.x, this.zoomFeedback.y, this.zoomFeedback.startNumber);
                break;
            }
            case ZOOM_OUT: {
                this.zoomOutFeedBack(gc, this.zoomFeedback.x, this.zoomFeedback.y, this.zoomFeedback.startNumber);
                break;
            }
        }
        this.canvas.redraw();
    }

    private void zoomInFeedBack(GC gc, int x, int y, int startNumber) {
        this.drawZoomFeedBack(gc, x, y, startNumber);
        if (startNumber == 3) {
            this.zoomFeedback = null;
        } else {
            ++this.zoomFeedback.startNumber;
        }
    }

    private void zoomOutFeedBack(GC gc, int x, int y, int startNumber) {
        this.drawZoomFeedBack(gc, x, y, startNumber);
        if (startNumber == 1) {
            this.zoomFeedback = null;
        } else {
            --this.zoomFeedback.startNumber;
        }
    }

    private void drawZoomFeedBack(GC gc, int x, int y, int startNumber) {
        Color c = Color.RED;
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color(gc.getDevice(), c.getRed(), c.getGreen(), c.getBlue());
        gc.setForeground(color);
        gc.setBackground(color);
        int subtractValue = 0;
        int addValue = 0;
        switch (startNumber) {
            case 1: {
                subtractValue = 15;
                addValue = 30;
                break;
            }
            case 2: {
                subtractValue = 20;
                addValue = 40;
                break;
            }
            case 3: {
                subtractValue = 25;
                addValue = 50;
                break;
            }
        }
        gc.drawRectangle(x - subtractValue, y - subtractValue, addValue, addValue);
        gc.drawLine(x, y + subtractValue, x, y + addValue);
        gc.drawLine(x, y - subtractValue, x, y - addValue);
        gc.drawLine(x - subtractValue, y, x - addValue, y);
        gc.drawLine(x + subtractValue, y, x + addValue, y);
    }

    private void mouseOverFeedback(MarkModel mark) {
        for (MarkImagePresenter presenter : this.markPresenterList) {
            if (presenter.getMarkModel().equals(mark)) {
                presenter.showSelectedFeedback(true);
                continue;
            }
            presenter.showSelectedFeedback(false);
        }
        this.canvas.redraw();
    }

    private void mouseNotOverFeedback(MarkModel mark) {
        for (MarkImagePresenter presenter : this.markPresenterList) {
            if (!presenter.getMarkModel().equals(mark)) continue;
            presenter.showSelectedFeedback(false);
        }
        this.canvas.redraw();
    }

    public void addMouseSelectionListener(MouseSelectionListener listener) {
        for (ImageTool tool : this.tools) {
            tool.addMouseSelectionListener(listener);
        }
    }

    public void deleteMouseSelectionListener(MouseSelectionListener listener) {
        for (ImageTool tool : this.tools) {
            tool.deleteMouseSelectionListener(listener);
        }
    }

    static class ZoomFeedBack {
        protected int x;
        protected int y;
        protected int startNumber;
        protected ZOOM_TYPE type;

        public ZoomFeedBack(int x, int y, ZOOM_TYPE type) {
            this.x = x;
            this.y = y;
            this.type = type;
            switch (type) {
                case ZOOM_IN: {
                    this.startNumber = 1;
                    break;
                }
                case ZOOM_OUT: {
                    this.startNumber = 3;
                    break;
                }
            }
        }

        public static enum ZOOM_TYPE {
            ZOOM_IN,
            ZOOM_OUT;

        }
    }
}

